/*
 * Copyright (c) 2025, Salesforce, Inc.,
 * All rights reserved.
 * For full license text, see the LICENSE.txt file
 */
%dw 2.9
import * from dw::javaplain::Functions

type ContentDocumentId = String

type ContentDocumentMetadata = {
    fileName: String,
    description?: String,
    size?: Number
}

type ContentDocument = ContentDocumentMetadata & {
    content: Binary
}

var moduleFQN = "com::mulesoft::connectivity::cds::api::ContentDocumentService"

fun createContentDocument(fileName: String, description: String | Null, content: Binary): ContentDocumentId =
    invoke<String>(moduleFQN, "createContentDocument", [fileName, description, content])

fun getContentDocument(id: ContentDocumentId): ContentDocument =
    invoke<ContentDocument>(moduleFQN, "getContentDocument", [id])

fun getContentFromDocument(id: ContentDocumentId): Binary = getContentDocument(id).content
