/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.cds.function;

import com.mulesoft.connectivity.cds.function.AbstractContentDocumentFunction;
import com.mulesoft.connectivity.cds.model.ContentDocumentModel;
import com.mulesoft.connectivity.cds.repository.ContentDocumentRepositoryInterface;
import com.mulesoft.connectivity.cds.utils.ServiceUtils;
import java.io.InputStream;
import org.jspecify.annotations.Nullable;
import org.mule.weave.v2.module.javaplain.api.contribution.JavaPlainBasedFunctionResult;
import org.mule.weave.v2.module.javaplain.api.contribution.ServiceProvider;

public class CreateContentDocumentFunction
extends AbstractContentDocumentFunction {
    private static final String FUNCTION_NAME = "createContentDocument";

    public static CreateContentDocumentFunction getInstance() {
        return new CreateContentDocumentFunction();
    }

    public JavaPlainBasedFunctionResult call(@Nullable Object @Nullable [] args, ServiceProvider serviceProvider) {
        Object object;
        Object descriptionArg;
        Object object2;
        Object object3 = object2 = args != null && args.length > 0 ? args[0] : null;
        if (!(object2 instanceof String)) {
            throw new IllegalArgumentException("Parameter 'fileName' must be a String");
        }
        String fileName = (String)object2;
        Object object4 = descriptionArg = args.length > 1 && args[1] != null ? args[1] : null;
        if (descriptionArg != null && !(descriptionArg instanceof String)) {
            throw new IllegalArgumentException("Parameter 'description' must be a String or null");
        }
        String description = (String)descriptionArg;
        Object object5 = object = args.length > 2 ? args[2] : null;
        if (!(object instanceof InputStream)) {
            throw new IllegalArgumentException("Parameter 'content' must be Binary/InputStream");
        }
        InputStream contentStream = (InputStream)object;
        return this.call(fileName, description, contentStream, ServiceUtils.lookupService(serviceProvider, ContentDocumentRepositoryInterface.class));
    }

    private JavaPlainBasedFunctionResult call(String fileName, @Nullable String description, InputStream contentStream, ContentDocumentRepositoryInterface service) {
        ContentDocumentModel document = CreateContentDocumentFunction.createContentDocumentModel(fileName, description);
        String id = service.createContentDocument(document, contentStream);
        return () -> id;
    }

    static ContentDocumentModel createContentDocumentModel(String fileName, @Nullable String description) {
        String fileExtension;
        String title;
        int pos = fileName.lastIndexOf(46);
        if (pos > 0 && pos < fileName.length() - 1) {
            title = fileName.substring(0, pos);
            fileExtension = fileName.substring(pos + 1);
        } else {
            title = fileName;
            fileExtension = null;
        }
        return new ContentDocumentModel(title, description, null, fileExtension);
    }

    public String functionName() {
        return FUNCTION_NAME;
    }
}

