/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.internal.auth;

import com.mulesoft.connectivity.datacloud.internal.auth.AuthProvider;
import com.mulesoft.connectivity.datacloud.internal.auth.ClientCredentialsProvider;
import com.mulesoft.connectivity.datacloud.internal.auth.JwtBearerProvider;
import com.mulesoft.connectivity.datacloud.internal.auth.RefreshTokenProvider;
import java.util.Map;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

public class AuthProviderFactory {
    private AuthProviderFactory() {
    }

    public static @Nullable AuthProvider getAuthProvider(Map<String, Object> connectionAttributes) {
        String protocolType;
        switch (protocolType = Optional.ofNullable(connectionAttributes.get("protocolType")).map(Object::toString).map(String::toUpperCase).orElse("")) {
            case "JWT_BEARER": {
                return JwtBearerProvider.builder().aud(connectionAttributes.getOrDefault("aud", "").toString()).iss(connectionAttributes.getOrDefault("iss", "").toString()).scope(connectionAttributes.getOrDefault("scope", "").toString()).privateKey(JwtBearerProvider.getPrivateKeyFromBase64(connectionAttributes.getOrDefault("jwtCertificate", "").toString())).tokenSubject(connectionAttributes.getOrDefault("token_subject", "").toString()).build();
            }
            case "OAUTH_CC": {
                return ClientCredentialsProvider.builder().clientId(connectionAttributes.getOrDefault("clientId", "").toString()).scope(connectionAttributes.getOrDefault("scope", "").toString()).clientSecret(connectionAttributes.getOrDefault("clientSecret", "").toString()).tokenEndpoint(connectionAttributes.getOrDefault("tokenEndpoint", "").toString()).resource(connectionAttributes.getOrDefault("resource", "").toString()).resourcePrefix(connectionAttributes.getOrDefault("resourcePrefix", "").toString()).build();
            }
        }
        Object connectionId = connectionAttributes.get("connectionId");
        return connectionId != null ? RefreshTokenProvider.builder().connectionId(connectionId.toString()).build() : null;
    }
}

