/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.internal.ratelimiter;

import com.mulesoft.connectivity.datacloud.api.model.RateLimitConfigurationModel;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

public class RateLimitingConfiguration {
    private final @Nullable Map<String, RateLimitConfigurationModel> operationRateLimitConfigurations;
    private final @Nullable Map<String, RateLimitConfigurationModel> connectionRateLimitConfigurations;

    public Map<String, RateLimitConfigurationModel> getAllConfigurations() {
        HashMap<String, RateLimitConfigurationModel> allConfigurations = new HashMap<String, RateLimitConfigurationModel>();
        if (this.operationRateLimitConfigurations != null) {
            allConfigurations.putAll(this.operationRateLimitConfigurations);
        }
        if (this.connectionRateLimitConfigurations != null) {
            allConfigurations.putAll(this.connectionRateLimitConfigurations);
        }
        return allConfigurations;
    }

    public boolean hasEnabledConfigurations() {
        Map<String, RateLimitConfigurationModel> allConfigurations = this.getAllConfigurations();
        return !allConfigurations.isEmpty() && allConfigurations.values().stream().anyMatch(RateLimitConfigurationModel::isEnabled);
    }

    @Generated
    RateLimitingConfiguration(@Nullable Map<String, RateLimitConfigurationModel> operationRateLimitConfigurations, @Nullable Map<String, RateLimitConfigurationModel> connectionRateLimitConfigurations) {
        this.operationRateLimitConfigurations = operationRateLimitConfigurations;
        this.connectionRateLimitConfigurations = connectionRateLimitConfigurations;
    }

    @Generated
    public static RateLimitingConfigurationBuilder builder() {
        return new RateLimitingConfigurationBuilder();
    }

    @Generated
    public @Nullable Map<String, RateLimitConfigurationModel> getOperationRateLimitConfigurations() {
        return this.operationRateLimitConfigurations;
    }

    @Generated
    public @Nullable Map<String, RateLimitConfigurationModel> getConnectionRateLimitConfigurations() {
        return this.connectionRateLimitConfigurations;
    }

    @Generated
    public static class RateLimitingConfigurationBuilder {
        @Generated
        private Map<String, RateLimitConfigurationModel> operationRateLimitConfigurations;
        @Generated
        private Map<String, RateLimitConfigurationModel> connectionRateLimitConfigurations;

        @Generated
        RateLimitingConfigurationBuilder() {
        }

        @Generated
        public RateLimitingConfigurationBuilder operationRateLimitConfigurations(@Nullable Map<String, RateLimitConfigurationModel> operationRateLimitConfigurations) {
            this.operationRateLimitConfigurations = operationRateLimitConfigurations;
            return this;
        }

        @Generated
        public RateLimitingConfigurationBuilder connectionRateLimitConfigurations(@Nullable Map<String, RateLimitConfigurationModel> connectionRateLimitConfigurations) {
            this.connectionRateLimitConfigurations = connectionRateLimitConfigurations;
            return this;
        }

        @Generated
        public RateLimitingConfiguration build() {
            return new RateLimitingConfiguration(this.operationRateLimitConfigurations, this.connectionRateLimitConfigurations);
        }

        @Generated
        public String toString() {
            return "RateLimitingConfiguration.RateLimitingConfigurationBuilder(operationRateLimitConfigurations=" + String.valueOf(this.operationRateLimitConfigurations) + ", connectionRateLimitConfigurations=" + String.valueOf(this.connectionRateLimitConfigurations) + ")";
        }
    }
}

