/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.internal.retry.jitter;

import com.mulesoft.connectivity.datacloud.internal.retry.jitter.JitterStrategy;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomFactorStrategy
implements JitterStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RandomFactorStrategy.class);
    private final double jitterFactor;

    public RandomFactorStrategy(double jitterFactor) {
        this.jitterFactor = Math.max(0.0, Math.min(1.0, jitterFactor));
    }

    @Override
    public long getDelayMillis(long baseDelay) {
        if (this.jitterFactor > 0.0 && baseDelay > 0L) {
            double jitter = ThreadLocalRandom.current().nextDouble() * this.jitterFactor;
            long jitterAmount = (long)((double)baseDelay * jitter);
            baseDelay += jitterAmount;
            log.debug("Applied jitter: {} ms (factor: {})", (Object)jitterAmount, (Object)this.jitterFactor);
        }
        return baseDelay;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RandomFactorStrategy that = (RandomFactorStrategy)o;
        return Double.compare(this.jitterFactor, that.jitterFactor) == 0;
    }

    public int hashCode() {
        return Objects.hashCode(this.jitterFactor);
    }
}

