/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.internal.context;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ExecutionContext {
    private static final ThreadLocal<Map<String, Object>> CONTEXT = ThreadLocal.withInitial(ConcurrentHashMap::new);

    private ExecutionContext() {
    }

    public static void set(String key, Object value) {
        if (key == null || value == null) {
            throw new IllegalArgumentException("Key/Value cannot be null");
        }
        CONTEXT.get().put(key, value);
    }

    public static Object get(String key) {
        if (key == null) {
            return null;
        }
        return CONTEXT.get().get(key);
    }

    public static <T> T get(String key, Class<T> type) {
        Object value = ExecutionContext.get(key);
        if (type.isInstance(value)) {
            return (T)value;
        }
        return null;
    }

    public static Object remove(String key) {
        if (key == null) {
            return null;
        }
        return CONTEXT.get().remove(key);
    }

    public static boolean contains(String key) {
        if (key == null) {
            return false;
        }
        return CONTEXT.get().containsKey(key);
    }

    public static Set<String> getKeys() {
        return CONTEXT.get().keySet();
    }

    public static int size() {
        return CONTEXT.get().size();
    }

    public static boolean isEmpty() {
        return CONTEXT.get().isEmpty();
    }

    public static void clear() {
        CONTEXT.get().clear();
    }

    public static void remove() {
        CONTEXT.remove();
    }

    public static void setConnectorName(String connectorName) {
        if (connectorName == null) {
            throw new IllegalArgumentException("Connector name cannot be null");
        }
        ExecutionContext.set("connectorName", connectorName);
    }

    public static String getConnectorName() {
        return ExecutionContext.get("connectorName", String.class);
    }

    public static Map<String, Object> getAll() {
        return new ConcurrentHashMap<String, Object>(CONTEXT.get());
    }
}

