/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.internal.operation;

import com.mulesoft.connectivity.datacloud.api.model.DataCloudConnectionModel;
import com.mulesoft.connectivity.datacloud.api.model.DataCloudConnectorModel;
import com.mulesoft.connectivity.datacloud.api.model.DataCloudObjectModel;
import com.mulesoft.connectivity.datacloud.internal.connection.DataCloudConnection;
import com.mulesoft.connectivity.datacloud.internal.operation.DataCloudParameters;
import com.mulesoft.connectivity.datacloud.internal.operation.DataIterator;
import com.mulesoft.connectivity.datacloud.internal.operation.FileContentProvider;
import com.mulesoft.connectivity.datacloud.internal.ratelimiter.RateLimitingPolicy;
import com.mulesoft.connectivity.datacloud.internal.retry.RetryConfiguration;
import com.mulesoft.connectivity.linkweave.api.interpreter.ModelInterpreter;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationModel;
import com.salesforce.dataconnectors.api.dataproviders.CloseableIterator;
import com.salesforce.dataconnectors.api.dataproviders.ObjectStreamProvider;
import com.salesforce.dataconnectors.api.exception.ConnectorException;
import com.salesforce.dataconnectors.api.exception.ExceptionCategory;
import com.salesforce.dataconnectors.api.model.data.ObjectStream;
import com.salesforce.dataconnectors.api.model.input.InputAttributes;
import java.util.NoSuchElementException;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectStreamIterator
extends DataIterator<ObjectStream>
implements ObjectStreamProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ObjectStreamIterator.class);

    public ObjectStreamIterator(ModelInterpreter modelInterpreter, DataCloudConnectorModel connectorModel, InputAttributes inputAttributes, String objectName, DataCloudConnectionModel connectionModel, RetryConfiguration retryConfiguration, RateLimitingPolicy rateLimitingPolicy) {
        super(modelInterpreter, connectorModel, objectName, inputAttributes, connectionModel, retryConfiguration, rateLimitingPolicy);
    }

    @Override
    void doExtract() {
        DataCloudObjectModel objectModel = (DataCloudObjectModel)this.connectorModel.getObjects().get(this.objectName);
        OperationModel contentProvider = (OperationModel)Objects.requireNonNull(objectModel.getContentProvider());
        FileContentProvider fileContent = new FileContentProvider(this.connectorModel.getName(), this.modelInterpreter, this.connectionModel.getConnectionProviderModel(), objectModel.getContentProviderRateLimiterConfigs(), contentProvider, objectModel.getCustomHandler(), this.retryConfiguration, this.rateLimitingPolicy);
        DataCloudParameters params = new DataCloudParameters(this.inputAttributes);
        fileContent.execute(new DataCloudConnection(this.connectionModel, this.inputAttributes), params, this::consumeData);
    }

    public CloseableIterator<ObjectStream> get() {
        return new CloseableIterator<ObjectStream>(){

            public boolean hasNext() throws ConnectorException {
                return ObjectStreamIterator.this.hasMoreData(300L);
            }

            public ObjectStream next() throws ConnectorException {
                if (!this.hasNext()) {
                    throw new ConnectorException((Throwable)new NoSuchElementException("There's no next element!"), ExceptionCategory.INTERNAL);
                }
                return (ObjectStream)ObjectStreamIterator.this.nextData();
            }

            public void close() {
                ObjectStreamIterator.this.cancel();
            }
        };
    }
}

