/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.internal.auth;

import com.mulesoft.connectivity.datacloud.internal.auth.AuthProvider;
import java.net.URI;
import java.net.http.HttpRequest;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientCredentialsProvider
extends AuthProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClientCredentialsProvider.class);
    private final String clientId;
    private final String clientSecret;
    private final String tokenEndpoint;
    private final String scope;
    private final String resource;
    private final String resourcePrefix;

    @Override
    String buildRequestBody() {
        log.debug("Building request body with grant_type: {}", (Object)"client_credentials");
        String request = "grant_type=" + this.urlEncode("client_credentials") + "&client_id=" + this.urlEncode(this.clientId) + "&client_secret=" + this.urlEncode(this.clientSecret);
        if (!StringUtils.isEmpty((CharSequence)this.scope)) {
            request = request + "&scope=" + this.urlEncode(this.scope);
        }
        if (!StringUtils.isEmpty((CharSequence)this.resource)) {
            String finalResource = StringUtils.isEmpty((CharSequence)this.resourcePrefix) ? this.resource : this.resourcePrefix + this.resource;
            request = request + "&resource=" + this.urlEncode(finalResource);
        }
        return request;
    }

    @Override
    HttpRequest buildHttpRequest(String requestBody) {
        HttpRequest.BodyPublisher bodyPublisher = HttpRequest.BodyPublishers.ofString(StringUtils.isEmpty((CharSequence)requestBody) ? "" : requestBody);
        return HttpRequest.newBuilder().uri(URI.create(this.tokenEndpoint)).timeout(this.timeout).header("Content-Type", "application/x-www-form-urlencoded").header("Accept", "application/json").POST(bodyPublisher).build();
    }

    @Override
    public String hashValue() {
        return UUID.nameUUIDFromBytes(String.format("%s:%s:%s:%s:%s:%s", this.clientId, this.clientSecret, this.tokenEndpoint, this.scope, this.resource, this.resourcePrefix).getBytes()).toString();
    }

    @Generated
    public static ClientCredentialsProviderBuilder builder() {
        return new ClientCredentialsProviderBuilder();
    }

    @Generated
    public ClientCredentialsProvider(String clientId, String clientSecret, String tokenEndpoint, String scope, String resource, String resourcePrefix) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.tokenEndpoint = tokenEndpoint;
        this.scope = scope;
        this.resource = resource;
        this.resourcePrefix = resourcePrefix;
    }

    @Generated
    public static class ClientCredentialsProviderBuilder {
        @Generated
        private String clientId;
        @Generated
        private String clientSecret;
        @Generated
        private String tokenEndpoint;
        @Generated
        private String scope;
        @Generated
        private String resource;
        @Generated
        private String resourcePrefix;

        @Generated
        ClientCredentialsProviderBuilder() {
        }

        @Generated
        public ClientCredentialsProviderBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        @Generated
        public ClientCredentialsProviderBuilder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        @Generated
        public ClientCredentialsProviderBuilder tokenEndpoint(String tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint;
            return this;
        }

        @Generated
        public ClientCredentialsProviderBuilder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Generated
        public ClientCredentialsProviderBuilder resource(String resource) {
            this.resource = resource;
            return this;
        }

        @Generated
        public ClientCredentialsProviderBuilder resourcePrefix(String resourcePrefix) {
            this.resourcePrefix = resourcePrefix;
            return this;
        }

        @Generated
        public ClientCredentialsProvider build() {
            return new ClientCredentialsProvider(this.clientId, this.clientSecret, this.tokenEndpoint, this.scope, this.resource, this.resourcePrefix);
        }

        @Generated
        public String toString() {
            return "ClientCredentialsProvider.ClientCredentialsProviderBuilder(clientId=" + this.clientId + ", clientSecret=" + this.clientSecret + ", tokenEndpoint=" + this.tokenEndpoint + ", scope=" + this.scope + ", resource=" + this.resource + ", resourcePrefix=" + this.resourcePrefix + ")";
        }
    }
}

