/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.internal.auth;

import com.mulesoft.connectivity.datacloud.internal.auth.AuthProvider;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpRequest;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.time.Instant;
import java.util.Base64;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtBearerProvider
extends AuthProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JwtBearerProvider.class);
    private final PrivateKey privateKey;
    private final String scope;
    private final String aud;
    private final String iss;
    private final String tokenSubject;

    @Override
    String buildRequestBody() throws IOException {
        log.debug("Building request body with grant_type=jwt bearer");
        if (StringUtils.isEmpty((CharSequence)this.aud)) {
            throw new IllegalArgumentException("Audience (aud) cannot be null or empty");
        }
        if (StringUtils.isEmpty((CharSequence)this.iss)) {
            throw new IllegalArgumentException("Issuer (iss) cannot be null or empty");
        }
        if (StringUtils.isEmpty((CharSequence)this.scope)) {
            throw new IllegalArgumentException("Scope cannot be null or empty");
        }
        if (StringUtils.isEmpty((CharSequence)this.tokenSubject)) {
            throw new IllegalArgumentException("Token subject cannot be null or empty");
        }
        if (this.privateKey == null) {
            throw new IllegalArgumentException("Private key cannot be null");
        }
        Map<String, Object> jwtPayload = this.getJwtPayload(this.tokenSubject);
        String jwtToken = this.createJWT(jwtPayload, this.privateKey);
        Map<String, String> requestBody = Map.of("grant_type", "urn:ietf:params:oauth:grant-type:jwt-bearer", "assertion", jwtToken);
        return this.mapper.writeValueAsString(requestBody);
    }

    private Map<String, Object> getJwtPayload(String clientEmail) {
        long now = Instant.now().getEpochSecond();
        return Map.of("iss", this.iss, "sub", clientEmail, "scope", this.scope, "aud", this.aud, "iat", now, "exp", now + 3600L);
    }

    @Override
    HttpRequest buildHttpRequest(String requestBody) {
        if (StringUtils.isEmpty((CharSequence)this.aud)) {
            throw new IllegalArgumentException("Audience (aud) cannot be null or empty for HTTP request");
        }
        HttpRequest.BodyPublisher bodyPublisher = HttpRequest.BodyPublishers.ofString(StringUtils.isEmpty((CharSequence)requestBody) ? "" : requestBody);
        return HttpRequest.newBuilder().uri(URI.create(this.aud)).timeout(this.timeout).header("Content-Type", "application/json").header("Accept", "application/json").POST(bodyPublisher).build();
    }

    @Override
    public String hashValue() {
        return UUID.nameUUIDFromBytes(String.format("%s:%s:%s:%s:%s", this.privateKey, this.scope, this.aud, this.iss, this.tokenSubject).getBytes()).toString();
    }

    private String createJWT(Map<String, Object> payload, PrivateKey privateKey) throws IOException {
        Map<String, String> header = Map.of("alg", "RS256", "typ", "JWT");
        String headerJson = this.mapper.writeValueAsString(header);
        String payloadJson = this.mapper.writeValueAsString(payload);
        String encodedHeader = this.base64UrlEncode(headerJson.getBytes(StandardCharsets.UTF_8));
        String encodedPayload = this.base64UrlEncode(payloadJson.getBytes(StandardCharsets.UTF_8));
        String signatureInput = encodedHeader + "." + encodedPayload;
        Signature signature = null;
        try {
            signature = Signature.getInstance("SHA256withRSA");
            signature.initSign(privateKey);
            signature.update(signatureInput.getBytes(StandardCharsets.UTF_8));
            byte[] signatureBytes = signature.sign();
            String encodedSignature = this.base64UrlEncode(signatureBytes);
            return signatureInput + "." + encodedSignature;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new IOException(e);
        }
    }

    private String base64UrlEncode(byte[] data) {
        return Base64.getUrlEncoder().withoutPadding().encodeToString(data);
    }

    public static String sanitizePrivateKey(String privateKeyString) {
        if (StringUtils.isBlank((CharSequence)privateKeyString)) {
            throw new IllegalArgumentException("Private key cannot be null, empty, or whitespace");
        }
        return privateKeyString.replaceAll("-----(BEGIN|END).*?KEY-----", "").replaceAll("\\s+", "").trim();
    }

    public static PrivateKey getPrivateKeyFromBase64(String base64PrivateKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        try {
            String sanitizedKey = JwtBearerProvider.sanitizePrivateKey(base64PrivateKey);
            byte[] keyBytes = Base64.getDecoder().decode(sanitizedKey);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePrivate(keySpec);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid base64 encoded private key: " + e.getMessage(), e);
        }
    }

    @Generated
    public static JwtBearerProviderBuilder builder() {
        return new JwtBearerProviderBuilder();
    }

    @Generated
    public JwtBearerProvider(PrivateKey privateKey, String scope, String aud, String iss, String tokenSubject) {
        this.privateKey = privateKey;
        this.scope = scope;
        this.aud = aud;
        this.iss = iss;
        this.tokenSubject = tokenSubject;
    }

    @Generated
    public static class JwtBearerProviderBuilder {
        @Generated
        private PrivateKey privateKey;
        @Generated
        private String scope;
        @Generated
        private String aud;
        @Generated
        private String iss;
        @Generated
        private String tokenSubject;

        @Generated
        JwtBearerProviderBuilder() {
        }

        @Generated
        public JwtBearerProviderBuilder privateKey(PrivateKey privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        @Generated
        public JwtBearerProviderBuilder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Generated
        public JwtBearerProviderBuilder aud(String aud) {
            this.aud = aud;
            return this;
        }

        @Generated
        public JwtBearerProviderBuilder iss(String iss) {
            this.iss = iss;
            return this;
        }

        @Generated
        public JwtBearerProviderBuilder tokenSubject(String tokenSubject) {
            this.tokenSubject = tokenSubject;
            return this;
        }

        @Generated
        public JwtBearerProvider build() {
            return new JwtBearerProvider(this.privateKey, this.scope, this.aud, this.iss, this.tokenSubject);
        }

        @Generated
        public String toString() {
            return "JwtBearerProvider.JwtBearerProviderBuilder(privateKey=" + String.valueOf(this.privateKey) + ", scope=" + this.scope + ", aud=" + this.aud + ", iss=" + this.iss + ", tokenSubject=" + this.tokenSubject + ")";
        }
    }
}

