/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.internal.auth;

import com.mulesoft.connectivity.datacloud.internal.auth.AuthException;
import com.mulesoft.connectivity.datacloud.internal.auth.AuthProvider;
import com.salesforce.dataconnectors.api.service.ConnectorServicesProvider;
import com.salesforce.dataconnectors.api.service.oauth.OAuthResponse;
import java.net.http.HttpRequest;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshTokenProvider
extends AuthProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RefreshTokenProvider.class);
    private final String refreshToken;

    @Override
    String buildRequestBody() {
        throw new UnsupportedOperationException("This operation is not supported.");
    }

    @Override
    public AuthProvider.TokenResponse getToken() throws AuthException {
        log.info("Invoking 'initiateRefreshAndGetAccessToken' from OAuth service");
        OAuthResponse authResponse = ConnectorServicesProvider.getOAuthService().initiateRefreshAndGetAccessToken();
        Map tokenResponse = authResponse.getOauthTokens();
        Object accessToken = tokenResponse.get(OAuthResponse.OAuthTokenType.ACCESS_TOKEN);
        long expiry = 3300L;
        if (accessToken == null) {
            throw new AuthException("Failed to get the access token");
        }
        if (tokenResponse.get(OAuthResponse.OAuthTokenType.EXPIRES_IN) != null) {
            try {
                expiry = Long.parseLong(tokenResponse.get(OAuthResponse.OAuthTokenType.EXPIRES_IN).toString());
            }
            catch (Exception e) {
                log.error("Error parsing expiry time from token response: {}", (Object)e.getMessage());
            }
        }
        log.info("Successfully obtained access token.");
        return new AuthProvider.TokenResponse(tokenResponse.get(OAuthResponse.OAuthTokenType.ACCESS_TOKEN).toString(), null, expiry, null, null, null);
    }

    @Override
    HttpRequest buildHttpRequest(String requestBody) {
        throw new UnsupportedOperationException("This operation is not supported.");
    }

    @Override
    public String hashValue() {
        return UUID.nameUUIDFromBytes(this.refreshToken.getBytes()).toString();
    }

    @Generated
    public static RefreshTokenProviderBuilder builder() {
        return new RefreshTokenProviderBuilder();
    }

    @Generated
    public RefreshTokenProvider(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    @Generated
    public static class RefreshTokenProviderBuilder {
        @Generated
        private String refreshToken;

        @Generated
        RefreshTokenProviderBuilder() {
        }

        @Generated
        public RefreshTokenProviderBuilder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        @Generated
        public RefreshTokenProvider build() {
            return new RefreshTokenProvider(this.refreshToken);
        }

        @Generated
        public String toString() {
            return "RefreshTokenProvider.RefreshTokenProviderBuilder(refreshToken=" + this.refreshToken + ")";
        }
    }
}

