/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.internal.service;

import com.mulesoft.connectivity.datacloud.internal.service.CachingService;
import com.mulesoft.connectivity.datacloud.internal.service.ConnectorCachingService;
import com.mulesoft.connectivity.datacloud.internal.service.ConnectorThreadPoolService;
import com.mulesoft.connectivity.datacloud.internal.service.ThreadPoolService;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServiceProvider.class);
    private static final ConcurrentHashMap<String, ThreadPoolService> EXECUTOR_SERVICES = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, CachingService> CACHING_SERVICES = new ConcurrentHashMap();

    private ServiceProvider() {
    }

    public static ThreadPoolService getThreadPoolService(String connectorName) {
        if (connectorName == null || connectorName.trim().isEmpty()) {
            throw new IllegalArgumentException("Connector name cannot be null or empty");
        }
        return EXECUTOR_SERVICES.computeIfAbsent(connectorName, name -> {
            log.info("Creating dedicated ThreadPoolService for connector: {}", name);
            return new ConnectorThreadPoolService(connectorName);
        });
    }

    public static CachingService getCachingService(String connectorName) {
        if (connectorName == null || connectorName.trim().isEmpty()) {
            throw new IllegalArgumentException("Connector name cannot be null or empty");
        }
        return CACHING_SERVICES.computeIfAbsent(connectorName, name -> {
            log.info("Creating dedicated CachingService for connector: {}", name);
            return new ConnectorCachingService((String)name);
        });
    }

    public static void shutdownAllServices() {
        log.info("Shutting down all connector services");
        EXECUTOR_SERVICES.forEach((connectorName, threadPool) -> {
            ((ConnectorThreadPoolService)threadPool).getExecutorService().shutdown();
            log.debug("Shut down ExecutorService for connector: {}", connectorName);
        });
        EXECUTOR_SERVICES.clear();
        CACHING_SERVICES.forEach((connectorName, cache) -> {
            cache.clearCache();
            log.debug("Cleared cache for connector: {}", connectorName);
        });
        CACHING_SERVICES.clear();
        log.info("All connector services have been shut down");
    }
}

