/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.internal.types;

import com.mulesoft.connectivity.linkweave.api.loader.WeaveTypeSimplifier;
import com.mulesoft.connectivity.linkweave.api.metadata.MetadataUtils;
import com.mulesoft.connectivity.linkweave.api.model.MetadataKey;
import com.mulesoft.connectivity.linkweave.api.util.DWTypeUtils;
import com.salesforce.dataconnectors.api.model.metadata.Field;
import com.salesforce.dataconnectors.api.model.metadata.FieldDataType;
import com.salesforce.dataconnectors.api.service.ConnectorServicesProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.mule.weave.v2.api.tooling.ts.ArrayMetadataValue;
import org.mule.weave.v2.api.tooling.ts.ArrayType;
import org.mule.weave.v2.api.tooling.ts.BooleanType;
import org.mule.weave.v2.api.tooling.ts.DWMetadata;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.DWTypeVisitor;
import org.mule.weave.v2.api.tooling.ts.DateTimeType;
import org.mule.weave.v2.api.tooling.ts.KeyValuePairType;
import org.mule.weave.v2.api.tooling.ts.LiteralMetadataValue;
import org.mule.weave.v2.api.tooling.ts.LocalDateTimeType;
import org.mule.weave.v2.api.tooling.ts.LocalDateType;
import org.mule.weave.v2.api.tooling.ts.NullType;
import org.mule.weave.v2.api.tooling.ts.NumberType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;
import org.mule.weave.v2.api.tooling.ts.SimpleReferenceType;
import org.mule.weave.v2.api.tooling.ts.StringType;
import org.mule.weave.v2.api.tooling.ts.UnionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldTypeTransformer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FieldTypeTransformer.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(FieldTypeTransformer.class);

    private FieldTypeTransformer() {
    }

    private static List<?> getFields(KeyValuePairType objectFieldType, boolean returnIncrementalFields, boolean returnPrimaryKeyFields) {
        ArrayList<Field> flattenedFields = new ArrayList<Field>();
        HashMap<String, Field> fieldMap = new HashMap<String, Field>();
        ArrayList<String> incrementalFields = new ArrayList<String>();
        ArrayList<String> primaryKeyFields = new ArrayList<String>();
        objectFieldType.getValue().accept((DWTypeVisitor)new ObjectFieldTypeVisitor(flattenedFields, fieldMap, incrementalFields, DWTypeUtils.getKey((KeyValuePairType)objectFieldType), primaryKeyFields));
        if (returnIncrementalFields) {
            return incrementalFields;
        }
        if (returnPrimaryKeyFields) {
            return primaryKeyFields;
        }
        return new ArrayList(fieldMap.values());
    }

    public static List<Field> transform(KeyValuePairType objectFieldType) {
        return FieldTypeTransformer.getFields(objectFieldType, false, false);
    }

    public static List<String> fetchIncrementalFields(KeyValuePairType objectFieldType) {
        return FieldTypeTransformer.getFields(objectFieldType, true, false);
    }

    public static List<String> fetchPrimaryKeyFields(KeyValuePairType objectFieldType) {
        return FieldTypeTransformer.getFields(objectFieldType, false, true);
    }

    private static class ObjectFieldTypeVisitor
    implements DWTypeVisitor {
        private final List<Field> flattenedFields;
        private final Map<String, Field> fieldMap;
        private final List<String> incrementalFields;
        private final List<String> primaryKeyFields;
        private final String prefix;
        private final Boolean isNullable;
        private static final Map<Class<?>, Supplier<FieldDataType>> TRANSLATIONS = Map.ofEntries(Map.entry(BooleanType.class, () -> FieldDataType.BOOLEAN), Map.entry(NumberType.class, () -> FieldDataType.NUMBER), Map.entry(StringType.class, () -> FieldDataType.TEXT), Map.entry(DateTimeType.class, () -> FieldDataType.DATE), Map.entry(LocalDateTimeType.class, () -> FieldDataType.DATE), Map.entry(LocalDateType.class, () -> FieldDataType.DATE_ONLY), Map.entry(NullType.class, () -> FieldDataType.UNSUPPORTED), Map.entry(ObjectType.class, () -> FieldDataType.UNSUPPORTED), Map.entry(ArrayType.class, ObjectFieldTypeVisitor.arrayTypeSupplier()), Map.entry(UnionType.class, () -> FieldDataType.UNSUPPORTED));

        private static Supplier<FieldDataType> arrayTypeSupplier() {
            return () -> ConnectorServicesProvider.getGateService().isOpen("processArrayAsTextEnabled") ? FieldDataType.TEXT : FieldDataType.UNSUPPORTED;
        }

        public ObjectFieldTypeVisitor(List<Field> flattenedFields, Map<String, Field> fieldMap, List<String> incrementalFields, String prefix, List<String> primaryKeyFields) {
            this(flattenedFields, fieldMap, incrementalFields, primaryKeyFields, prefix, false);
        }

        public ObjectFieldTypeVisitor(List<Field> flattenedFields, Map<String, Field> fieldMap, List<String> incrementalFields, List<String> primaryKeyFields, String prefix, boolean isNullable) {
            this.flattenedFields = flattenedFields;
            this.fieldMap = fieldMap;
            this.incrementalFields = incrementalFields;
            this.primaryKeyFields = primaryKeyFields;
            this.prefix = prefix;
            this.isNullable = isNullable;
        }

        private FormatInfo extractFormatInfo(DWType metadataType) {
            if (metadataType instanceof StringType) {
                StringType stringType = (StringType)metadataType;
                Optional formatAnnotation = MetadataUtils.getFormat((DWType)stringType);
                String nativeDataType = "String";
                if (formatAnnotation.isPresent()) {
                    String formatValue;
                    return switch (formatValue = (String)formatAnnotation.get()) {
                        case "date-time" -> new FormatInfo("yyyy-MM-dd'T'HH:mm:ss.SZ", Arrays.asList("yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mm:ss.S", "yyyy-MM-dd'T'HH:mm:ss.SZ", "yyyy-MM-dd'T'HH:mm:ss.SS", "yyyy-MM-dd'T'HH:mm:ss.SS zzz", "yyyy-MM-dd'T'HH:mm:ss.SS ZZZZZ", "yyyy-MM-dd'T'HH:mm:ss.SSS", "yyyy-MM-dd'T'HH:mm:ss.SSSS", "yyyy-MM-dd'T'HH:mm:ss.SSSSS"), nativeDataType);
                        case "date" -> new FormatInfo("yyyy-MM-dd", List.of("yyyy-MM-dd"), nativeDataType);
                        default -> new FormatInfo(null, null, nativeDataType);
                    };
                }
                return new FormatInfo(null, null, nativeDataType);
            }
            if (metadataType instanceof NumberType) {
                NumberType numberType = (NumberType)metadataType;
                String format = MetadataUtils.getFormat((DWType)numberType).orElse(null);
                return new FormatInfo(format, Arrays.asList("int32", "int64", "integer", "float", "double"), "Number");
            }
            if (metadataType instanceof BooleanType) {
                return new FormatInfo(null, null, "Boolean");
            }
            return new FormatInfo(null, null, null);
        }

        private boolean isIncrementalSyncKey(DWType dwType) {
            if (dwType.getTypeMetadata(MetadataKey.SEMANTIC_TERMS.getKey()).isPresent()) {
                return Arrays.stream(((ArrayMetadataValue)((DWMetadata)dwType.getTypeMetadata(MetadataKey.SEMANTIC_TERMS.getKey()).get()).getValue()).getElements()).anyMatch(e -> ((LiteralMetadataValue)e).getValue().equals("incrementalSyncKey"));
            }
            return false;
        }

        private boolean isPrimaryKey(DWType dwType) {
            if (dwType.getTypeMetadata(MetadataKey.SEMANTIC_TERMS.getKey()).isPresent()) {
                return Arrays.stream(((ArrayMetadataValue)((DWMetadata)dwType.getTypeMetadata(MetadataKey.SEMANTIC_TERMS.getKey()).get()).getValue()).getElements()).anyMatch(e -> ((LiteralMetadataValue)e).getValue().equals("primaryKey"));
            }
            if (dwType instanceof UnionType) {
                UnionType unionType = (UnionType)dwType;
                return Arrays.stream(unionType.unionOf()).anyMatch(this::isPrimaryKey);
            }
            return false;
        }

        private boolean isContentType(DWType dwType) {
            if (dwType.getTypeMetadata(MetadataKey.SEMANTIC_TERMS.getKey()).isPresent()) {
                return Arrays.stream(((ArrayMetadataValue)((DWMetadata)dwType.getTypeMetadata(MetadataKey.SEMANTIC_TERMS.getKey()).get()).getValue()).getElements()).anyMatch(e -> ((LiteralMetadataValue)e).getValue().equals("mimeType"));
            }
            if (dwType instanceof UnionType) {
                UnionType unionType = (UnionType)dwType;
                return Arrays.stream(unionType.unionOf()).anyMatch(this::isContentType);
            }
            return false;
        }

        private boolean isContentLastModifiedTime(DWType dwType) {
            if (dwType.getTypeMetadata(MetadataKey.SEMANTIC_TERMS.getKey()).isPresent()) {
                return Arrays.stream(((ArrayMetadataValue)((DWMetadata)dwType.getTypeMetadata(MetadataKey.SEMANTIC_TERMS.getKey()).get()).getValue()).getElements()).anyMatch(e -> ((LiteralMetadataValue)e).getValue().equals("lastModifiedTime"));
            }
            if (dwType instanceof UnionType) {
                UnionType unionType = (UnionType)dwType;
                return Arrays.stream(unionType.unionOf()).anyMatch(this::isContentLastModifiedTime);
            }
            return false;
        }

        private boolean isContentSize(DWType dwType) {
            if (dwType.getTypeMetadata(MetadataKey.SEMANTIC_TERMS.getKey()).isPresent()) {
                return Arrays.stream(((ArrayMetadataValue)((DWMetadata)dwType.getTypeMetadata(MetadataKey.SEMANTIC_TERMS.getKey()).get()).getValue()).getElements()).anyMatch(e -> ((LiteralMetadataValue)e).getValue().equals("size"));
            }
            if (dwType instanceof UnionType) {
                UnionType unionType = (UnionType)dwType;
                return Arrays.stream(unionType.unionOf()).anyMatch(this::isContentSize);
            }
            return false;
        }

        public void visitObjectType(ObjectType objectType) {
            if (objectType.getProperties().length == 0) {
                this.addField(this.prefix, this.isNullable, FieldDataType.UNSUPPORTED, null, null, null, this.isIncrementalSyncKey((DWType)objectType), this.isPrimaryKey((DWType)objectType), false, false, false);
            }
            String flattenSeparator = ".";
            if (ConnectorServicesProvider.getGateService().isOpen("flattenWithUnderscoresEnabled")) {
                flattenSeparator = "_";
            }
            for (KeyValuePairType field : objectType.getProperties()) {
                String fieldName = DWTypeUtils.getKey((KeyValuePairType)field);
                String fullFieldName = this.prefix + flattenSeparator + fieldName;
                DWType fieldType = field.getValue();
                boolean nullable = this.isNullable(fieldType);
                FieldDataType dataType = ObjectFieldTypeVisitor.determineFieldType(fieldType);
                if (dataType != FieldDataType.UNSUPPORTED) {
                    this.addField(fullFieldName, nullable, dataType, null, null, null, this.isIncrementalSyncKey(field.getValue()), this.isPrimaryKey(field.getValue()), this.isContentType(field.getValue()), this.isContentLastModifiedTime(field.getValue()), this.isContentSize(field.getValue()));
                    continue;
                }
                fieldType.accept((DWTypeVisitor)new ObjectFieldTypeVisitor(this.flattenedFields, this.fieldMap, this.incrementalFields, fullFieldName, this.primaryKeyFields));
            }
        }

        public void visitArrayType(ArrayType arrayType) {
            DWType elementType = arrayType.arrayOf();
            String fieldName = this.prefix;
            boolean nullable = this.isNullable(elementType);
            FieldDataType dataType = ObjectFieldTypeVisitor.determineFieldType((DWType)arrayType);
            if (dataType != FieldDataType.UNSUPPORTED) {
                this.addField(fieldName, nullable, dataType, null, null, null, this.isIncrementalSyncKey((DWType)arrayType), this.isPrimaryKey((DWType)arrayType), this.isContentType((DWType)arrayType), this.isContentLastModifiedTime((DWType)arrayType), this.isContentSize((DWType)arrayType));
            } else {
                elementType.accept((DWTypeVisitor)new ObjectFieldTypeVisitor(this.flattenedFields, this.fieldMap, this.incrementalFields, fieldName, this.primaryKeyFields));
            }
        }

        public void visitNullType(NullType nullType) {
            this.addField(this.prefix, true, FieldDataType.UNSUPPORTED, null, null, null, this.isIncrementalSyncKey((DWType)nullType), this.isPrimaryKey((DWType)nullType), false, false, false);
        }

        public void visitBooleanType(BooleanType booleanType) {
            FormatInfo formatInfo = this.extractFormatInfo((DWType)booleanType);
            this.addField(this.prefix, false, FieldDataType.BOOLEAN, formatInfo.format, formatInfo.availableFormats, formatInfo.nativeDataType, this.isIncrementalSyncKey((DWType)booleanType), this.isPrimaryKey((DWType)booleanType), false, false, false);
        }

        public void visitUnionType(UnionType unionType) {
            ObjectFieldUnionTypeVisitor unionTypeVisitor = new ObjectFieldUnionTypeVisitor();
            unionType.accept((DWTypeVisitor)unionTypeVisitor);
            Set<DWType> flattenedUnionTypes = unionTypeVisitor.getFlattenedUnionTypes();
            Set<DWType> complexUnionTypes = unionTypeVisitor.getComplexUnionTypes();
            boolean nullable = unionTypeVisitor.typeIsNullable();
            String unionFieldName = this.prefix;
            if (flattenedUnionTypes.isEmpty() && complexUnionTypes.isEmpty()) {
                this.addField(unionFieldName, nullable, FieldDataType.UNSUPPORTED, null, null, null, this.isIncrementalSyncKey((DWType)unionType), this.isPrimaryKey((DWType)unionType), false, false, false);
            } else if (flattenedUnionTypes.size() + complexUnionTypes.size() > 1) {
                if (flattenedUnionTypes.size() > 1 && this.hasUniformDWType(flattenedUnionTypes)) {
                    Optional<DWType> firstNonNullType = flattenedUnionTypes.stream().filter(t -> !(t instanceof NullType)).findFirst();
                    firstNonNullType.ifPresentOrElse(type -> {
                        FieldDataType dataType = ObjectFieldTypeVisitor.determineFieldType(type);
                        FormatInfo formatInfo = this.extractFormatInfo((DWType)type);
                        this.addField(unionFieldName, nullable, dataType, formatInfo.format, formatInfo.availableFormats, formatInfo.nativeDataType, this.isIncrementalSyncKey((DWType)unionType), this.isPrimaryKey((DWType)unionType), this.isContentType((DWType)unionType), this.isContentLastModifiedTime((DWType)unionType), this.isContentSize((DWType)unionType));
                    }, () -> this.addField(unionFieldName, nullable, FieldDataType.UNSUPPORTED, null, null, null, this.isIncrementalSyncKey((DWType)unionType), this.isPrimaryKey((DWType)unionType), this.isContentType((DWType)unionType), this.isContentLastModifiedTime((DWType)unionType), this.isContentSize((DWType)unionType)));
                } else {
                    this.addField(unionFieldName, nullable, FieldDataType.UNSUPPORTED, null, null, null, this.isIncrementalSyncKey((DWType)unionType), this.isPrimaryKey((DWType)unionType), this.isContentType((DWType)unionType), this.isContentLastModifiedTime((DWType)unionType), this.isContentSize((DWType)unionType));
                }
            } else if (complexUnionTypes.size() == 1) {
                DWType type2 = complexUnionTypes.iterator().next();
                type2.accept((DWTypeVisitor)new ObjectFieldTypeVisitor(this.flattenedFields, this.fieldMap, this.incrementalFields, this.primaryKeyFields, this.prefix, nullable));
            } else {
                DWType metadataType = flattenedUnionTypes.iterator().next();
                FieldDataType dataType = ObjectFieldTypeVisitor.determineFieldType(metadataType);
                FormatInfo formatInfo = this.extractFormatInfo(metadataType);
                this.addField(unionFieldName, nullable, dataType, formatInfo.format, formatInfo.availableFormats, formatInfo.nativeDataType, this.isIncrementalSyncKey((DWType)unionType), this.isPrimaryKey((DWType)unionType), this.isContentType((DWType)unionType), this.isContentLastModifiedTime((DWType)unionType), this.isContentSize((DWType)unionType));
            }
        }

        private boolean hasUniformDWType(Set<DWType> unionTypes) {
            List<DWType> nonNullTypes = unionTypes.stream().filter(type -> !(type instanceof NullType)).toList();
            if (nonNullTypes.isEmpty()) {
                return false;
            }
            return nonNullTypes.stream().map(Object::getClass).distinct().count() == 1L;
        }

        public void visitNumberType(NumberType numberType) {
            FormatInfo formatInfo = this.extractFormatInfo((DWType)numberType);
            this.addField(this.prefix, false, FieldDataType.NUMBER, formatInfo.format, formatInfo.availableFormats, formatInfo.nativeDataType, this.isIncrementalSyncKey((DWType)numberType), this.isPrimaryKey((DWType)numberType), false, this.isContentLastModifiedTime((DWType)numberType), this.isContentSize((DWType)numberType));
        }

        public void visitStringType(StringType stringType) {
            FieldDataType dataType = ObjectFieldTypeVisitor.determineFieldType((DWType)stringType);
            FormatInfo formatInfo = this.extractFormatInfo((DWType)stringType);
            this.addField(this.prefix, false, dataType, formatInfo.format, formatInfo.availableFormats, formatInfo.nativeDataType, this.isIncrementalSyncKey((DWType)stringType), this.isPrimaryKey((DWType)stringType), this.isContentType((DWType)stringType), this.isContentLastModifiedTime((DWType)stringType), this.isContentSize((DWType)stringType));
        }

        public void visitDateTimeType(DateTimeType dateTimeType) {
            this.addField(this.prefix, false, FieldDataType.DATE, null, null, null, this.isIncrementalSyncKey((DWType)dateTimeType), this.isPrimaryKey((DWType)dateTimeType), false, this.isContentLastModifiedTime((DWType)dateTimeType), false);
        }

        public void visitLocalDateType(LocalDateType dateType) {
            this.addField(this.prefix, false, FieldDataType.DATE_ONLY, null, null, null, this.isIncrementalSyncKey((DWType)dateType), this.isPrimaryKey((DWType)dateType), false, this.isContentLastModifiedTime((DWType)dateType), false);
        }

        public void visitLocalDateTimeType(LocalDateTimeType localDateTimeType) {
            this.addField(this.prefix, false, FieldDataType.DATE, null, null, null, this.isIncrementalSyncKey((DWType)localDateTimeType), this.isPrimaryKey((DWType)localDateTimeType), false, this.isContentLastModifiedTime((DWType)localDateTimeType), false);
        }

        public void visitSimpleReferenceType(SimpleReferenceType simpleReferenceType) {
            WeaveTypeSimplifier.simplifyWeaveType((DWType)simpleReferenceType).accept((DWTypeVisitor)new ObjectFieldTypeVisitor(this.flattenedFields, this.fieldMap, this.incrementalFields, this.primaryKeyFields, this.prefix, this.isNullable));
        }

        private void addField(String name, boolean isNullable, FieldDataType dataType, @Nullable String format, @Nullable List<String> availableFormats, @Nullable String nativeDataType, boolean isIncrementalSyncKey, boolean isPrimaryKey, boolean isContentType, boolean isContentLastModifiedTime, boolean isContentSize) {
            if (isIncrementalSyncKey) {
                this.incrementalFields.add(name);
            }
            if (isPrimaryKey) {
                this.primaryKeyFields.add(name);
            }
            Field.FieldBuilder fieldBuilder = Field.builder().name(name).isNullable(Boolean.valueOf(isNullable)).mappedDataType(dataType).format(format).availableFormats(availableFormats).nativeDataType(nativeDataType).isContentType(Boolean.valueOf(isContentType)).isContentSize(Boolean.valueOf(isContentSize)).isContentLastModifiedTime(Boolean.valueOf(isContentLastModifiedTime));
            this.fieldMap.put(name, fieldBuilder.build());
        }

        public static FieldDataType determineFieldType(DWType metadataType) {
            StringType stringType;
            Optional formatAnnotation;
            if (metadataType instanceof StringType && (formatAnnotation = MetadataUtils.getFormat((DWType)(stringType = (StringType)metadataType))).isPresent()) {
                String formatValue;
                return switch (formatValue = (String)formatAnnotation.get()) {
                    case "date-time" -> FieldDataType.DATE;
                    case "date" -> FieldDataType.DATE_ONLY;
                    default -> FieldDataType.TEXT;
                };
            }
            return TRANSLATIONS.entrySet().stream().filter(entry -> ((Class)entry.getKey()).isInstance(metadataType)).map(Map.Entry::getValue).findFirst().orElse(() -> FieldDataType.UNSUPPORTED).get();
        }

        private boolean isNullable(DWType metadataType) {
            if (metadataType instanceof UnionType) {
                for (DWMetadata type : metadataType.getTypeMetadata()) {
                    if (!(type instanceof NullType)) continue;
                    return true;
                }
            }
            return metadataType instanceof NullType;
        }

        private record FormatInfo(@Nullable String format, @Nullable List<String> availableFormats, @Nullable String nativeDataType) {
        }

        private static class ObjectFieldUnionTypeVisitor
        implements DWTypeVisitor {
            private static final int DEFAULT_MAX_NESTED_UNION_LEVEL = 100;
            private static final int MAX_NESTED_UNION_LEVEL = Integer.parseInt(System.getProperty("max.introspection.level.number", String.valueOf(100)));
            private int unionLevel = 0;
            private boolean isNullable = false;
            private final Set<DWType> unionTypes = new HashSet<DWType>();
            private final Set<DWType> complexUnionTypes = new HashSet<DWType>();

            public void visitSimpleReferenceType(SimpleReferenceType simpleReferenceType) {
                WeaveTypeSimplifier.simplifyWeaveType((DWType)simpleReferenceType).accept((DWTypeVisitor)this);
            }

            public void visitUnionType(UnionType unionType) {
                DWType[] types;
                if (this.unionLevel == MAX_NESTED_UNION_LEVEL) {
                    LOGGER.warn("Reached max nested level of union types ({}), inference of field type was cut off.{}Set 'max.introspection.level.number' property to extend it.", (Object)MAX_NESTED_UNION_LEVEL, (Object)System.lineSeparator());
                    this.unionLevel = 0;
                    return;
                }
                ++this.unionLevel;
                for (DWType type : types = unionType.unionOf()) {
                    type.accept((DWTypeVisitor)this);
                }
                --this.unionLevel;
            }

            public void visitBooleanType(BooleanType booleanType) {
                this.unionTypes.add((DWType)booleanType);
            }

            public void visitObjectType(ObjectType objectType) {
                this.complexUnionTypes.add((DWType)objectType);
            }

            public void visitNullType(NullType nullType) {
                this.isNullable = true;
            }

            public void visitNumberType(NumberType numberType) {
                this.unionTypes.add((DWType)numberType);
            }

            public void visitStringType(StringType stringType) {
                this.unionTypes.add((DWType)stringType);
            }

            public Boolean typeIsNullable() {
                return this.isNullable;
            }

            public Set<DWType> getFlattenedUnionTypes() {
                return this.unionTypes;
            }

            public Set<DWType> getComplexUnionTypes() {
                return this.complexUnionTypes;
            }
        }
    }
}

