/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.internal.utils;

import com.mulesoft.connectivity.datacloud.internal.auth.AuthException;
import com.mulesoft.connectivity.datacloud.internal.context.ExecutionContext;
import com.mulesoft.connectivity.datacloud.internal.utils.ImpersonationTokenManager;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomHandlers {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomHandlers.class);

    private CustomHandlers() throws IllegalAccessException {
        throw new IllegalAccessException("You can't call this");
    }

    public static void impersonateAsUser(Map<String, Object> connectionParams, Map<String, Object> operationParams) throws AuthException {
        String connectorName = ExecutionContext.getConnectorName();
        String targetUserEmail = (String)operationParams.get("user");
        if (StringUtils.isBlank((CharSequence)targetUserEmail)) {
            log.info("User email is not present in request. Skipping impersonation");
            return;
        }
        log.info("Starting impersonation for user: {}", (Object)targetUserEmail);
        connectionParams.put("token_subject", targetUserEmail);
        log.debug("Using connector: {}", (Object)connectorName);
        ImpersonationTokenManager tokenManager = ImpersonationTokenManager.getInstance();
        String validAccessToken = tokenManager.getValidAccessToken(targetUserEmail, connectionParams);
        log.info("Successfully obtained access token for user: {}", (Object)targetUserEmail);
        connectionParams.put("accessToken", validAccessToken);
    }

    public static void handleImpersonationAuthenticationError(Map<String, Object> operationParams) {
        String userEmail = CustomHandlers.extractUserEmailFromParameters(operationParams);
        if (!StringUtils.isBlank((CharSequence)userEmail)) {
            log.info("Invalidating cached token for user: {} due to authentication error", (Object)userEmail);
            ImpersonationTokenManager.getInstance().invalidateToken(userEmail);
        }
    }

    private static @Nullable String extractUserEmailFromParameters(Map<String, Object> operationParams) {
        Object userParam = operationParams.get("user");
        return userParam != null ? userParam.toString() : null;
    }
}

