/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.sdk.NameIdentifierHelper;
import org.mule.weave.v2.sdk.WeaveResource;
import org.mule.weave.v2.sdk.WeaveResourceResolver;
import scala.Option;
import scala.Some;
import scala.io.BufferedSource;
import scala.io.Codec;
import scala.io.Source;

public class PathBasedResourceResolver
implements WeaveResourceResolver {
    private final List<ContentResolver> paths = new ArrayList<ContentResolver>();

    public PathBasedResourceResolver(Collection<File> files) {
        for (File f : files) {
            this.paths.add(PathBasedResourceResolver.createContentResolver(f));
        }
    }

    public Option<WeaveResource> resolve(NameIdentifier name) {
        for (ContentResolver cr : this.paths) {
            Option<InputStream> maybeResource = cr.resolve(name);
            if (!maybeResource.isDefined()) continue;
            String filePath = NameIdentifierHelper.toWeaveFilePath((NameIdentifier)name, (String)"/");
            return Option.apply((Object)WeaveResource.apply((String)filePath, (String)this.toString((InputStream)maybeResource.get())));
        }
        return Option.empty();
    }

    public String toString(InputStream is) {
        try (BufferedSource s = Source.fromInputStream((InputStream)is, (Codec)new Codec(StandardCharsets.UTF_8));){
            String string = s.mkString();
            return string;
        }
    }

    public static ContentResolver createContentResolver(File f) {
        if (f.isDirectory()) {
            return new DirectoryContentResolver(f);
        }
        return new JarContentResolver(f);
    }

    static interface ContentResolver {
        public Option<InputStream> resolve(NameIdentifier var1);
    }

    static class DirectoryContentResolver
    implements ContentResolver {
        private final File directory;

        public DirectoryContentResolver(File directory) {
            this.directory = directory;
        }

        @Override
        public Option<InputStream> resolve(NameIdentifier ni) {
            String path = NameIdentifierHelper.toWeaveFilePath((NameIdentifier)ni, (String)File.separator);
            File file = new File(this.directory, path);
            if (file.isFile()) {
                try {
                    return Some.apply((Object)new FileInputStream(file));
                }
                catch (FileNotFoundException e) {
                    return Option.empty();
                }
            }
            return Option.empty();
        }
    }

    static class JarContentResolver
    implements ContentResolver {
        private final File jarFile;

        public JarContentResolver(File jarFile) {
            this.jarFile = jarFile;
        }

        @Override
        public Option<InputStream> resolve(NameIdentifier ni) {
            try {
                ZipFile zipFile = new ZipFile(this.jarFile);
                String path = NameIdentifierHelper.toWeaveFilePath((NameIdentifier)ni, (String)"/");
                String zipEntry = path.startsWith("/") ? path.substring(1) : path;
                ZipEntry pathEntry = zipFile.getEntry(zipEntry);
                if (pathEntry != null) {
                    return Some.apply((Object)zipFile.getInputStream(pathEntry));
                }
                return Option.empty();
            }
            catch (IOException e) {
                return Option.empty();
            }
        }
    }
}

