/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.internal.monitor;

import com.mulesoft.connectivity.datacloud.internal.utils.HierarchicalPropertyResolver;
import com.salesforce.dataconnectors.api.context.ContextHelper;
import java.util.Locale;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHealthMonitor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractHealthMonitor.class);
    protected static final long DEFAULT_HEALTH_CHECK_INTERVAL_SECONDS = 300L;
    protected static final long MINIMUM_HEALTH_CHECK_INTERVAL_SECONDS = 30L;
    protected final ScheduledExecutorService healthCheckScheduler;
    protected final String connectorName;
    protected final AtomicBoolean isMonitoring = new AtomicBoolean(false);
    protected final AtomicReference<@Nullable ScheduledFuture<?>> healthCheckTask = new AtomicReference();

    protected AbstractHealthMonitor(String connectorName, String monitorType) {
        this.connectorName = connectorName;
        this.healthCheckScheduler = ContextHelper.getContextAwareExecutorProvider().wrapScheduledExecutorServiceWithContext(Executors.newSingleThreadScheduledExecutor(r -> {
            Thread thread = new Thread(r, monitorType + "-" + connectorName);
            thread.setDaemon(true);
            thread.setPriority(1);
            return thread;
        }));
    }

    public void startMonitoring() {
        this.startMonitoring(this.getConfiguredHealthCheckInterval());
    }

    private void startMonitoring(long intervalSeconds) {
        if (this.isMonitoring.compareAndSet(false, true)) {
            long validatedInterval = Math.max(intervalSeconds, 30L);
            if (validatedInterval != intervalSeconds) {
                log.warn("{} health check interval adjusted from {} to {} seconds (minimum allowed)", new Object[]{this.getMonitorTypeName(), intervalSeconds, validatedInterval});
            }
            log.info("Starting {} health monitoring for connector '{}' with interval of {} seconds", new Object[]{this.getMonitorTypeName().toLowerCase(Locale.ROOT), this.connectorName, validatedInterval});
            this.healthCheckTask.set(this.healthCheckScheduler.scheduleWithFixedDelay(this::performHealthCheck, validatedInterval, validatedInterval, TimeUnit.SECONDS));
        } else {
            log.debug("{} health monitoring is already running for connector '{}'", (Object)this.getMonitorTypeName(), (Object)this.connectorName);
        }
    }

    public void stopMonitoring() {
        if (this.isMonitoring.compareAndSet(true, false)) {
            log.info("Stopping {} health monitoring for connector '{}'", (Object)this.getMonitorTypeName().toLowerCase(Locale.ROOT), (Object)this.connectorName);
            ScheduledFuture<?> task = this.healthCheckTask.get();
            if (!task.isCancelled()) {
                task.cancel(false);
            }
            this.healthCheckScheduler.shutdown();
            try {
                if (!this.healthCheckScheduler.awaitTermination(5L, TimeUnit.SECONDS)) {
                    log.warn("{} health check scheduler did not terminate gracefully within 5 seconds for connector '{}'", (Object)this.getMonitorTypeName(), (Object)this.connectorName);
                    this.healthCheckScheduler.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.warn("Interrupted while waiting for {} health check scheduler termination for connector '{}'", (Object)this.getMonitorTypeName().toLowerCase(Locale.ROOT), (Object)this.connectorName);
                this.healthCheckScheduler.shutdownNow();
            }
        }
    }

    public void performHealthCheck() {
        try {
            log.debug("Performing {} health check for connector '{}'", (Object)this.getMonitorTypeName().toLowerCase(Locale.ROOT), (Object)this.connectorName);
            this.doHealthCheck();
        }
        catch (Exception e) {
            log.warn("Error occurred during {} health check for connector '{}': {}", new Object[]{this.getMonitorTypeName().toLowerCase(Locale.ROOT), this.connectorName, e.getMessage(), e});
        }
    }

    public boolean isMonitoring() {
        return this.isMonitoring.get();
    }

    private long getConfiguredHealthCheckInterval() {
        try {
            long interval;
            String value = HierarchicalPropertyResolver.getConfigValue(this.getHealthCheckIntervalProperty(), this.connectorName);
            if (value != null && (interval = Long.parseLong(value)) > 0L) {
                return interval;
            }
        }
        catch (NumberFormatException e) {
            log.warn("Invalid value for property {}, using default: {}", (Object)this.getHealthCheckIntervalProperty(), (Object)300L);
        }
        return 300L;
    }

    protected abstract void doHealthCheck();

    protected abstract String getHealthCheckIntervalProperty();

    protected abstract String getMonitorTypeName();
}

