/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.internal.monitor;

import com.github.benmanes.caffeine.cache.stats.CacheStats;
import com.mulesoft.connectivity.datacloud.internal.monitor.AbstractHealthMonitor;
import com.mulesoft.connectivity.datacloud.internal.service.CachingService;
import com.mulesoft.connectivity.datacloud.internal.service.ServiceProvider;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheHealthMonitor
extends AbstractHealthMonitor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CacheHealthMonitor.class);
    private static final String HEALTH_CHECK_INTERVAL_PROPERTY = "com.mulesoft.connectivity.datacloud.caching.healthCheckIntervalSeconds";
    private static final double DEFAULT_HIT_RATE_THRESHOLD = 0.7;
    private static final double DEFAULT_EVICTION_RATE_THRESHOLD = 0.1;
    private final CachingService cachingService;

    public CacheHealthMonitor(String connectorName) {
        super(connectorName, "CacheHealthMonitor");
        this.cachingService = ServiceProvider.getCachingService(connectorName);
    }

    @Override
    protected void doHealthCheck() {
        CacheStats cacheStats = this.cachingService.getCacheStats();
        this.logCacheHealthReport(cacheStats);
        this.analyzeCacheMetrics(cacheStats);
    }

    private void logCacheHealthReport(CacheStats cacheStats) {
        log.info("Cache health report for connector '{}': requests={}, hits={}, misses={}, hitRate={}%, evictions={}, loadCount={}, loadTime={}ms, averageLoadTime={}ms", new Object[]{this.connectorName, cacheStats.requestCount(), cacheStats.hitCount(), cacheStats.missCount(), cacheStats.hitRate() * 100.0, cacheStats.evictionCount(), cacheStats.loadCount(), cacheStats.totalLoadTime() / 1000000L, cacheStats.averageLoadPenalty() / 1000000.0});
    }

    private void analyzeCacheMetrics(CacheStats cacheStats) {
        try {
            long maxCacheSize = this.cachingService.getMaxCacheSize();
            this.analyzeHitRate(cacheStats);
            this.analyzeEvictionRate(cacheStats, maxCacheSize);
            this.analyzeLoadPerformance(cacheStats);
            this.analyzeRequestPatterns(cacheStats);
        }
        catch (Exception e) {
            log.debug("Could not analyze cache metrics for recommendations: {}", (Object)e.getMessage());
        }
    }

    private void analyzeHitRate(CacheStats cacheStats) {
        double hitRate = cacheStats.hitRate();
        double threshold = 0.7;
        if (cacheStats.requestCount() > 0L) {
            if (hitRate < threshold) {
                log.warn("Cache hit rate ({}%) is below threshold ({}%) for connector '{}'. Consider increasing cache size or adjusting expiration time. Total requests: {}, hits: {}, misses: {}", new Object[]{hitRate * 100.0, threshold * 100.0, this.connectorName, cacheStats.requestCount(), cacheStats.hitCount(), cacheStats.missCount()});
            } else {
                log.debug("Cache hit rate ({}%) is healthy for connector '{}'", (Object)(hitRate * 100.0), (Object)this.connectorName);
            }
        }
    }

    private void analyzeEvictionRate(CacheStats cacheStats, long maxCacheSize) {
        long evictionCount = cacheStats.evictionCount();
        long requestCount = cacheStats.requestCount();
        if (evictionCount > 0L && requestCount > 0L) {
            double evictionRate = (double)evictionCount / (double)requestCount;
            double threshold = 0.1;
            if (evictionRate > threshold) {
                log.warn("Cache eviction rate ({}%) is above threshold ({}%) for connector '{}'. Consider increasing cache size from current maximum of {}. Evictions: {}, Requests: {}", new Object[]{evictionRate * 100.0, threshold * 100.0, this.connectorName, maxCacheSize, evictionCount, requestCount});
            } else {
                log.debug("Cache eviction rate ({}%) is acceptable for connector '{}'", (Object)(evictionRate * 100.0), (Object)this.connectorName);
            }
        }
    }

    private void analyzeLoadPerformance(CacheStats cacheStats) {
        if (cacheStats.loadCount() > 0L) {
            double averageLoadTimeMs = cacheStats.averageLoadPenalty() / 1000000.0;
            if (averageLoadTimeMs > 1000.0) {
                log.warn("Cache average load time ({}ms) is high for connector '{}'. Consider optimizing the cache loader function. Load count: {}", new Object[]{averageLoadTimeMs, this.connectorName, cacheStats.loadCount()});
            } else {
                log.debug("Cache load performance is good for connector '{}': average load time {}ms", (Object)this.connectorName, (Object)averageLoadTimeMs);
            }
        }
    }

    private void analyzeRequestPatterns(CacheStats cacheStats) {
        long requestCount = cacheStats.requestCount();
        if (requestCount > 1000L) {
            double missRate = cacheStats.missRate();
            log.info("Cache usage summary for connector '{}': {} total requests, {}% miss rate, {} evictions", new Object[]{this.connectorName, requestCount, missRate * 100.0, cacheStats.evictionCount()});
        }
    }

    @Override
    protected String getHealthCheckIntervalProperty() {
        return HEALTH_CHECK_INTERVAL_PROPERTY;
    }

    @Override
    protected String getMonitorTypeName() {
        return "Cache";
    }
}

