/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.api.connector;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.mulesoft.connectivity.datacloud.api.connector.DataCloudConnector;
import com.mulesoft.connectivity.datacloud.api.model.DataCloudConnectorModel;
import com.mulesoft.connectivity.datacloud.internal.Runtime;
import com.salesforce.dataconnectors.api.Connector;
import com.salesforce.dataconnectors.api.ConnectorFactory;
import com.salesforce.dataconnectors.api.exception.ConnectorException;
import com.salesforce.dataconnectors.api.exception.ExceptionCategory;
import com.salesforce.dataconnectors.api.model.connection.ConnectionDefinition;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataCloudConnectorFactory
implements ConnectorFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataCloudConnectorFactory.class);
    private static final String DESCRIPTOR_LOCATOR = "com/mulesoft/connectivity/datacloud/connector/MSDCConnector.info";
    private static final String CONNECTION_DEFINITION = "ConnectionDefinition.json";
    private static final String USE_PROXY_PROPERTIES_PROPERTY = "org.asynchttpclient.useProxyProperties";
    private static final String PROXY_HOST_PROPERTY = "http.proxyHost";
    private static final String PROXY_PORT_PROPERTY = "http.proxyPort";
    private final Map<String, Connector> connectors = new HashMap<String, Connector>();

    public DataCloudConnectorFactory() throws IllegalArgumentException {
        DataCloudConnectorFactory.setupSystemProperties();
        try {
            DataCloudConnectorFactory.class.getClassLoader().resources(DESCRIPTOR_LOCATOR).forEach(this::discoverConnectorsFromDescriptorLocator);
        }
        catch (UncheckedIOException e) {
            throw new IllegalArgumentException("Failed to find any descriptors", e);
        }
    }

    private static void setupSystemProperties() {
        String httpUseProxyProperties = System.getenv("HTTP_USE_PROXY_PROPERTIES");
        if (Boolean.parseBoolean(System.getenv("PROD_MODE"))) {
            DataCloudConnectorFactory.setProperty(USE_PROXY_PROPERTIES_PROPERTY, "true");
        } else if (httpUseProxyProperties != null) {
            String httpProxyPort;
            DataCloudConnectorFactory.setProperty(USE_PROXY_PROPERTIES_PROPERTY, httpUseProxyProperties);
            String httpProxyHost = System.getenv("HTTP_PROXY_HOST");
            if (httpProxyHost != null) {
                DataCloudConnectorFactory.setProperty(PROXY_HOST_PROPERTY, httpProxyHost);
            }
            if ((httpProxyPort = System.getenv("HTTP_PROXY_PORT")) != null) {
                DataCloudConnectorFactory.setProperty(PROXY_PORT_PROPERTY, httpProxyPort);
            }
        }
    }

    private static void setProperty(String propertyName, String value) {
        System.setProperty(propertyName, value);
        LOGGER.debug("Setting system property `{}` to {}", (Object)propertyName, (Object)System.getProperty(propertyName));
    }

    public Map<String, Connector> getConnectors() {
        return this.connectors;
    }

    private void discoverConnectorsFromDescriptorLocator(URL url) {
        try (InputStream descriptorContents = url.openConnection().getInputStream();){
            if (descriptorContents == null) {
                return;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(descriptorContents, StandardCharsets.UTF_8));
            while (reader.ready()) {
                String connectorReference = reader.readLine();
                if (connectorReference == null || connectorReference.startsWith("#") || connectorReference.isBlank()) continue;
                this.loadConnector(connectorReference);
            }
        }
        catch (IOException | IllegalArgumentException ex) {
            LOGGER.error(String.format("Failed to load connectors from %s", url), (Throwable)ex);
        }
    }

    private void loadConnector(String connectorSelector) {
        try {
            Runtime runtime = new Runtime.Builder().build();
            DataCloudConnectorModel connectorModel = runtime.loadConnectorModel(connectorSelector);
            ConnectionDefinition connectionDefinition = this.loadConnectionDefinition(connectorModel.getName().toLowerCase(Locale.ROOT));
            this.connectors.put(connectorModel.getName(), new DataCloudConnector(connectorModel, connectionDefinition, runtime.getModelInterpreter()));
        }
        catch (ConnectorException e) {
            LOGGER.error("Failed to load connector in {}", (Object)connectorSelector, (Object)e);
        }
    }

    private @Nullable InputStream getResourceInputStream(String connectorName) {
        String resourceName = "com/mulesoft/connectivity/datacloud/connector/" + connectorName + "/ConnectionDefinition.json";
        return this.getClass().getClassLoader().getResourceAsStream(resourceName);
    }

    private ConnectionDefinition loadConnectionDefinition(String connectorName) throws ConnectorException {
        ConnectionDefinition connectionDefinition;
        block9: {
            InputStream resource = this.getResourceInputStream(connectorName);
            try {
                if (resource == null) {
                    throw new ConnectorException(String.format("Resource %s not found: ", CONNECTION_DEFINITION), ExceptionCategory.INTERNAL);
                }
                ObjectMapper objMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS})).enable(new DeserializationFeature[]{DeserializationFeature.READ_ENUMS_USING_TO_STRING})).build();
                connectionDefinition = (ConnectionDefinition)objMapper.readValue(resource, ConnectionDefinition.class);
                if (resource == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (resource != null) {
                        try {
                            resource.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ConnectorException("Error deserializing the JSON file : " + e.getMessage(), (Throwable)e, ExceptionCategory.INTERNAL);
                }
            }
            resource.close();
        }
        return connectionDefinition;
    }
}

