/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.internal.operation;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.ZonedDateTimeSerializer;
import com.mulesoft.connectivity.datacloud.api.model.DataCloudConnectionProviderModel;
import com.mulesoft.connectivity.datacloud.internal.ConnectivityMessage;
import com.mulesoft.connectivity.datacloud.internal.connection.DataCloudConnection;
import com.mulesoft.connectivity.datacloud.internal.context.ExecutionContext;
import com.mulesoft.connectivity.datacloud.internal.operation.DataCloudParameters;
import com.mulesoft.connectivity.datacloud.internal.operation.DataProvider;
import com.mulesoft.connectivity.datacloud.internal.operation.ExecutionFunctionBuilder;
import com.mulesoft.connectivity.datacloud.internal.operation.ExecutionParameters;
import com.mulesoft.connectivity.datacloud.internal.operation.ExecutionUtils;
import com.mulesoft.connectivity.datacloud.internal.operation.OperationsIndex;
import com.mulesoft.connectivity.datacloud.internal.ratelimiter.RateLimitingConfiguration;
import com.mulesoft.connectivity.datacloud.internal.ratelimiter.RateLimitingPolicy;
import com.mulesoft.connectivity.datacloud.internal.retry.RetryConfiguration;
import com.mulesoft.connectivity.linkweave.api.interpreter.Connection;
import com.mulesoft.connectivity.linkweave.api.interpreter.ModelInterpreter;
import com.mulesoft.connectivity.linkweave.api.interpreter.Page;
import com.mulesoft.connectivity.linkweave.api.model.BaseExecutableComponentModel;
import com.mulesoft.connectivity.linkweave.api.model.ExecutableComponentModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.BaseConnectionProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationModel;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationResult;
import com.mulesoft.connectivity.linkweave.api.model.operation.ResultError;
import com.mulesoft.connectivity.linkweave.api.model.trigger.TriggerItem;
import com.mulesoft.connectivity.linkweave.api.model.trigger.TriggerModel;
import com.mulesoft.connectivity.linkweave.api.model.trigger.TriggerPage;
import com.salesforce.dataconnectors.api.service.ConnectorServicesProvider;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityCollectionProvider
implements DataProvider<ConnectivityMessage> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EntityCollectionProvider.class);
    private final String connectorName;
    private final ModelInterpreter modelInterpreter;
    private final DataCloudConnectionProviderModel connectionProviderModel;
    private final List<OperationsIndex.OperationWrapper> operations;
    private final RetryConfiguration retryConfiguration;
    private final RateLimitingPolicy rateLimitingPolicy;
    private static final JavaTimeModule JAVA_TIME_MODULE = (JavaTimeModule)new JavaTimeModule().addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd"))).addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSSS"))).addSerializer(ZonedDateTime.class, (JsonSerializer)new ZonedDateTimeSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SZ")));
    private static final ObjectMapper OBJECT_MAPPER = ((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().addModule((Module)JAVA_TIME_MODULE)).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).build();

    @Override
    public void execute(DataCloudConnection connection, DataCloudParameters parameters, Consumer<ConnectivityMessage> recordConsumer) {
        ExecutionContext.setConnectorName(this.connectorName);
        this.execute(0, connection, parameters.getParameters(), parameters.getIncrementalParameters(), parameters.getFieldList(), recordConsumer);
    }

    private void execute(int executionStep, DataCloudConnection dataCloudConnection, Map<String, Object> parameters, Map<String, Object> incrementalAttributes, List<String> fieldList, Consumer<ConnectivityMessage> consumer) {
        OperationsIndex.OperationWrapper current = this.operations.get(executionStep);
        ExecutableComponentModel<?> executableComponentModel = current.operation();
        if (executableComponentModel instanceof TriggerModel) {
            TriggerModel triggerModel = (TriggerModel)executableComponentModel;
            log.debug("Executing trigger {}", current.operation());
            this.executeTrigger(executionStep, dataCloudConnection, parameters, incrementalAttributes, fieldList, consumer, triggerModel);
        } else {
            log.debug("Executing operation {}", current.operation());
            this.executeOperation(executionStep, dataCloudConnection, parameters, fieldList, consumer, (OperationModel)current.operation());
        }
    }

    private void executeTrigger(int executionStep, DataCloudConnection dataCloudConnection, Map<String, Object> parameters, Map<String, Object> incrementalAttributes, List<String> fieldList, Consumer<ConnectivityMessage> consumer, TriggerModel triggerModel) {
        OperationResult pageResult;
        Object greatestWatermark = incrementalAttributes.get("greatestWatermark");
        Object initialWatermark = greatestWatermark == null ? this.modelInterpreter.getInitialWatermark((Connection)Connection.of((BaseConnectionProviderModel)this.connectionProviderModel, dataCloudConnection.getParameters()), (BaseExecutableComponentModel)triggerModel, parameters) : greatestWatermark;
        ExecutionParameters executionParameters = ExecutionParameters.builder().connectionProviderModel(this.connectionProviderModel).executableModel((ExecutableComponentModel<?>)triggerModel).connectionInfo(dataCloudConnection.getParameters()).parameters(parameters).incrementalAttributes(incrementalAttributes).initialWatermark(initialWatermark).build();
        ExecutionFunctionBuilder.FunctionName operationType = ExecutionFunctionBuilder.FunctionName.TRIGGER;
        while (!this.isLastPage(pageResult = this.executeAndProcessResult(executionStep, dataCloudConnection, operationType, executionParameters, fieldList, consumer))) {
            executionParameters = executionParameters.toBuilder().parameters(((TriggerPage)pageResult.getValue()).getNextData()).build();
            operationType = ExecutionFunctionBuilder.FunctionName.TRIGGER_NEXT_PAGE;
        }
    }

    private void executeOperation(int executionStep, DataCloudConnection dataCloudConnection, Map<String, Object> parameters, List<String> fieldList, Consumer<ConnectivityMessage> consumer, OperationModel operationModel) {
        OperationsIndex.OperationWrapper current = this.operations.get(executionStep);
        ExecutionParameters executionParameters = ExecutionParameters.builder().connectionProviderModel(this.connectionProviderModel).executableModel((ExecutableComponentModel<?>)operationModel).connectionInfo(dataCloudConnection.getParameters()).parameters(parameters).customHandler(current.customHandler()).build();
        if (operationModel.isPaginated()) {
            OperationResult result;
            OperationResult pageResult;
            ExecutionFunctionBuilder.FunctionName operationType = ExecutionFunctionBuilder.FunctionName.OPERATION;
            while (!this.isLastPage(pageResult = (result = this.executeAndProcessResult(executionStep, dataCloudConnection, operationType, executionParameters, fieldList, consumer)).map(p -> (Page)p))) {
                HashMap<String, Object> nextPageArgs = new HashMap<String, Object>(parameters);
                ((Page)pageResult.getValue()).getNextPage().ifPresent(args -> nextPageArgs.putAll((Map)((Object)args)));
                executionParameters = executionParameters.toBuilder().parameters(nextPageArgs).build();
                operationType = ExecutionFunctionBuilder.FunctionName.OPERATION_NEXT_PAGE;
            }
        } else {
            this.executeAndProcessResult(executionStep, dataCloudConnection, ExecutionFunctionBuilder.FunctionName.OPERATION, executionParameters, fieldList, consumer);
        }
    }

    private <T> OperationResult<T> executeAndProcessResult(int executionStep, DataCloudConnection dataCloudConnection, ExecutionFunctionBuilder.FunctionName operationType, ExecutionParameters executionParameters, List<String> fieldList, Consumer<ConnectivityMessage> consumer) {
        OperationsIndex.OperationWrapper current = this.operations.get(executionStep);
        Function executionFunction = ExecutionFunctionBuilder.builder(this.modelInterpreter).build(operationType);
        RateLimitingConfiguration rateLimitingConfiguration = RateLimitingConfiguration.builder().operationRateLimitConfigurations(current.rateLimitConfigurations()).connectionRateLimitConfigurations(dataCloudConnection.getConnectionModel().getRateLimitConfigurationModels()).build();
        OperationResult result = ExecutionUtils.execute(this.connectorName, executionFunction, executionParameters, dataCloudConnection, this.retryConfiguration, rateLimitingConfiguration, this.rateLimitingPolicy);
        this.processResult(executionStep, dataCloudConnection, executionParameters, result, fieldList, consumer);
        return result;
    }

    private void processResult(int executionStep, DataCloudConnection dataCloudConnection, ExecutionParameters executionParameters, OperationResult<?> result, List<String> fieldList, Consumer<ConnectivityMessage> consumer) {
        if (!result.isSuccess()) {
            ResultError errorValue = result.getErrorValue();
            log.error("Unsuccessful execution Error: {}{}Cause: {}", new Object[]{errorValue.getValue(), System.lineSeparator(), errorValue.getDescription()});
            return;
        }
        Object value = result.getValue();
        if (value instanceof Page) {
            Page page = (Page)value;
            log.info("Records present in current page: {}", (Object)page.getItems().size());
            for (Object item : page.getItems()) {
                Map newParameters;
                boolean isContainer;
                OperationsIndex.OperationWrapper current = this.operations.get(executionStep);
                boolean bl = isContainer = current.isContainer() != null && (Boolean)current.isContainer().apply(List.of(item)) != false;
                if (isContainer && current.containerBinding() != null) {
                    newParameters = (Map)current.containerBinding().apply(List.of(item));
                    this.execute(executionStep, dataCloudConnection, newParameters, executionParameters.getIncrementalAttributes(), fieldList, consumer);
                }
                if (!isContainer || current.doProcessContainer()) {
                    this.processItem(executionStep, item, fieldList, consumer, messageBuilder -> {
                        if (page instanceof TriggerPage) {
                            TriggerPage triggerPage = (TriggerPage)page;
                            messageBuilder.watermark(triggerPage.getNextPoll().getGreatestWatermark());
                        }
                        return messageBuilder;
                    });
                }
                if (executionStep >= this.operations.size() - 1) continue;
                newParameters = (Map)current.dependencyBinding().apply(List.of(item));
                HashMap<String, Object> params = new HashMap<String, Object>((Map)executionParameters.getParameters());
                params.putAll(newParameters);
                this.execute(executionStep + 1, dataCloudConnection, params, executionParameters.getIncrementalAttributes(), fieldList, consumer);
            }
        } else {
            this.processItem(executionStep, value, fieldList, consumer, UnaryOperator.identity());
            OperationsIndex.OperationWrapper current = this.operations.get(executionStep);
            if (executionStep < this.operations.size() - 1) {
                Map newParameters = (Map)current.dependencyBinding().apply(List.of(value));
                HashMap<String, Object> params = new HashMap<String, Object>((Map)executionParameters.getParameters());
                params.putAll(newParameters);
                this.execute(executionStep + 1, dataCloudConnection, params, executionParameters.getIncrementalAttributes(), fieldList, consumer);
            }
        }
    }

    private void processItem(int executionStep, Object item, List<String> fieldList, Consumer<ConnectivityMessage> consumer, UnaryOperator<ConnectivityMessage.ConnectivityMessageBuilder> watermarkSetter) {
        Object object;
        OperationsIndex.OperationWrapper current = this.operations.get(executionStep);
        if (item instanceof TriggerItem) {
            TriggerItem triggerItem = (TriggerItem)item;
            object = triggerItem.getValue();
        } else {
            object = item;
        }
        Object data = object;
        EntityCollectionProvider.flattenObject(data, fieldList).forEach(i -> {
            ConnectivityMessage.ConnectivityMessageBuilder messageBuilder = ConnectivityMessage.builder().type("application/json").content(i).type(current.objectName());
            messageBuilder = (ConnectivityMessage.ConnectivityMessageBuilder)watermarkSetter.apply(messageBuilder);
            consumer.accept(messageBuilder.build());
        });
    }

    private boolean isLastPage(OperationResult<? extends Page<?>> pageResult) {
        return ((Page)pageResult.orElseThrow(errorValue -> new RuntimeException("Failed to extract the result of the operation: " + String.valueOf(errorValue.getValue()) + System.lineSeparator() + "Cause: " + errorValue.getDescription().orElse("Unknown") + System.lineSeparator()))).getNextPage().isEmpty();
    }

    public static List<Map<String, Object>> flattenObject(Object item, List<String> fieldList) {
        ArrayList<Map<String, Object>> flattenedList = new ArrayList<Map<String, Object>>();
        try {
            Map map = (Map)OBJECT_MAPPER.convertValue(item, Map.class);
            EntityCollectionProvider.flatten(map, new LinkedHashMap<String, Object>(), null, flattenedList, fieldList);
        }
        catch (IllegalArgumentException e) {
            log.error("Error flattening object: {}", (Object)e.getMessage());
        }
        return flattenedList;
    }

    private static void flatten(Map<String, Object> map, Map<String, Object> currentFlattened, @Nullable String parentKey, List<Map<String, Object>> flattenedList, List<String> fieldList) {
        List<Map<String, Object>> newRecords = new ArrayList<Map<String, Object>>();
        newRecords.add(currentFlattened);
        String flattenSeparator = ".";
        if (ConnectorServicesProvider.getGateService().isOpen("flattenWithUnderscoresEnabled")) {
            flattenSeparator = "_";
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = (String)(parentKey != null ? parentKey + flattenSeparator : "") + entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                newRecords = EntityCollectionProvider.flattenMapItems(newRecords, (Map)value, key, fieldList);
                continue;
            }
            if (value instanceof List) {
                if (ConnectorServicesProvider.getGateService().isOpen("processArrayAsTextEnabled")) {
                    newRecords = EntityCollectionProvider.flattenListItemAsText((List)value, newRecords, key);
                    continue;
                }
                newRecords = EntityCollectionProvider.flattenListItems((List)value, newRecords, key, fieldList);
                continue;
            }
            for (Map map2 : newRecords) {
                if (!fieldList.contains(key)) continue;
                map2.put(key, value);
            }
        }
        flattenedList.addAll(newRecords);
    }

    private static List<Map<String, Object>> flattenListItems(List<?> items, List<Map<String, Object>> records, String key, List<String> fieldList) {
        ArrayList<Map<String, Object>> flattenedChildren = new ArrayList<Map<String, Object>>();
        if (!items.isEmpty()) {
            for (Object listItem : items) {
                for (Map<String, Object> recordItem : records) {
                    LinkedHashMap<String, Object> newRecord = new LinkedHashMap<String, Object>(recordItem);
                    if (listItem instanceof Map) {
                        EntityCollectionProvider.flatten((Map)listItem, newRecord, key, flattenedChildren, fieldList);
                        continue;
                    }
                    if (fieldList.contains(key)) {
                        newRecord.put(key, listItem);
                    }
                    flattenedChildren.add(newRecord);
                }
            }
        } else {
            for (Map<String, Object> recordItem : records) {
                LinkedHashMap<String, Object> newRecord = new LinkedHashMap<String, Object>(recordItem);
                if (fieldList.contains(key)) {
                    newRecord.put(key, null);
                }
                flattenedChildren.add(newRecord);
            }
        }
        return flattenedChildren;
    }

    private static List<Map<String, Object>> flattenListItemAsText(List<?> items, List<Map<String, Object>> records, String key) {
        ArrayList<Map<String, Object>> flattenedChildren = new ArrayList<Map<String, Object>>();
        if (!items.isEmpty()) {
            for (Map<String, Object> recordItem : records) {
                LinkedHashMap<String, Object> newRecord = new LinkedHashMap<String, Object>(recordItem);
                newRecord.put(key, OBJECT_MAPPER.writeValueAsString(items));
                flattenedChildren.add(newRecord);
            }
        } else {
            for (Map<String, Object> recordItem : records) {
                LinkedHashMap<String, Object> newRecord = new LinkedHashMap<String, Object>(recordItem);
                newRecord.put(key, null);
                flattenedChildren.add(newRecord);
            }
        }
        return flattenedChildren;
    }

    private static List<Map<String, Object>> flattenMapItems(List<Map<String, Object>> records, Map<String, Object> value, String key, List<String> fieldList) {
        ArrayList<Map<String, Object>> flattenedChildren = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> recordItem : records) {
            LinkedHashMap<String, Object> newRecord = new LinkedHashMap<String, Object>(recordItem);
            EntityCollectionProvider.flatten(value, newRecord, key, flattenedChildren, fieldList);
        }
        return flattenedChildren;
    }

    @Generated
    public EntityCollectionProvider(String connectorName, ModelInterpreter modelInterpreter, DataCloudConnectionProviderModel connectionProviderModel, List<OperationsIndex.OperationWrapper> operations, RetryConfiguration retryConfiguration, RateLimitingPolicy rateLimitingPolicy) {
        this.connectorName = connectorName;
        this.modelInterpreter = modelInterpreter;
        this.connectionProviderModel = connectionProviderModel;
        this.operations = operations;
        this.retryConfiguration = retryConfiguration;
        this.rateLimitingPolicy = rateLimitingPolicy;
    }
}

