/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.internal.operation;

import com.mulesoft.connectivity.datacloud.internal.connection.DataCloudConnection;
import com.mulesoft.connectivity.datacloud.internal.operation.ExecutionParameters;
import com.mulesoft.connectivity.datacloud.internal.ratelimiter.RateLimitingConfiguration;
import com.mulesoft.connectivity.datacloud.internal.ratelimiter.RateLimitingPolicy;
import com.mulesoft.connectivity.datacloud.internal.ratelimiter.RateLimitingService;
import com.mulesoft.connectivity.datacloud.internal.retry.AuthenticationRetryStrategy;
import com.mulesoft.connectivity.datacloud.internal.retry.RetryConfiguration;
import com.mulesoft.connectivity.datacloud.internal.retry.RetryStrategy;
import com.mulesoft.connectivity.datacloud.internal.retry.adjustment.AdjustmentContext;
import com.mulesoft.connectivity.datacloud.internal.retry.adjustment.ParameterAdjuster;
import com.mulesoft.connectivity.datacloud.internal.utils.CustomHandlerMapper;
import com.mulesoft.connectivity.linkweave.api.interpreter.ConnectorExecutionException;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationResult;
import com.mulesoft.connectivity.linkweave.api.model.operation.ResultError;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;
import org.mule.weave.v2.core.exception.ExecutionException;
import org.mule.weave.v2.module.http.functions.exceptions.UrlConnectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExecutionUtils.class);

    private ExecutionUtils() {
    }

    public static <T> OperationResult<T> execute(String connectorName, Function<ExecutionParameters, OperationResult<T>> executeFunction, ExecutionParameters executionParameters, DataCloudConnection connection, RetryConfiguration retryConfiguration, RateLimitingConfiguration rateLimitingConfiguration, RateLimitingPolicy rateLimitingPolicy) {
        HashMap<Class<? extends RetryStrategy>, Integer> strategyAttempts = new HashMap<Class<? extends RetryStrategy>, Integer>();
        int globalAttemptNumber = 1;
        ExecutionParameters currentParameters = ExecutionUtils.applyCustomHandler(executionParameters, connection);
        while (true) {
            Optional<ParameterAdjuster> adjusterOpt;
            OperationResult result;
            RateLimitingService.execute(connectorName, currentParameters, rateLimitingConfiguration, rateLimitingPolicy);
            try {
                result = executeFunction.apply(currentParameters);
            }
            catch (ConnectorExecutionException e) {
                ExecutionException executionException = e.getExecutionException();
                if (executionException instanceof UrlConnectionException) {
                    UrlConnectionException urlConnectionException = (UrlConnectionException)executionException;
                    log.error("Connection exception occurred", (Throwable)urlConnectionException);
                    result = OperationResult.failure((ResultError)ResultError.error((String)urlConnectionException.getMessage(), (Object)urlConnectionException, (String)"Timeout", List.of("SERVER_ERROR", "CONNECTION_TIMEOUT", "RETRY"), Map.of()));
                }
                throw e;
            }
            if (result.isSuccess()) {
                return result;
            }
            Optional<RetryStrategy> strategyOpt = retryConfiguration.findStrategyFor(result, strategyAttempts);
            if (strategyOpt.isEmpty()) {
                log.debug("No retry strategy found for global attempt {}, returning result", (Object)globalAttemptNumber);
                return result;
            }
            RetryStrategy strategy = strategyOpt.get();
            Class<?> strategyClass = strategy.getClass();
            if (!(strategy instanceof AuthenticationRetryStrategy)) {
                strategyAttempts.put(AuthenticationRetryStrategy.class, 0);
                log.debug("Reset authentication strategy attempts due to {} strategy execution", (Object)strategyClass.getSimpleName());
            }
            int strategySpecificAttempt = strategyAttempts.getOrDefault(strategyClass, 0) + 1;
            strategyAttempts.put(strategyClass, strategySpecificAttempt);
            log.debug("Retrying with strategy {} (strategy attempt {}/{}, global attempt {})", new Object[]{strategy.getClass().getSimpleName(), strategySpecificAttempt, strategy.getMaxAttempts(), globalAttemptNumber});
            long delayMillis = strategy.getDelayMillis(result, strategySpecificAttempt);
            if (delayMillis > 0L) {
                try {
                    log.debug("Applying retry delay of {} ms", (Object)delayMillis);
                    Thread.sleep(delayMillis);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    log.warn("Retry delay interrupted", (Throwable)e);
                    return result;
                }
            }
            if ((adjusterOpt = strategy.getParameterAdjuster()).isPresent()) {
                AdjustmentContext context = AdjustmentContext.builder().connection(connection).lastResult(result).attemptNumber(strategySpecificAttempt).build();
                currentParameters = adjusterOpt.get().adjust(currentParameters, context);
                log.debug("Parameters adjusted by {} strategy for attempt {}", (Object)strategy.getClass().getSimpleName(), (Object)strategySpecificAttempt);
            }
            ++globalAttemptNumber;
        }
    }

    private static ExecutionParameters applyCustomHandler(ExecutionParameters executionParameters, DataCloudConnection connection) {
        try {
            Map<String, Object> connectionParams = connection.getParameters();
            Map operationParams = (Map)executionParameters.getParameters();
            CustomHandlerMapper.getHandlerFunction(executionParameters.getCustomHandler()).ifPresent(handler -> handler.accept(connectionParams, operationParams));
            return executionParameters.toBuilder().connectionInfo(connectionParams).build();
        }
        catch (Exception e) {
            log.warn("Failed to apply custom handler, using original parameters", (Throwable)e);
            return executionParameters;
        }
    }
}

