/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.internal.utils;

import com.mulesoft.connectivity.datacloud.api.model.CustomHandler;
import com.mulesoft.connectivity.datacloud.internal.auth.AuthException;
import com.mulesoft.connectivity.datacloud.internal.utils.CustomHandlers;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;

public class CustomHandlerMapper {
    private static final Map<CustomHandler, BiConsumer<Map<String, Object>, Map<String, Object>>> CUSTOM_HANDLER_MAP = new HashMap<CustomHandler, BiConsumer<Map<String, Object>, Map<String, Object>>>();
    private static final Map<CustomHandler, Consumer<Map<String, Object>>> CUSTOM_ERROR_HANDLER_MAP = new HashMap<CustomHandler, Consumer<Map<String, Object>>>();

    public static Optional<BiConsumer<Map<String, Object>, Map<String, Object>>> getHandlerFunction(@Nullable CustomHandler handler) {
        return handler == null ? Optional.empty() : Optional.ofNullable(CUSTOM_HANDLER_MAP.get(handler));
    }

    public static Optional<Consumer<Map<String, Object>>> getErrorHandlerFunction(@Nullable CustomHandler handler) {
        return handler == null ? Optional.empty() : Optional.ofNullable(CUSTOM_ERROR_HANDLER_MAP.get(handler));
    }

    private CustomHandlerMapper() throws IllegalAccessException {
        throw new IllegalAccessException("Utility class cannot be instantiated");
    }

    static {
        CUSTOM_HANDLER_MAP.put(CustomHandler.IMPERSONATION, (connection, params) -> {
            try {
                CustomHandlers.impersonateAsUser(connection, params);
            }
            catch (AuthException e) {
                throw new RuntimeException(e);
            }
        });
        CUSTOM_ERROR_HANDLER_MAP.put(CustomHandler.IMPERSONATION, CustomHandlers::handleImpersonationAuthenticationError);
    }
}

