/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.internal.monitor;

import com.mulesoft.connectivity.datacloud.internal.monitor.AbstractHealthMonitor;
import com.mulesoft.connectivity.datacloud.internal.service.ConnectorExecutorService;
import com.mulesoft.connectivity.datacloud.internal.service.ServiceProvider;
import java.util.concurrent.ThreadPoolExecutor;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolHealthMonitor
extends AbstractHealthMonitor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThreadPoolHealthMonitor.class);
    private static final String HEALTH_CHECK_INTERVAL_PROPERTY = "com.mulesoft.connectivity.datacloud.threadpool.healthCheckIntervalSeconds";
    private static final double HIGH_UTILIZATION_THRESHOLD = 0.8;
    private static final double CRITICAL_UTILIZATION_THRESHOLD = 0.95;

    public ThreadPoolHealthMonitor(String connectorName) {
        super(connectorName, "ThreadPoolHealthMonitor");
    }

    @Override
    protected void doHealthCheck() {
        ConnectorExecutorService executorService = (ConnectorExecutorService)ServiceProvider.getThreadPoolService(this.connectorName).getExecutorService();
        ThreadPoolExecutor threadPoolExecutor = executorService.getThreadPoolExecutor();
        if (threadPoolExecutor == null) {
            log.debug("Executor service is not a ThreadPoolExecutor, skipping health check");
            return;
        }
        ThreadPoolMetrics metrics = new ThreadPoolMetrics(threadPoolExecutor);
        if (metrics.isCriticalUtilization()) {
            log.warn("CRITICAL: Thread pool at critical capacity - {}", (Object)metrics);
        } else if (metrics.isHighUtilization()) {
            log.warn("WARNING: Thread pool approaching capacity - {}", (Object)metrics);
        } else {
            log.debug("Thread pool metrics - {}", (Object)metrics);
        }
    }

    @Override
    protected String getHealthCheckIntervalProperty() {
        return HEALTH_CHECK_INTERVAL_PROPERTY;
    }

    @Override
    protected String getMonitorTypeName() {
        return "Thread Pool";
    }

    public static class ThreadPoolMetrics {
        private final int activeCount;
        private final int poolSize;
        private final int maximumPoolSize;
        private final int queueSize;
        private final int queueCapacity;
        private final long completedTaskCount;
        private final double threadUtilization;
        private final double queueUtilization;

        public ThreadPoolMetrics(ThreadPoolExecutor executor) {
            this.activeCount = executor.getActiveCount();
            this.poolSize = executor.getPoolSize();
            this.maximumPoolSize = executor.getMaximumPoolSize();
            this.queueSize = executor.getQueue().size();
            this.queueCapacity = executor.getQueue().remainingCapacity() + this.queueSize;
            this.completedTaskCount = executor.getCompletedTaskCount();
            this.threadUtilization = (double)this.activeCount / (double)this.maximumPoolSize;
            this.queueUtilization = this.queueCapacity > 0 ? (double)this.queueSize / (double)this.queueCapacity : 0.0;
        }

        public boolean isHighUtilization() {
            return this.threadUtilization > 0.8 || this.queueUtilization > 0.8;
        }

        public boolean isCriticalUtilization() {
            return this.threadUtilization > 0.95 || this.queueUtilization > 0.95;
        }

        public String toString() {
            return String.format("ThreadPoolMetrics{active=%d/%d, pool=%d, queue=%d/%d, threadUtil=%.1f%%, queueUtil=%.1f%%, completed=%d}", this.activeCount, this.maximumPoolSize, this.poolSize, this.queueSize, this.queueCapacity, this.threadUtilization * 100.0, this.queueUtilization * 100.0, this.completedTaskCount);
        }

        @Generated
        public int getActiveCount() {
            return this.activeCount;
        }

        @Generated
        public int getPoolSize() {
            return this.poolSize;
        }

        @Generated
        public int getMaximumPoolSize() {
            return this.maximumPoolSize;
        }

        @Generated
        public int getQueueSize() {
            return this.queueSize;
        }

        @Generated
        public int getQueueCapacity() {
            return this.queueCapacity;
        }

        @Generated
        public long getCompletedTaskCount() {
            return this.completedTaskCount;
        }

        @Generated
        public double getThreadUtilization() {
            return this.threadUtilization;
        }

        @Generated
        public double getQueueUtilization() {
            return this.queueUtilization;
        }
    }
}

