/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.internal.ratelimiter;

import com.mulesoft.connectivity.datacloud.api.model.RateLimitConfigurationModel;
import com.mulesoft.connectivity.datacloud.internal.service.ServiceProvider;
import com.mulesoft.connectivity.datacloud.internal.utils.HashingUtils;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RateLimiterUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RateLimiterUtils.class);
    public static final String OPERATION_NAME_PARAMETER_KEY = "operationName";

    private RateLimiterUtils() {
    }

    public static String buildRateLimiterKey(String connectorName, RateLimitConfigurationModel configuration, Map<String, Object> parameters) {
        String key = RateLimiterUtils.generateKey(configuration, parameters);
        return ServiceProvider.getCachingService(connectorName).getCachedValue(key, k -> k);
    }

    private static String generateKey(RateLimitConfigurationModel configuration, Map<String, Object> parameters) {
        Map additionalKeyValues;
        String id = configuration.getId();
        String operationName = Optional.ofNullable(parameters.get(OPERATION_NAME_PARAMETER_KEY)).map(Object::toString).orElse("");
        RateLimitConfigurationModel.IdProviderModel idProviderModel = configuration.getIdProviderModel();
        if (idProviderModel == null) {
            return operationName.isEmpty() ? id : id + ":" + operationName;
        }
        StringBuilder keyBuilder = new StringBuilder(id);
        List inputSelectors = idProviderModel.inputSelectors();
        if (inputSelectors != null && !inputSelectors.isEmpty()) {
            for (RateLimitConfigurationModel.InputSelector selector : inputSelectors) {
                Object parameterValue = RateLimiterUtils.findKeyInNestedMap(parameters, selector.key());
                if (parameterValue == null) {
                    log.warn("Missing parameter value for input selector: '{}'", (Object)selector.key());
                    continue;
                }
                String value2 = parameterValue.toString();
                if (selector.secured()) {
                    value2 = HashingUtils.secureStringHash(value2);
                }
                keyBuilder.append(":").append(selector.key()).append("_").append(value2);
            }
        }
        if ((additionalKeyValues = idProviderModel.additionalKeyValues()) != null && !additionalKeyValues.isEmpty()) {
            additionalKeyValues.forEach((key, value) -> keyBuilder.append(":").append((String)key).append("_").append((String)value));
        }
        if (!operationName.isEmpty()) {
            keyBuilder.append(":").append(operationName);
        }
        return keyBuilder.toString();
    }

    private static @Nullable Object findKeyInNestedMap(Map<String, Object> map, String targetKey) {
        if (map.containsKey(targetKey)) {
            return map.get(targetKey);
        }
        for (Object value : map.values()) {
            Map nestedMap;
            Object result;
            if (!(value instanceof Map) || (result = RateLimiterUtils.findKeyInNestedMap(nestedMap = (Map)value, targetKey)) == null) continue;
            return result;
        }
        return null;
    }
}

