/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.internal.service;

import com.mulesoft.connectivity.datacloud.internal.service.ConnectorExecutorService;
import com.mulesoft.connectivity.datacloud.internal.service.ThreadPoolService;
import com.mulesoft.connectivity.datacloud.internal.utils.HierarchicalPropertyResolver;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ConnectorThreadPoolService
implements ThreadPoolService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConnectorThreadPoolService.class);
    private static final String CORE_POOL_SIZE_PROPERTY = "com.mulesoft.connectivity.datacloud.threadpool.corePoolSize";
    private static final String MAXIMUM_POOL_SIZE_PROPERTY = "com.mulesoft.connectivity.datacloud.threadpool.maximumPoolSize";
    private static final String BLOCKING_QUEUE_SIZE_PROPERTY = "com.mulesoft.connectivity.datacloud.threadpool.blockingQueueSize";
    private static final String KEEP_ALIVE_SECONDS_PROPERTY = "com.mulesoft.connectivity.datacloud.threadpool.keepAliveSeconds";
    private static final int DEFAULT_CORE_POOL_SIZE = Runtime.getRuntime().availableProcessors() * 2;
    private static final int DEFAULT_MAXIMUM_POOL_SIZE = Runtime.getRuntime().availableProcessors() * 4;
    private static final int DEFAULT_BLOCKING_QUEUE_SIZE = 1000;
    private static final long DEFAULT_KEEP_ALIVE_SECONDS = 60L;
    private final ConnectorExecutorService cachedExecutorService;

    ConnectorThreadPoolService(String connectorName) {
        ThreadPoolExecutor tpExecutor = ConnectorThreadPoolService.createBoundedThreadPool(connectorName);
        log.info("DataCloud Connector '{}' initialized with thread pool - Core: {}, Max: {}, Queue: {}, KeepAlive: {}s", new Object[]{connectorName, tpExecutor.getCorePoolSize(), tpExecutor.getMaximumPoolSize(), tpExecutor.getQueue().remainingCapacity(), tpExecutor.getKeepAliveTime(TimeUnit.SECONDS)});
        this.cachedExecutorService = new ConnectorExecutorService(tpExecutor);
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.cachedExecutorService;
    }

    private static ThreadPoolExecutor createBoundedThreadPool(final String connectorName) {
        int coreThreads = ConnectorThreadPoolService.getConfiguredValue(CORE_POOL_SIZE_PROPERTY, DEFAULT_CORE_POOL_SIZE, connectorName);
        int maxThreads = ConnectorThreadPoolService.getConfiguredValue(MAXIMUM_POOL_SIZE_PROPERTY, DEFAULT_MAXIMUM_POOL_SIZE, connectorName);
        int queueSize = ConnectorThreadPoolService.getConfiguredValue(BLOCKING_QUEUE_SIZE_PROPERTY, 1000, connectorName);
        long keepAliveSeconds = ConnectorThreadPoolService.getConfiguredValue(KEEP_ALIVE_SECONDS_PROPERTY, 60L, connectorName);
        ConnectorThreadPoolService.validateConfiguration(coreThreads, maxThreads, queueSize);
        if (coreThreads <= 0 || maxThreads <= 0 || queueSize <= 0 || keepAliveSeconds <= 0L) {
            log.warn("Invalid thread pool configuration detected, using defaults");
            coreThreads = DEFAULT_CORE_POOL_SIZE;
            maxThreads = DEFAULT_MAXIMUM_POOL_SIZE;
            queueSize = 1000;
            keepAliveSeconds = 60L;
        }
        if (maxThreads < coreThreads) {
            log.warn("Max threads ({}) is less than core threads ({}), adjusting max threads", (Object)maxThreads, (Object)coreThreads);
            maxThreads = coreThreads;
        }
        ThreadFactory threadFactory = new ThreadFactory(){
            private final AtomicInteger threadNumber = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable, String.format("DataCloudConnector-%s-%s", connectorName, this.threadNumber.getAndIncrement()));
                thread.setDaemon(true);
                thread.setPriority(5);
                return thread;
            }
        };
        ThreadPoolExecutor executor = new ThreadPoolExecutor(coreThreads, maxThreads, keepAliveSeconds, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(queueSize), threadFactory, new ThreadPoolExecutor.CallerRunsPolicy());
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    private static <T extends Number> T getConfiguredValue(String propertyName, T defaultValue, String connectorName) {
        try {
            Number configuredValue;
            String value = HierarchicalPropertyResolver.getConfigValue(propertyName, connectorName);
            if (value != null && (configuredValue = defaultValue instanceof Integer ? (Number)Integer.parseInt(value) : (Number)Long.parseLong(value)).longValue() > 0L) {
                Number result = configuredValue;
                return (T)result;
            }
        }
        catch (NumberFormatException e) {
            log.warn("Invalid value for property {}, using default: {}", (Object)propertyName, defaultValue);
        }
        return defaultValue;
    }

    private static void validateConfiguration(int corePoolSize, int maximumPoolSize, int queueCapacity) {
        int availableProcessors;
        if (corePoolSize <= 0) {
            log.warn("Core pool size is {} - should be positive", (Object)corePoolSize);
        }
        if (maximumPoolSize <= 0) {
            log.warn("Maximum pool size is {} - should be positive", (Object)maximumPoolSize);
        }
        if (maximumPoolSize < corePoolSize) {
            log.warn("Maximum pool size ({}) is less than core pool size ({})", (Object)maximumPoolSize, (Object)corePoolSize);
        }
        if (queueCapacity <= 0) {
            log.warn("Queue capacity is {} - should be positive", (Object)queueCapacity);
        }
        if (maximumPoolSize > (availableProcessors = Runtime.getRuntime().availableProcessors()) * 10) {
            log.warn("Maximum pool size ({}) is very high compared to available processors ({}). Consider reducing to avoid excessive context switching.", (Object)maximumPoolSize, (Object)availableProcessors);
        }
        if (queueCapacity > 10000) {
            log.warn("Queue capacity ({}) is very high. Large queues can lead to memory issues and make it difficult to detect performance problems.", (Object)queueCapacity);
        }
        log.info("Thread pool configuration validated - Core: {}, Max: {}, Queue: {}, Processors: {}", new Object[]{corePoolSize, maximumPoolSize, queueCapacity, availableProcessors});
    }
}

