/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.internal.ratelimiter;

import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RateLimitHeaders {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RateLimitHeaders.class);
    private final @Nullable Long retryAfterSeconds;
    private final @Nullable Long rateLimitLimit;
    private final @Nullable Long rateLimitRemaining;
    private final @Nullable Long rateLimitReset;
    private final @Nullable String rateLimitPolicy;
    private static final Pattern RATE_LIMIT_PATTERN = Pattern.compile("(?:^|,)\\s*([a-z_]+)\\s*=\\s*(\\d+)(?:\\s*[,;]|$)");
    private static final Pattern RATE_LIMIT_POLICY_PATTERN = Pattern.compile("(\\d+)(?:;w=(\\d+))?");

    public static RateLimitHeaders from(Map<?, ?> errorResponse) {
        RateLimitHeadersBuilder builder = RateLimitHeaders.builder();
        Map<?, ?> headers = RateLimitHeaders.extractHeaders(errorResponse);
        if (headers == null) {
            return builder.build();
        }
        builder.retryAfterSeconds(RateLimitHeaders.parseRetryAfter(headers));
        boolean foundStandardHeaders = RateLimitHeaders.parseIetfHeaders(headers, builder);
        if (!foundStandardHeaders) {
            RateLimitHeaders.parseLegacyHeaders(headers, builder);
        }
        return builder.build();
    }

    public boolean hasRetryAfter() {
        return this.retryAfterSeconds != null && this.retryAfterSeconds > 0L;
    }

    public long getRetryDelayMillis() {
        return this.retryAfterSeconds != null ? this.retryAfterSeconds * 1000L : 0L;
    }

    public Optional<Instant> getResetTime() {
        if (this.rateLimitReset != null) {
            return Optional.of(Instant.now().plusSeconds(this.rateLimitReset));
        }
        return Optional.empty();
    }

    public boolean isNearLimit() {
        if (this.rateLimitLimit != null && this.rateLimitRemaining != null && this.rateLimitLimit > 0L) {
            return (double)this.rateLimitRemaining.longValue() < (double)this.rateLimitLimit.longValue() * 0.2;
        }
        return false;
    }

    public Optional<Double> getRemainingPercentage() {
        if (this.rateLimitLimit != null && this.rateLimitRemaining != null && this.rateLimitLimit > 0L) {
            return Optional.of((double)this.rateLimitRemaining.longValue() / (double)this.rateLimitLimit.longValue());
        }
        return Optional.empty();
    }

    public Optional<Long> getLimit() {
        return Optional.ofNullable(this.rateLimitLimit);
    }

    public Optional<Long> getRemaining() {
        return Optional.ofNullable(this.rateLimitRemaining);
    }

    public Optional<Long> getReset() {
        return Optional.ofNullable(this.rateLimitReset);
    }

    public Optional<String> getPolicy() {
        return Optional.ofNullable(this.rateLimitPolicy);
    }

    private static @Nullable Map<?, ?> extractHeaders(Map<?, ?> errorResponse) {
        Object headers = errorResponse.get("headers");
        if (headers instanceof Map) {
            Map headerMap = (Map)headers;
            return headerMap;
        }
        if (errorResponse.containsKey("RateLimit") || errorResponse.containsKey("RateLimit-Policy") || errorResponse.containsKey("Retry-After") || errorResponse.containsKey("retry-after")) {
            return errorResponse;
        }
        if (errorResponse.containsKey("X-RateLimit-Limit") || errorResponse.containsKey("x-rate-limit-limit") || errorResponse.containsKey("X-RateLimit-Remaining") || errorResponse.containsKey("x-rate-limit-remaining") || errorResponse.containsKey("X-RateLimit-Reset") || errorResponse.containsKey("x-rate-limit-reset")) {
            return errorResponse;
        }
        return null;
    }

    private static @Nullable Long parseRetryAfter(Map<?, ?> headers) {
        String[] retryAfterHeaders;
        for (String headerName : retryAfterHeaders = new String[]{"Retry-After", "retry-after"}) {
            Object value = headers.get(headerName);
            if (value == null) continue;
            try {
                if (value instanceof Number) {
                    Number number = (Number)value;
                    long seconds = number.longValue();
                    return seconds > 0L ? Long.valueOf(seconds) : null;
                }
                if (!(value instanceof String)) continue;
                String stringValue = (String)value;
                String trimmedValue = stringValue.trim();
                try {
                    long seconds = Long.parseLong(trimmedValue);
                    return seconds > 0L ? Long.valueOf(seconds) : null;
                }
                catch (NumberFormatException e) {
                    return RateLimitHeaders.parseHttpDate(trimmedValue);
                }
            }
            catch (Exception e) {
                log.debug("Failed to parse retry-after header: {}", value, (Object)e);
            }
        }
        return null;
    }

    private static @Nullable Long parseHttpDate(String dateString) {
        try {
            ZonedDateTime retryTime = ZonedDateTime.parse(dateString, DateTimeFormatter.RFC_1123_DATE_TIME);
            Instant now = Instant.now();
            Instant retryInstant = retryTime.toInstant();
            long delaySeconds = retryInstant.getEpochSecond() - now.getEpochSecond();
            return delaySeconds > 0L ? Long.valueOf(delaySeconds) : null;
        }
        catch (DateTimeParseException e) {
            log.debug("Failed to parse retry-after HTTP date: {}", (Object)dateString, (Object)e);
            return null;
        }
    }

    private static boolean parseIetfHeaders(Map<?, ?> headers, RateLimitHeadersBuilder builder) {
        String[] policyHeaders;
        String[] rateLimitHeaders;
        boolean foundAnyHeader = false;
        for (String headerName : rateLimitHeaders = new String[]{"RateLimit", "ratelimit"}) {
            Object value = headers.get(headerName);
            if (!(value instanceof String)) continue;
            String stringValue = (String)value;
            RateLimitHeaders.parseRateLimitValue(stringValue, builder);
            foundAnyHeader = true;
            break;
        }
        for (String headerName : policyHeaders = new String[]{"RateLimit-Policy", "ratelimit-policy"}) {
            Object value = headers.get(headerName);
            if (!(value instanceof String)) continue;
            String stringValue = (String)value;
            RateLimitHeaders.parseRateLimitPolicyValue(stringValue, builder);
            foundAnyHeader = true;
            break;
        }
        return foundAnyHeader;
    }

    private static void parseLegacyHeaders(Map<?, ?> headers, RateLimitHeadersBuilder builder) {
        log.debug("IETF standard headers not found, trying legacy headers for compatibility");
        String[] limitHeaders = new String[]{"X-RateLimit-Limit", "x-rate-limit-limit", "X-Rate-Limit-Limit", "x-ratelimit-limit", "RateLimit-Limit", "ratelimit-limit", "Rate-Limit-Limit"};
        String[] remainingHeaders = new String[]{"X-RateLimit-Remaining", "x-rate-limit-remaining", "X-Rate-Limit-Remaining", "x-ratelimit-remaining", "RateLimit-Remaining", "ratelimit-remaining", "Rate-Limit-Remaining"};
        String[] resetHeaders = new String[]{"X-RateLimit-Reset", "x-rate-limit-reset", "X-Rate-Limit-Reset", "x-ratelimit-reset", "RateLimit-Reset", "ratelimit-reset", "Rate-Limit-Reset"};
        RateLimitHeaders.parseFirstAvailableHeader(headers, limitHeaders, builder::rateLimitLimit);
        RateLimitHeaders.parseFirstAvailableHeader(headers, remainingHeaders, builder::rateLimitRemaining);
        RateLimitHeaders.parseFirstAvailableHeader(headers, resetHeaders, builder::rateLimitReset);
    }

    private static void parseFirstAvailableHeader(Map<?, ?> headers, String[] headerNames, Consumer<Long> setter) {
        for (String headerName : headerNames) {
            Object value = headers.get(headerName);
            if (value == null) continue;
            try {
                if (value instanceof Number) {
                    Number number = (Number)value;
                    setter.accept(number.longValue());
                    log.debug("Parsed legacy header {}: {}", (Object)headerName, (Object)number.longValue());
                    return;
                }
                if (!(value instanceof String)) continue;
                String stringValue = (String)value;
                Long parsedValue = Long.parseLong(stringValue.trim());
                setter.accept(parsedValue);
                log.debug("Parsed legacy header {}: {}", (Object)headerName, (Object)parsedValue);
                return;
            }
            catch (NumberFormatException e) {
                log.debug("Failed to parse legacy header {}: {}", new Object[]{headerName, value, e});
            }
        }
    }

    private static void parseRateLimitValue(String value, RateLimitHeadersBuilder builder) {
        try {
            Matcher matcher = RATE_LIMIT_PATTERN.matcher(value.trim());
            block12: while (matcher.find()) {
                String key = Objects.requireNonNull(matcher.group(1));
                String val = Objects.requireNonNull(matcher.group(2));
                switch (key) {
                    case "limit": {
                        builder.rateLimitLimit(Long.parseLong(val));
                        log.debug("Parsed IETF RateLimit limit: {}", (Object)val);
                        continue block12;
                    }
                    case "remaining": {
                        builder.rateLimitRemaining(Long.parseLong(val));
                        log.debug("Parsed IETF RateLimit remaining: {}", (Object)val);
                        continue block12;
                    }
                    case "reset": {
                        builder.rateLimitReset(Long.parseLong(val));
                        log.debug("Parsed IETF RateLimit reset: {}", (Object)val);
                        continue block12;
                    }
                }
                log.debug("Unknown RateLimit key: {}", (Object)key);
            }
        }
        catch (NumberFormatException e) {
            log.debug("Failed to parse RateLimit header: {}", (Object)value, (Object)e);
        }
    }

    private static void parseRateLimitPolicyValue(String value, RateLimitHeadersBuilder builder) {
        try {
            builder.rateLimitPolicy(value.trim());
            Matcher matcher = RATE_LIMIT_POLICY_PATTERN.matcher(value.trim());
            if (matcher.find()) {
                String quota = matcher.group(1);
                String window = matcher.group(2);
                log.debug("Parsed RateLimit-Policy: quota={}, window={}", (Object)quota, (Object)window);
            }
        }
        catch (NumberFormatException e) {
            log.debug("Failed to parse RateLimit-Policy header: {}", (Object)value, (Object)e);
        }
    }

    @Generated
    RateLimitHeaders(@Nullable Long retryAfterSeconds, @Nullable Long rateLimitLimit, @Nullable Long rateLimitRemaining, @Nullable Long rateLimitReset, @Nullable String rateLimitPolicy) {
        this.retryAfterSeconds = retryAfterSeconds;
        this.rateLimitLimit = rateLimitLimit;
        this.rateLimitRemaining = rateLimitRemaining;
        this.rateLimitReset = rateLimitReset;
        this.rateLimitPolicy = rateLimitPolicy;
    }

    @Generated
    public static RateLimitHeadersBuilder builder() {
        return new RateLimitHeadersBuilder();
    }

    @Generated
    public @Nullable Long getRetryAfterSeconds() {
        return this.retryAfterSeconds;
    }

    @Generated
    public @Nullable Long getRateLimitLimit() {
        return this.rateLimitLimit;
    }

    @Generated
    public @Nullable Long getRateLimitRemaining() {
        return this.rateLimitRemaining;
    }

    @Generated
    public @Nullable Long getRateLimitReset() {
        return this.rateLimitReset;
    }

    @Generated
    public @Nullable String getRateLimitPolicy() {
        return this.rateLimitPolicy;
    }

    @Generated
    public static class RateLimitHeadersBuilder {
        @Generated
        private Long retryAfterSeconds;
        @Generated
        private Long rateLimitLimit;
        @Generated
        private Long rateLimitRemaining;
        @Generated
        private Long rateLimitReset;
        @Generated
        private String rateLimitPolicy;

        @Generated
        RateLimitHeadersBuilder() {
        }

        @Generated
        public RateLimitHeadersBuilder retryAfterSeconds(@Nullable Long retryAfterSeconds) {
            this.retryAfterSeconds = retryAfterSeconds;
            return this;
        }

        @Generated
        public RateLimitHeadersBuilder rateLimitLimit(@Nullable Long rateLimitLimit) {
            this.rateLimitLimit = rateLimitLimit;
            return this;
        }

        @Generated
        public RateLimitHeadersBuilder rateLimitRemaining(@Nullable Long rateLimitRemaining) {
            this.rateLimitRemaining = rateLimitRemaining;
            return this;
        }

        @Generated
        public RateLimitHeadersBuilder rateLimitReset(@Nullable Long rateLimitReset) {
            this.rateLimitReset = rateLimitReset;
            return this;
        }

        @Generated
        public RateLimitHeadersBuilder rateLimitPolicy(@Nullable String rateLimitPolicy) {
            this.rateLimitPolicy = rateLimitPolicy;
            return this;
        }

        @Generated
        public RateLimitHeaders build() {
            return new RateLimitHeaders(this.retryAfterSeconds, this.rateLimitLimit, this.rateLimitRemaining, this.rateLimitReset, this.rateLimitPolicy);
        }

        @Generated
        public String toString() {
            return "RateLimitHeaders.RateLimitHeadersBuilder(retryAfterSeconds=" + this.retryAfterSeconds + ", rateLimitLimit=" + this.rateLimitLimit + ", rateLimitRemaining=" + this.rateLimitRemaining + ", rateLimitReset=" + this.rateLimitReset + ", rateLimitPolicy=" + this.rateLimitPolicy + ")";
        }
    }
}

