/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.internal.types;

import com.mulesoft.connectivity.linkweave.api.loader.WeaveTypeSimplifier;
import com.mulesoft.connectivity.linkweave.api.metadata.MetadataUtils;
import com.mulesoft.connectivity.linkweave.api.model.MetadataKey;
import com.salesforce.dataconnectors.api.model.metadata.Field;
import com.salesforce.dataconnectors.api.model.metadata.FieldDataType;
import com.salesforce.dataconnectors.api.service.ConnectorServicesProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.mule.weave.v2.api.tooling.ts.ArrayMetadataValue;
import org.mule.weave.v2.api.tooling.ts.ArrayType;
import org.mule.weave.v2.api.tooling.ts.BooleanType;
import org.mule.weave.v2.api.tooling.ts.DWMetadata;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.DWTypeVisitor;
import org.mule.weave.v2.api.tooling.ts.DateTimeType;
import org.mule.weave.v2.api.tooling.ts.KeyValuePairType;
import org.mule.weave.v2.api.tooling.ts.LiteralMetadataValue;
import org.mule.weave.v2.api.tooling.ts.LocalDateTimeType;
import org.mule.weave.v2.api.tooling.ts.LocalDateType;
import org.mule.weave.v2.api.tooling.ts.NullType;
import org.mule.weave.v2.api.tooling.ts.NumberType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;
import org.mule.weave.v2.api.tooling.ts.SimpleReferenceType;
import org.mule.weave.v2.api.tooling.ts.StringType;
import org.mule.weave.v2.api.tooling.ts.UnionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldTypeTransformer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FieldTypeTransformer.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(FieldTypeTransformer.class);

    private FieldTypeTransformer() {
    }

    private static List<?> getFields(KeyValuePairType objectFieldType, boolean returnIncrementalFields, boolean returnPrimaryKeyFields, Map<String, Object> config) {
        ArrayList<Field> flattenedFields = new ArrayList<Field>();
        HashMap<String, Field> fieldMap = new HashMap<String, Field>();
        ArrayList<String> incrementalFields = new ArrayList<String>();
        ArrayList<String> primaryKeyFields = new ArrayList<String>();
        objectFieldType.getValue().accept((DWTypeVisitor)new ObjectFieldTypeVisitor(flattenedFields, fieldMap, incrementalFields, objectFieldType.getKeyName(), primaryKeyFields, config));
        if (returnIncrementalFields) {
            return incrementalFields;
        }
        if (returnPrimaryKeyFields) {
            return primaryKeyFields;
        }
        return new ArrayList(fieldMap.values());
    }

    public static List<Field> transform(KeyValuePairType objectFieldType, Map<String, Object> config) {
        return FieldTypeTransformer.getFields(objectFieldType, false, false, config);
    }

    public static List<String> fetchIncrementalFields(KeyValuePairType objectFieldType, Map<String, Object> config) {
        return FieldTypeTransformer.getFields(objectFieldType, true, false, config);
    }

    public static List<String> fetchPrimaryKeyFields(KeyValuePairType objectFieldType, Map<String, Object> config) {
        return FieldTypeTransformer.getFields(objectFieldType, false, true, config);
    }

    private static class ObjectFieldTypeVisitor
    implements DWTypeVisitor {
        private static final String DATE_TIME = "date-time";
        private static final String DATE = "date";
        private static final String DATE_FORMAT = "yyyy-MM-dd";
        private static final String DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SZ";
        private static final List<String> DEFAULT_DATETIME_FORMATS = Arrays.asList("yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mm:ss.S", "yyyy-MM-dd'T'HH:mm:ss.SZ", "yyyy-MM-dd'T'HH:mm:ss.SS", "yyyy-MM-dd'T'HH:mm:ss.SS zzz", "yyyy-MM-dd'T'HH:mm:ss.SS ZZZZZ", "yyyy-MM-dd'T'HH:mm:ss.SSS", "yyyy-MM-dd'T'HH:mm:ss.SSSS", "yyyy-MM-dd'T'HH:mm:ss.SSSSS");
        private final List<Field> flattenedFields;
        private final Map<String, Field> fieldMap;
        private final List<String> incrementalFields;
        private final List<String> primaryKeyFields;
        private final String prefix;
        private final Boolean isNullable;
        private final Map<String, Object> config;
        private static final Map<Class<?>, Supplier<FieldDataType>> TRANSLATIONS = Map.ofEntries(Map.entry(BooleanType.class, () -> FieldDataType.BOOLEAN), Map.entry(NumberType.class, () -> FieldDataType.NUMBER), Map.entry(StringType.class, () -> FieldDataType.TEXT), Map.entry(DateTimeType.class, () -> FieldDataType.DATE), Map.entry(LocalDateTimeType.class, () -> FieldDataType.DATE), Map.entry(LocalDateType.class, () -> FieldDataType.DATE_ONLY), Map.entry(NullType.class, () -> FieldDataType.UNSUPPORTED), Map.entry(ObjectType.class, () -> FieldDataType.UNSUPPORTED), Map.entry(ArrayType.class, ObjectFieldTypeVisitor.arrayTypeSupplier()), Map.entry(UnionType.class, () -> FieldDataType.UNSUPPORTED));

        private static Supplier<FieldDataType> arrayTypeSupplier() {
            return () -> ConnectorServicesProvider.getGateService().isOpen("processArrayAsTextEnabled") ? FieldDataType.TEXT : FieldDataType.UNSUPPORTED;
        }

        public ObjectFieldTypeVisitor(List<Field> flattenedFields, Map<String, Field> fieldMap, List<String> incrementalFields, String prefix, List<String> primaryKeyFields, Map<String, Object> config) {
            this(flattenedFields, fieldMap, incrementalFields, primaryKeyFields, prefix, false, config);
        }

        public ObjectFieldTypeVisitor(List<Field> flattenedFields, Map<String, Field> fieldMap, List<String> incrementalFields, List<String> primaryKeyFields, String prefix, boolean isNullable, Map<String, Object> config) {
            this.flattenedFields = flattenedFields;
            this.fieldMap = fieldMap;
            this.incrementalFields = incrementalFields;
            this.primaryKeyFields = primaryKeyFields;
            this.prefix = prefix;
            this.isNullable = isNullable;
            this.config = config;
        }

        private FormatInfo getFormatInfoForDates(Map<String, Object> config, String nativeDataType, String format) {
            return new FormatInfo((String)((Map)config.get("dateFormats")).get(format), null, nativeDataType);
        }

        private static boolean isDateFormatPresentInConfig(Map<String, Object> config, String format) {
            return config != null && config.containsKey("dateFormats") ? ((Map)config.get("dateFormats")).get(format) != null : false;
        }

        private FormatInfo extractFormatInfo(DWType metadataType) {
            if (metadataType instanceof StringType) {
                StringType stringType = (StringType)metadataType;
                Optional formatAnnotation = MetadataUtils.getFormat((DWType)stringType);
                String nativeDataType = "String";
                if (formatAnnotation.isPresent()) {
                    String formatValue = (String)formatAnnotation.get();
                    FormatInfo formatInfo = null;
                    switch (formatValue) {
                        case "date-time": {
                            if (ObjectFieldTypeVisitor.isDateFormatPresentInConfig(this.config, DATE_TIME)) {
                                formatInfo = this.getFormatInfoForDates(this.config, nativeDataType, DATE_TIME);
                                break;
                            }
                            formatInfo = new FormatInfo(DATETIME_FORMAT, DEFAULT_DATETIME_FORMATS, nativeDataType);
                            break;
                        }
                        case "date": {
                            if (ObjectFieldTypeVisitor.isDateFormatPresentInConfig(this.config, DATE)) {
                                formatInfo = this.getFormatInfoForDates(this.config, nativeDataType, DATE);
                                break;
                            }
                            formatInfo = new FormatInfo(DATE_FORMAT, List.of(DATE_FORMAT), nativeDataType);
                            break;
                        }
                        default: {
                            formatInfo = new FormatInfo(null, null, nativeDataType);
                        }
                    }
                    return formatInfo;
                }
                return new FormatInfo(null, null, nativeDataType);
            }
            if (metadataType instanceof NumberType) {
                NumberType numberType = (NumberType)metadataType;
                String format = MetadataUtils.getFormat((DWType)numberType).orElse(null);
                return new FormatInfo(format, Arrays.asList("int32", "int64", "integer", "float", "double"), "Number");
            }
            if (metadataType instanceof BooleanType) {
                return new FormatInfo(null, null, "Boolean");
            }
            return new FormatInfo(null, null, null);
        }

        private static boolean isIncrementalSyncKey(DWType dwType) {
            if (dwType.getTypeMetadata(MetadataKey.SEMANTIC_TERMS.getKey()).isPresent()) {
                return Arrays.stream(((ArrayMetadataValue)((DWMetadata)dwType.getTypeMetadata(MetadataKey.SEMANTIC_TERMS.getKey()).get()).getValue()).getElements()).anyMatch(e -> ((LiteralMetadataValue)e).getValue().equals("incrementalSyncKey"));
            }
            return false;
        }

        private static boolean isPrimaryKey(DWType dwType) {
            if (dwType.getTypeMetadata(MetadataKey.SEMANTIC_TERMS.getKey()).isPresent()) {
                return Arrays.stream(((ArrayMetadataValue)((DWMetadata)dwType.getTypeMetadata(MetadataKey.SEMANTIC_TERMS.getKey()).get()).getValue()).getElements()).anyMatch(e -> ((LiteralMetadataValue)e).getValue().equals("primaryKey"));
            }
            if (dwType instanceof UnionType) {
                UnionType unionType = (UnionType)dwType;
                return Arrays.stream(unionType.unionOf()).anyMatch(ObjectFieldTypeVisitor::isPrimaryKey);
            }
            return false;
        }

        private static boolean isContentType(DWType dwType) {
            if (dwType.getTypeMetadata(MetadataKey.SEMANTIC_TERMS.getKey()).isPresent()) {
                return Arrays.stream(((ArrayMetadataValue)((DWMetadata)dwType.getTypeMetadata(MetadataKey.SEMANTIC_TERMS.getKey()).get()).getValue()).getElements()).anyMatch(e -> ((LiteralMetadataValue)e).getValue().equals("mimeType"));
            }
            if (dwType instanceof UnionType) {
                UnionType unionType = (UnionType)dwType;
                return Arrays.stream(unionType.unionOf()).anyMatch(ObjectFieldTypeVisitor::isContentType);
            }
            return false;
        }

        private static boolean isContentLastModifiedTime(DWType dwType) {
            if (dwType.getTypeMetadata(MetadataKey.SEMANTIC_TERMS.getKey()).isPresent()) {
                return Arrays.stream(((ArrayMetadataValue)((DWMetadata)dwType.getTypeMetadata(MetadataKey.SEMANTIC_TERMS.getKey()).get()).getValue()).getElements()).anyMatch(e -> ((LiteralMetadataValue)e).getValue().equals("lastModifiedTime"));
            }
            if (dwType instanceof UnionType) {
                UnionType unionType = (UnionType)dwType;
                return Arrays.stream(unionType.unionOf()).anyMatch(ObjectFieldTypeVisitor::isContentLastModifiedTime);
            }
            return false;
        }

        private static boolean isContentSize(DWType dwType) {
            if (dwType.getTypeMetadata(MetadataKey.SEMANTIC_TERMS.getKey()).isPresent()) {
                return Arrays.stream(((ArrayMetadataValue)((DWMetadata)dwType.getTypeMetadata(MetadataKey.SEMANTIC_TERMS.getKey()).get()).getValue()).getElements()).anyMatch(e -> ((LiteralMetadataValue)e).getValue().equals("size"));
            }
            if (dwType instanceof UnionType) {
                UnionType unionType = (UnionType)dwType;
                return Arrays.stream(unionType.unionOf()).anyMatch(ObjectFieldTypeVisitor::isContentSize);
            }
            return false;
        }

        private static boolean isContentFilename(DWType dwType) {
            if (dwType.getTypeMetadata(MetadataKey.SEMANTIC_TERMS.getKey()).isPresent()) {
                return Arrays.stream(((ArrayMetadataValue)((DWMetadata)dwType.getTypeMetadata(MetadataKey.SEMANTIC_TERMS.getKey()).get()).getValue()).getElements()).anyMatch(e -> ((LiteralMetadataValue)e).getValue().equals("filename"));
            }
            if (dwType instanceof UnionType) {
                UnionType unionType = (UnionType)dwType;
                return Arrays.stream(unionType.unionOf()).anyMatch(ObjectFieldTypeVisitor::isContentFilename);
            }
            return false;
        }

        public void visitObjectType(ObjectType objectType) {
            if (objectType.getProperties().length == 0) {
                this.addField(FieldProperties.builder().name(this.prefix).dataType(FieldDataType.UNSUPPORTED).isNullable(this.isNullable).semanticFlags((DWType)objectType).build());
            }
            String flattenSeparator = ".";
            if (ConnectorServicesProvider.getGateService().isOpen("flattenWithUnderscoresEnabled")) {
                flattenSeparator = "_";
            }
            for (KeyValuePairType field : objectType.getProperties()) {
                String fullFieldName = this.prefix + flattenSeparator + field.getKeyName();
                DWType fieldType = field.getValue();
                boolean nullable = this.isNullable(fieldType);
                FieldDataType dataType = ObjectFieldTypeVisitor.determineFieldType(fieldType);
                if (dataType != FieldDataType.UNSUPPORTED) {
                    this.addField(FieldProperties.builder().name(fullFieldName).dataType(dataType).isNullable(nullable).semanticFlags(field.getValue()).build());
                    continue;
                }
                fieldType.accept((DWTypeVisitor)new ObjectFieldTypeVisitor(this.flattenedFields, this.fieldMap, this.incrementalFields, fullFieldName, this.primaryKeyFields, this.config));
            }
        }

        public void visitArrayType(ArrayType arrayType) {
            DWType elementType = arrayType.arrayOf();
            String fieldName = this.prefix;
            boolean nullable = this.isNullable(elementType);
            FieldDataType dataType = ObjectFieldTypeVisitor.determineFieldType((DWType)arrayType);
            if (dataType != FieldDataType.UNSUPPORTED) {
                this.addField(FieldProperties.builder().name(fieldName).dataType(dataType).isNullable(nullable).semanticFlags((DWType)arrayType).build());
            } else {
                elementType.accept((DWTypeVisitor)new ObjectFieldTypeVisitor(this.flattenedFields, this.fieldMap, this.incrementalFields, fieldName, this.primaryKeyFields, this.config));
            }
        }

        public void visitNullType(NullType nullType) {
            this.addField(FieldProperties.builder().name(this.prefix).dataType(FieldDataType.UNSUPPORTED).isNullable(true).semanticFlags((DWType)nullType).build());
        }

        public void visitBooleanType(BooleanType booleanType) {
            FormatInfo formatInfo = this.extractFormatInfo((DWType)booleanType);
            this.addField(FieldProperties.builder().name(this.prefix).dataType(FieldDataType.BOOLEAN).formatInfo(formatInfo).semanticFlags((DWType)booleanType).build());
        }

        public void visitUnionType(UnionType unionType) {
            ObjectFieldUnionTypeVisitor unionTypeVisitor = new ObjectFieldUnionTypeVisitor();
            unionType.accept((DWTypeVisitor)unionTypeVisitor);
            Set<DWType> flattenedUnionTypes = unionTypeVisitor.getFlattenedUnionTypes();
            Set<DWType> complexUnionTypes = unionTypeVisitor.getComplexUnionTypes();
            boolean nullable = unionTypeVisitor.typeIsNullable();
            String unionFieldName = this.prefix;
            if (flattenedUnionTypes.isEmpty() && complexUnionTypes.isEmpty()) {
                this.addField(FieldProperties.builder().name(unionFieldName).dataType(FieldDataType.UNSUPPORTED).isNullable(nullable).semanticFlags((DWType)unionType).build());
            } else if (flattenedUnionTypes.size() + complexUnionTypes.size() > 1) {
                if (flattenedUnionTypes.size() > 1 && this.hasUniformDWType(flattenedUnionTypes)) {
                    Optional<DWType> firstNonNullType = flattenedUnionTypes.stream().filter(t -> !(t instanceof NullType)).findFirst();
                    firstNonNullType.ifPresentOrElse(type -> {
                        FieldDataType dataType = ObjectFieldTypeVisitor.determineFieldType(type);
                        FormatInfo formatInfo = this.extractFormatInfo((DWType)type);
                        this.addField(FieldProperties.builder().name(unionFieldName).dataType(dataType).isNullable(nullable).formatInfo(formatInfo).semanticFlags((DWType)unionType).build());
                    }, () -> this.addField(FieldProperties.builder().name(unionFieldName).dataType(FieldDataType.UNSUPPORTED).isNullable(nullable).semanticFlags((DWType)unionType).build()));
                } else {
                    this.addField(FieldProperties.builder().name(unionFieldName).dataType(FieldDataType.UNSUPPORTED).isNullable(nullable).semanticFlags((DWType)unionType).build());
                }
            } else if (complexUnionTypes.size() == 1) {
                DWType type2 = complexUnionTypes.iterator().next();
                type2.accept((DWTypeVisitor)new ObjectFieldTypeVisitor(this.flattenedFields, this.fieldMap, this.incrementalFields, this.primaryKeyFields, this.prefix, nullable, this.config));
            } else {
                DWType metadataType = flattenedUnionTypes.iterator().next();
                FieldDataType dataType = ObjectFieldTypeVisitor.determineFieldType(metadataType);
                FormatInfo formatInfo = this.extractFormatInfo(metadataType);
                this.addField(FieldProperties.builder().name(unionFieldName).dataType(dataType).isNullable(nullable).formatInfo(formatInfo).semanticFlags((DWType)unionType).build());
            }
        }

        private boolean hasUniformDWType(Set<DWType> unionTypes) {
            List<DWType> nonNullTypes = unionTypes.stream().filter(type -> !(type instanceof NullType)).toList();
            if (nonNullTypes.isEmpty()) {
                return false;
            }
            return nonNullTypes.stream().map(Object::getClass).distinct().count() == 1L;
        }

        public void visitNumberType(NumberType numberType) {
            FormatInfo formatInfo = this.extractFormatInfo((DWType)numberType);
            this.addField(FieldProperties.builder().name(this.prefix).dataType(FieldDataType.NUMBER).formatInfo(formatInfo).isIncrementalSyncKey(ObjectFieldTypeVisitor.isIncrementalSyncKey((DWType)numberType)).isPrimaryKey(ObjectFieldTypeVisitor.isPrimaryKey((DWType)numberType)).isContentLastModifiedTime(ObjectFieldTypeVisitor.isContentLastModifiedTime((DWType)numberType)).isContentSize(ObjectFieldTypeVisitor.isContentSize((DWType)numberType)).build());
        }

        public void visitStringType(StringType stringType) {
            FieldDataType dataType = ObjectFieldTypeVisitor.determineFieldType((DWType)stringType);
            FormatInfo formatInfo = this.extractFormatInfo((DWType)stringType);
            this.addField(FieldProperties.builder().name(this.prefix).dataType(dataType).formatInfo(formatInfo).semanticFlags((DWType)stringType).build());
        }

        public void visitDateTimeType(DateTimeType dateTimeType) {
            this.addField(FieldProperties.builder().name(this.prefix).dataType(FieldDataType.DATE).isIncrementalSyncKey(ObjectFieldTypeVisitor.isIncrementalSyncKey((DWType)dateTimeType)).isPrimaryKey(ObjectFieldTypeVisitor.isPrimaryKey((DWType)dateTimeType)).isContentLastModifiedTime(ObjectFieldTypeVisitor.isContentLastModifiedTime((DWType)dateTimeType)).build());
        }

        public void visitLocalDateType(LocalDateType dateType) {
            this.addField(FieldProperties.builder().name(this.prefix).dataType(FieldDataType.DATE_ONLY).isIncrementalSyncKey(ObjectFieldTypeVisitor.isIncrementalSyncKey((DWType)dateType)).isPrimaryKey(ObjectFieldTypeVisitor.isPrimaryKey((DWType)dateType)).isContentLastModifiedTime(ObjectFieldTypeVisitor.isContentLastModifiedTime((DWType)dateType)).build());
        }

        public void visitLocalDateTimeType(LocalDateTimeType localDateTimeType) {
            this.addField(FieldProperties.builder().name(this.prefix).dataType(FieldDataType.DATE).isIncrementalSyncKey(ObjectFieldTypeVisitor.isIncrementalSyncKey((DWType)localDateTimeType)).isPrimaryKey(ObjectFieldTypeVisitor.isPrimaryKey((DWType)localDateTimeType)).isContentLastModifiedTime(ObjectFieldTypeVisitor.isContentLastModifiedTime((DWType)localDateTimeType)).build());
        }

        public void visitSimpleReferenceType(SimpleReferenceType simpleReferenceType) {
            WeaveTypeSimplifier.simplifyWeaveType((DWType)simpleReferenceType).accept((DWTypeVisitor)new ObjectFieldTypeVisitor(this.flattenedFields, this.fieldMap, this.incrementalFields, this.primaryKeyFields, this.prefix, this.isNullable, this.config));
        }

        private void addField(FieldProperties properties) {
            if (properties.isIncrementalSyncKey) {
                this.incrementalFields.add(properties.name);
            }
            if (properties.isPrimaryKey) {
                this.primaryKeyFields.add(properties.name);
            }
            Field.FieldBuilder fieldBuilder = Field.builder().name(properties.name).isNullable(Boolean.valueOf(properties.isNullable)).mappedDataType(properties.dataType).format(properties.format).availableFormats(properties.availableFormats).nativeDataType(properties.nativeDataType).isContentType(Boolean.valueOf(properties.isContentType)).isContentSize(Boolean.valueOf(properties.isContentSize)).isContentLastModifiedTime(Boolean.valueOf(properties.isContentLastModifiedTime)).isContentFilename(Boolean.valueOf(properties.isContentFilename));
            this.fieldMap.put(properties.name, fieldBuilder.build());
        }

        public static FieldDataType determineFieldType(DWType metadataType) {
            StringType stringType;
            Optional formatAnnotation;
            if (metadataType instanceof StringType && (formatAnnotation = MetadataUtils.getFormat((DWType)(stringType = (StringType)metadataType))).isPresent()) {
                String formatValue;
                return switch (formatValue = (String)formatAnnotation.get()) {
                    case DATE_TIME -> FieldDataType.DATE;
                    case DATE -> FieldDataType.DATE_ONLY;
                    default -> FieldDataType.TEXT;
                };
            }
            return TRANSLATIONS.entrySet().stream().filter(entry -> ((Class)entry.getKey()).isInstance(metadataType)).map(Map.Entry::getValue).findFirst().orElse(() -> FieldDataType.UNSUPPORTED).get();
        }

        private boolean isNullable(DWType metadataType) {
            if (metadataType instanceof UnionType) {
                for (DWMetadata type : metadataType.getTypeMetadata()) {
                    if (!(type instanceof NullType)) continue;
                    return true;
                }
            }
            return metadataType instanceof NullType;
        }

        private record FormatInfo(@Nullable String format, @Nullable List<String> availableFormats, @Nullable String nativeDataType) {
        }

        private static class FieldProperties {
            private final String name;
            private final boolean isNullable;
            private final FieldDataType dataType;
            private final @Nullable String format;
            private final @Nullable List<String> availableFormats;
            private final @Nullable String nativeDataType;
            private final boolean isIncrementalSyncKey;
            private final boolean isPrimaryKey;
            private final boolean isContentType;
            private final boolean isContentLastModifiedTime;
            private final boolean isContentSize;
            private final boolean isContentFilename;

            @Generated
            public static FieldPropertiesBuilder builder() {
                return new FieldPropertiesBuilder();
            }

            @Generated
            private FieldProperties(String name, boolean isNullable, FieldDataType dataType, @Nullable String format, @Nullable List<String> availableFormats, @Nullable String nativeDataType, boolean isIncrementalSyncKey, boolean isPrimaryKey, boolean isContentType, boolean isContentLastModifiedTime, boolean isContentSize, boolean isContentFilename) {
                this.name = name;
                this.isNullable = isNullable;
                this.dataType = dataType;
                this.format = format;
                this.availableFormats = availableFormats;
                this.nativeDataType = nativeDataType;
                this.isIncrementalSyncKey = isIncrementalSyncKey;
                this.isPrimaryKey = isPrimaryKey;
                this.isContentType = isContentType;
                this.isContentLastModifiedTime = isContentLastModifiedTime;
                this.isContentSize = isContentSize;
                this.isContentFilename = isContentFilename;
            }

            public static class FieldPropertiesBuilder {
                @Generated
                private String name;
                @Generated
                private boolean isNullable;
                @Generated
                private FieldDataType dataType;
                @Generated
                private String format;
                @Generated
                private List<String> availableFormats;
                @Generated
                private String nativeDataType;
                @Generated
                private boolean isIncrementalSyncKey;
                @Generated
                private boolean isPrimaryKey;
                @Generated
                private boolean isContentType;
                @Generated
                private boolean isContentLastModifiedTime;
                @Generated
                private boolean isContentSize;
                @Generated
                private boolean isContentFilename;

                public FieldPropertiesBuilder formatInfo(FormatInfo formatInfo) {
                    return this.format(formatInfo.format).availableFormats(formatInfo.availableFormats).nativeDataType(formatInfo.nativeDataType);
                }

                public FieldPropertiesBuilder semanticFlags(DWType dwType) {
                    return this.isIncrementalSyncKey(ObjectFieldTypeVisitor.isIncrementalSyncKey(dwType)).isPrimaryKey(ObjectFieldTypeVisitor.isPrimaryKey(dwType)).isContentType(ObjectFieldTypeVisitor.isContentType(dwType)).isContentLastModifiedTime(ObjectFieldTypeVisitor.isContentLastModifiedTime(dwType)).isContentSize(ObjectFieldTypeVisitor.isContentSize(dwType)).isContentFilename(ObjectFieldTypeVisitor.isContentFilename(dwType));
                }

                @Generated
                FieldPropertiesBuilder() {
                }

                @Generated
                public FieldPropertiesBuilder name(String name) {
                    this.name = name;
                    return this;
                }

                @Generated
                public FieldPropertiesBuilder isNullable(boolean isNullable) {
                    this.isNullable = isNullable;
                    return this;
                }

                @Generated
                public FieldPropertiesBuilder dataType(FieldDataType dataType) {
                    this.dataType = dataType;
                    return this;
                }

                @Generated
                public FieldPropertiesBuilder format(@Nullable String format) {
                    this.format = format;
                    return this;
                }

                @Generated
                public FieldPropertiesBuilder availableFormats(@Nullable List<String> availableFormats) {
                    this.availableFormats = availableFormats;
                    return this;
                }

                @Generated
                public FieldPropertiesBuilder nativeDataType(@Nullable String nativeDataType) {
                    this.nativeDataType = nativeDataType;
                    return this;
                }

                @Generated
                public FieldPropertiesBuilder isIncrementalSyncKey(boolean isIncrementalSyncKey) {
                    this.isIncrementalSyncKey = isIncrementalSyncKey;
                    return this;
                }

                @Generated
                public FieldPropertiesBuilder isPrimaryKey(boolean isPrimaryKey) {
                    this.isPrimaryKey = isPrimaryKey;
                    return this;
                }

                @Generated
                public FieldPropertiesBuilder isContentType(boolean isContentType) {
                    this.isContentType = isContentType;
                    return this;
                }

                @Generated
                public FieldPropertiesBuilder isContentLastModifiedTime(boolean isContentLastModifiedTime) {
                    this.isContentLastModifiedTime = isContentLastModifiedTime;
                    return this;
                }

                @Generated
                public FieldPropertiesBuilder isContentSize(boolean isContentSize) {
                    this.isContentSize = isContentSize;
                    return this;
                }

                @Generated
                public FieldPropertiesBuilder isContentFilename(boolean isContentFilename) {
                    this.isContentFilename = isContentFilename;
                    return this;
                }

                @Generated
                public FieldProperties build() {
                    return new FieldProperties(this.name, this.isNullable, this.dataType, this.format, this.availableFormats, this.nativeDataType, this.isIncrementalSyncKey, this.isPrimaryKey, this.isContentType, this.isContentLastModifiedTime, this.isContentSize, this.isContentFilename);
                }

                @Generated
                public String toString() {
                    return "FieldTypeTransformer.ObjectFieldTypeVisitor.FieldProperties.FieldPropertiesBuilder(name=" + this.name + ", isNullable=" + this.isNullable + ", dataType=" + String.valueOf(this.dataType) + ", format=" + this.format + ", availableFormats=" + String.valueOf(this.availableFormats) + ", nativeDataType=" + this.nativeDataType + ", isIncrementalSyncKey=" + this.isIncrementalSyncKey + ", isPrimaryKey=" + this.isPrimaryKey + ", isContentType=" + this.isContentType + ", isContentLastModifiedTime=" + this.isContentLastModifiedTime + ", isContentSize=" + this.isContentSize + ", isContentFilename=" + this.isContentFilename + ")";
                }
            }
        }

        private static class ObjectFieldUnionTypeVisitor
        implements DWTypeVisitor {
            private static final int DEFAULT_MAX_NESTED_UNION_LEVEL = 100;
            private static final int MAX_NESTED_UNION_LEVEL = Integer.parseInt(System.getProperty("max.introspection.level.number", String.valueOf(100)));
            private int unionLevel = 0;
            private boolean isNullable = false;
            private final Set<DWType> unionTypes = new HashSet<DWType>();
            private final Set<DWType> complexUnionTypes = new HashSet<DWType>();

            public void visitSimpleReferenceType(SimpleReferenceType simpleReferenceType) {
                WeaveTypeSimplifier.simplifyWeaveType((DWType)simpleReferenceType).accept((DWTypeVisitor)this);
            }

            public void visitUnionType(UnionType unionType) {
                DWType[] types;
                if (this.unionLevel == MAX_NESTED_UNION_LEVEL) {
                    LOGGER.warn("Reached max nested level of union types ({}), inference of field type was cut off.{}Set 'max.introspection.level.number' property to extend it.", (Object)MAX_NESTED_UNION_LEVEL, (Object)System.lineSeparator());
                    this.unionLevel = 0;
                    return;
                }
                ++this.unionLevel;
                for (DWType type : types = unionType.unionOf()) {
                    type.accept((DWTypeVisitor)this);
                }
                --this.unionLevel;
            }

            public void visitBooleanType(BooleanType booleanType) {
                this.unionTypes.add((DWType)booleanType);
            }

            public void visitObjectType(ObjectType objectType) {
                this.complexUnionTypes.add((DWType)objectType);
            }

            public void visitNullType(NullType nullType) {
                this.isNullable = true;
            }

            public void visitNumberType(NumberType numberType) {
                this.unionTypes.add((DWType)numberType);
            }

            public void visitStringType(StringType stringType) {
                this.unionTypes.add((DWType)stringType);
            }

            public Boolean typeIsNullable() {
                return this.isNullable;
            }

            public Set<DWType> getFlattenedUnionTypes() {
                return this.unionTypes;
            }

            public Set<DWType> getComplexUnionTypes() {
                return this.complexUnionTypes;
            }
        }
    }
}

