/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.internal.retry;

import com.mulesoft.connectivity.datacloud.internal.retry.RetryStrategy;
import com.mulesoft.connectivity.datacloud.internal.retry.adjustment.ParameterAdjuster;
import com.mulesoft.connectivity.datacloud.internal.retry.adjustment.TokenRefreshAdjuster;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationResult;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationRetryStrategy
implements RetryStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthenticationRetryStrategy.class);
    private static final ParameterAdjuster PARAMETER_ADJUSTER = new TokenRefreshAdjuster();
    private final int maxAttempts;
    private final long retryDelayMillis;

    public AuthenticationRetryStrategy() {
        this(1, 0L);
    }

    public AuthenticationRetryStrategy(int maxAttempts, long retryDelayMillis) {
        this.maxAttempts = maxAttempts;
        this.retryDelayMillis = retryDelayMillis;
    }

    @Override
    public boolean shouldRetry(OperationResult<?> result, int attemptNumber) {
        if (result.isSuccess()) {
            return false;
        }
        if (attemptNumber > this.maxAttempts) {
            log.debug("Maximum attempts ({}) reached for strategy {}", (Object)this.maxAttempts, (Object)this.getClass().getSimpleName());
            return false;
        }
        Set categories = result.getErrorValue().getCategories();
        return categories.containsAll(Set.of("AUTHENTICATION", "RECONNECT"));
    }

    @Override
    public long getDelayMillis(OperationResult<?> result, int attemptNumber) {
        return this.retryDelayMillis;
    }

    @Override
    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    @Override
    public Optional<ParameterAdjuster> getParameterAdjuster() {
        return Optional.of(PARAMETER_ADJUSTER);
    }
}

