/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.internal.retry;

import com.mulesoft.connectivity.datacloud.internal.retry.RetryStrategy;
import com.mulesoft.connectivity.datacloud.internal.retry.jitter.JitterStrategy;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationResult;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExponentialBackoffRetryStrategy
implements RetryStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExponentialBackoffRetryStrategy.class);
    protected final Set<String> retryableCategories;
    protected final int maxAttempts;
    protected final long baseDelayMillis;
    protected final long maxDelayMillis;
    protected final @Nullable JitterStrategy jitterStrategy;

    ExponentialBackoffRetryStrategy(Set<String> retryableCategories, int maxAttempts, long baseDelayMillis, long maxDelayMillis, @Nullable JitterStrategy jitterStrategy) {
        this.retryableCategories = retryableCategories;
        if (retryableCategories.isEmpty()) {
            throw new IllegalArgumentException("retryableCategories cannot be empty");
        }
        if (maxAttempts <= 0) {
            throw new IllegalArgumentException("maxAttempts must be positive");
        }
        if (baseDelayMillis < 0L) {
            throw new IllegalArgumentException("baseDelayMillis cannot be negative");
        }
        if (maxDelayMillis < baseDelayMillis) {
            throw new IllegalArgumentException("maxDelayMillis cannot be less than baseDelayMillis");
        }
        this.maxAttempts = maxAttempts;
        this.baseDelayMillis = baseDelayMillis;
        this.maxDelayMillis = maxDelayMillis;
        this.jitterStrategy = jitterStrategy;
    }

    @Override
    public boolean shouldRetry(OperationResult<?> result, int attemptNumber) {
        if (result.isSuccess()) {
            return false;
        }
        if (attemptNumber > this.maxAttempts) {
            log.debug("Maximum attempts ({}) reached for strategy {}", (Object)this.maxAttempts, (Object)this.getClass().getSimpleName());
            return false;
        }
        Set categories = result.getErrorValue().getCategories();
        return categories.containsAll(this.retryableCategories);
    }

    @Override
    public long getDelayMillis(OperationResult<?> result, int attemptNumber) {
        long baseDelay = this.getBaseDelay(attemptNumber);
        if (this.jitterStrategy != null) {
            baseDelay = this.jitterStrategy.getDelayMillis(baseDelay);
        }
        log.debug("Using exponential backoff delay: {} ms (attempt {})", (Object)baseDelay, (Object)attemptNumber);
        return Math.max(baseDelay, 0L);
    }

    @Override
    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    protected long getBaseDelay(int attemptNumber) {
        long exponentialDelay = this.baseDelayMillis * (1L << attemptNumber - 1);
        return Math.min(exponentialDelay, this.maxDelayMillis);
    }
}

