/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.internal.utils;

import com.salesforce.dataconnectors.api.context.ContextHelper;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HierarchicalPropertyResolver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HierarchicalPropertyResolver.class);
    private static final String BASE_PROPERTY_PREFIX = "com.mulesoft.connectivity.datacloud";

    private HierarchicalPropertyResolver() {
    }

    public static @Nullable String getConfigValue(String propertyName, String connectorName) {
        String genericValue;
        if (propertyName.startsWith(BASE_PROPERTY_PREFIX)) {
            String connectorSpecificProperty = HierarchicalPropertyResolver.buildConnectorSpecificPropertyName(propertyName, connectorName);
            String connectorSpecificValue = HierarchicalPropertyResolver.getDirectConfigValue(connectorSpecificProperty);
            if (connectorSpecificValue != null) {
                log.debug("Found connector-specific property value for {}: {}", (Object)connectorSpecificProperty, (Object)connectorSpecificValue);
                return connectorSpecificValue;
            }
            log.debug("Connector-specific property {} not found, falling back to generic property {}", (Object)connectorSpecificProperty, (Object)propertyName);
        }
        if ((genericValue = HierarchicalPropertyResolver.getDirectConfigValue(propertyName)) != null) {
            log.debug("Found generic property value for {}: {}", (Object)propertyName, (Object)genericValue);
        } else {
            log.debug("Property {} not found", (Object)propertyName);
        }
        return genericValue;
    }

    public static @Nullable String getDirectConfigValue(String propertyName) {
        try {
            return ContextHelper.getDCFContext().getConfigValue(propertyName);
        }
        catch (Exception e) {
            log.warn("Error retrieving property {}: {}", (Object)propertyName, (Object)e.getMessage());
            return null;
        }
    }

    private static String buildConnectorSpecificPropertyName(String basePropertyName, String connectorName) {
        if (!basePropertyName.startsWith(BASE_PROPERTY_PREFIX)) {
            return basePropertyName;
        }
        String afterPrefix = basePropertyName.substring(BASE_PROPERTY_PREFIX.length());
        if (afterPrefix.isEmpty()) {
            return "com.mulesoft.connectivity.datacloud." + connectorName;
        }
        if (afterPrefix.startsWith(".")) {
            return "com.mulesoft.connectivity.datacloud." + connectorName + afterPrefix;
        }
        return "com.mulesoft.connectivity.datacloud." + connectorName + "." + afterPrefix;
    }
}

