/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.internal.config;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import com.salesforce.dataconnectors.api.service.ConnectorServicesProvider;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoggingConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoggingConfiguration.class);
    public static final String DATA_CLOUD_LOGGER = "com.mulesoft.connectivity.datacloud";
    public static final String DATA_WEAVE_LOGGER = "org.mule.weave.v2.model.service.DefaultLoggingService";
    private static volatile boolean lastVerboseLoggingState = false;
    private static volatile boolean initialized = false;

    private LoggingConfiguration() {
    }

    public static synchronized void initialize() {
        if (initialized) {
            log.debug("Logging configuration already initialized, skipping");
            return;
        }
        try {
            LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
            ch.qos.logback.classic.Logger dataCloudLogger = loggerContext.getLogger(DATA_CLOUD_LOGGER);
            dataCloudLogger.setLevel(Level.INFO);
            ch.qos.logback.classic.Logger weaveLogger = loggerContext.getLogger(DATA_WEAVE_LOGGER);
            weaveLogger.setLevel(Level.INFO);
            initialized = true;
            log.info("Feature gate-based logging configuration initialized for loggers: {}, {}", (Object)DATA_CLOUD_LOGGER, (Object)DATA_WEAVE_LOGGER);
        }
        catch (Exception e) {
            log.warn("Failed to initialize feature gate-based logging configuration. Debug logging will follow default logger configuration.", (Throwable)e);
        }
    }

    public static synchronized void checkAndRefresh() {
        if (!initialized) {
            LoggingConfiguration.initialize();
        }
        try {
            boolean currentVerboseLoggingState = ConnectorServicesProvider.getGateService().isOpen("verboseLoggingEnabled");
            if (currentVerboseLoggingState != lastVerboseLoggingState) {
                lastVerboseLoggingState = currentVerboseLoggingState;
                log.info("Verbose logging hot-swapped to: {}", (Object)(currentVerboseLoggingState ? "ENABLED" : "DISABLED"));
                LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
                ch.qos.logback.classic.Logger dataCloudLogger = loggerContext.getLogger(DATA_CLOUD_LOGGER);
                dataCloudLogger.setLevel(lastVerboseLoggingState ? Level.TRACE : Level.INFO);
                ch.qos.logback.classic.Logger weaveLogger = loggerContext.getLogger(DATA_WEAVE_LOGGER);
                weaveLogger.setLevel(lastVerboseLoggingState ? Level.TRACE : Level.INFO);
            }
        }
        catch (Exception e) {
            log.error("Failed to check debug logging state during hot-swap check", (Throwable)e);
        }
    }
}

