/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.internal.config;

import com.mulesoft.connectivity.datacloud.internal.monitor.CacheHealthMonitor;
import com.mulesoft.connectivity.datacloud.internal.monitor.ThreadPoolHealthMonitor;
import com.salesforce.dataconnectors.api.service.ConnectorServicesProvider;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitoringConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MonitoringConfiguration.class);
    private static final AtomicReference<@Nullable ThreadPoolHealthMonitor> THREAD_POOL_HEALTH_MONITOR_REFERENCE = new AtomicReference();
    private static final AtomicReference<@Nullable CacheHealthMonitor> CACHE_HEALTH_MONITOR_REFERENCE = new AtomicReference();

    private MonitoringConfiguration() {
    }

    public static void checkAndRefresh(String connectorName) {
        MonitoringConfiguration.checkThreadPoolMonitoring(connectorName);
        MonitoringConfiguration.checkCacheMonitoring(connectorName);
    }

    private static void checkThreadPoolMonitoring(String connectorName) {
        if (ConnectorServicesProvider.getGateService().isOpen("threadPoolMonitoringEnabled")) {
            ThreadPoolHealthMonitor monitor = THREAD_POOL_HEALTH_MONITOR_REFERENCE.updateAndGet(current -> current != null ? current : new ThreadPoolHealthMonitor(connectorName));
            if (monitor != null && !monitor.isMonitoring()) {
                monitor.startMonitoring();
            }
        } else {
            ThreadPoolHealthMonitor monitor = THREAD_POOL_HEALTH_MONITOR_REFERENCE.get();
            if (monitor != null && monitor.isMonitoring()) {
                monitor.stopMonitoring();
            }
        }
    }

    private static void checkCacheMonitoring(String connectorName) {
        if (ConnectorServicesProvider.getGateService().isOpen("cacheMonitoringEnabled")) {
            CacheHealthMonitor monitor = CACHE_HEALTH_MONITOR_REFERENCE.updateAndGet(current -> current != null ? current : new CacheHealthMonitor(connectorName));
            if (monitor != null && !monitor.isMonitoring()) {
                monitor.startMonitoring();
            }
        } else {
            CacheHealthMonitor monitor = CACHE_HEALTH_MONITOR_REFERENCE.get();
            if (monitor != null && monitor.isMonitoring()) {
                monitor.stopMonitoring();
            }
        }
    }
}

