/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.internal.operation;

import com.mulesoft.connectivity.datacloud.internal.operation.ExecutionParameters;
import com.mulesoft.connectivity.linkweave.api.interpreter.ModelInterpreter;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationResult;
import com.mulesoft.connectivity.linkweave.api.model.trigger.NextData;
import java.util.Objects;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionFunctionBuilder<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExecutionFunctionBuilder.class);
    private final ModelInterpreter modelInterpreter;

    private ExecutionFunctionBuilder(ModelInterpreter modelInterpreter) {
        this.modelInterpreter = modelInterpreter;
    }

    public static <T> ExecutionFunctionBuilder<T> builder(ModelInterpreter modelInterpreter) {
        return new ExecutionFunctionBuilder<T>(modelInterpreter);
    }

    public Function<ExecutionParameters, OperationResult<T>> build(FunctionName functionName) {
        return switch (functionName) {
            default -> throw new IncompatibleClassChangeError();
            case FunctionName.OPERATION -> this.buildOperationFunction();
            case FunctionName.OPERATION_NEXT_PAGE -> this.buildNextPageFunction();
            case FunctionName.TRIGGER -> this.buildTriggerFunction();
            case FunctionName.TRIGGER_NEXT_PAGE -> this.buildTriggerNextPageFunction();
        };
    }

    private Function<ExecutionParameters, OperationResult<T>> buildOperationFunction() {
        return parameters -> this.modelInterpreter.executeOperation(parameters.getConnection(), parameters.getExecutableModel(), parameters.getParameters());
    }

    private Function<ExecutionParameters, OperationResult<T>> buildNextPageFunction() {
        return parameters -> this.modelInterpreter.executeOperationNextPage(parameters.getConnection(), parameters.getExecutableModel(), parameters.getParameters());
    }

    private Function<ExecutionParameters, OperationResult<T>> buildTriggerFunction() {
        return parameters -> this.modelInterpreter.executeTrigger(parameters.getConnection(), parameters.getExecutableModel(), Objects.requireNonNull(parameters.getInitialWatermark(), "Initial watermark cannot be null"), parameters.getParameters());
    }

    private Function<ExecutionParameters, OperationResult<T>> buildTriggerNextPageFunction() {
        return parameters -> this.modelInterpreter.executeTriggerNextPage(parameters.getConnection(), parameters.getExecutableModel(), (NextData)parameters.getParameters());
    }

    public static enum FunctionName {
        OPERATION("operation"),
        OPERATION_NEXT_PAGE("nextPage"),
        TRIGGER("trigger"),
        TRIGGER_NEXT_PAGE("triggerNextPage");

        private final String name;

        private FunctionName(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

