/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.internal.utils;

import com.mulesoft.connectivity.datacloud.internal.auth.AuthException;
import com.mulesoft.connectivity.datacloud.internal.auth.AuthProvider;
import com.mulesoft.connectivity.datacloud.internal.auth.AuthProviderFactory;
import com.mulesoft.connectivity.datacloud.internal.config.TokenManagerConfig;
import com.mulesoft.connectivity.datacloud.internal.context.ExecutionContext;
import com.mulesoft.connectivity.datacloud.internal.service.CachingService;
import com.mulesoft.connectivity.datacloud.internal.service.ServiceProvider;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImpersonationTokenManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImpersonationTokenManager.class);
    private static final Map<String, ImpersonationTokenManager> INSTANCES = new ConcurrentHashMap<String, ImpersonationTokenManager>();
    private final CachingService tokenCache;
    private final Map<String, ReentrantLock> userLocks = new ConcurrentHashMap<String, ReentrantLock>();
    private final TokenManagerConfig config;

    private ImpersonationTokenManager(String connectorName) {
        this.tokenCache = ServiceProvider.getCachingService(connectorName);
        this.config = new TokenManagerConfig(connectorName);
    }

    public static ImpersonationTokenManager getInstance() {
        if (StringUtils.isBlank((CharSequence)ExecutionContext.getConnectorName())) {
            throw new IllegalArgumentException("Connector Name cannot be null or empty");
        }
        return ImpersonationTokenManager.getInstance(Objects.requireNonNull(ExecutionContext.getConnectorName()));
    }

    public static ImpersonationTokenManager getInstance(String connectorName) {
        return INSTANCES.computeIfAbsent(connectorName, ImpersonationTokenManager::new);
    }

    public String getValidAccessToken(String userEmail, Map<String, Object> connectionParams) throws AuthException {
        if (StringUtils.isBlank((CharSequence)userEmail)) {
            throw new AuthException("User email cannot be null or empty");
        }
        ReentrantLock userLock = this.userLocks.computeIfAbsent(userEmail, k -> new ReentrantLock());
        boolean lockAcquired = false;
        try {
            long lockTimeoutSeconds = this.config.getLockTimeoutSeconds();
            lockAcquired = userLock.tryLock(lockTimeoutSeconds, TimeUnit.SECONDS);
            if (!lockAcquired) {
                throw new AuthException("Failed to acquire lock for user " + userEmail + " within " + lockTimeoutSeconds + " seconds");
            }
            String string = this.getAccessToken(userEmail, connectionParams);
            return string;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new AuthException("Token acquisition was interrupted for user: " + userEmail, e);
        }
        finally {
            if (lockAcquired) {
                userLock.unlock();
            }
        }
    }

    private String getAccessToken(String userEmail, Map<String, Object> connectionParams) throws AuthException {
        try {
            return this.tokenCache.getCachedValue(userEmail, key -> {
                try {
                    return this.generateTokenWithRetry((String)key, connectionParams);
                }
                catch (AuthException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (RuntimeException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof AuthException) {
                AuthException authException = (AuthException)throwable;
                throw authException;
            }
            throw e;
        }
    }

    public void invalidateToken(String userEmail) {
        this.tokenCache.invalidate(userEmail);
        log.info("Cleared all cached tokens for user: {}", (Object)userEmail);
    }

    private String generateAndCacheTokenJson(String userEmail, Map<String, Object> connectionParams) throws AuthException {
        try {
            AuthProvider authProvider = AuthProviderFactory.getAuthProvider(connectionParams);
            if (authProvider == null) {
                throw new IllegalArgumentException("Invalid Auth provider");
            }
            AuthProvider.TokenResponse tokenResponse = authProvider.getToken();
            String accessToken = tokenResponse.access_token();
            log.info("Generated and cached token for user: {}", (Object)userEmail);
            return accessToken;
        }
        catch (Exception e) {
            log.error("Failed to generate token for user: {}", (Object)userEmail, (Object)e);
            throw new AuthException("Failed to generate token for user: " + userEmail, e);
        }
    }

    private String generateTokenWithRetry(String userEmail, Map<String, Object> connectionParams) throws AuthException {
        int maxRetryAttempts = this.config.getMaxRetryAttempts();
        long retryDelayMs = this.config.getRetryDelayMs();
        for (int attempt = 1; attempt <= maxRetryAttempts; ++attempt) {
            try {
                log.info("Generating token for user {} (attempt {}/{})", new Object[]{userEmail, attempt, maxRetryAttempts});
                return this.generateAndCacheTokenJson(userEmail, connectionParams);
            }
            catch (AuthException e) {
                if (attempt == maxRetryAttempts) {
                    log.error("Failed to generate token for user: {} after {} attempts: {}", new Object[]{userEmail, maxRetryAttempts, e.getMessage()});
                    throw e;
                }
                log.warn("Token generation failed for user {} (attempt {}/{}): {}. Retrying in {} ms...", new Object[]{userEmail, attempt, maxRetryAttempts, e.getMessage(), retryDelayMs});
                try {
                    Thread.sleep(retryDelayMs);
                    continue;
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new AuthException("Token generation was interrupted for user: " + userEmail, ie);
                }
            }
        }
        throw new AuthException("Failed to generate token for user: " + userEmail);
    }
}

