/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.internal.connection;

import com.mulesoft.connectivity.datacloud.api.model.DataCloudConnectionModel;
import com.mulesoft.connectivity.datacloud.internal.auth.AuthException;
import com.mulesoft.connectivity.datacloud.internal.auth.AuthProvider;
import com.mulesoft.connectivity.datacloud.internal.auth.AuthProviderFactory;
import com.mulesoft.connectivity.datacloud.internal.context.ExecutionContext;
import com.mulesoft.connectivity.datacloud.internal.service.CachingService;
import com.mulesoft.connectivity.datacloud.internal.service.ServiceProvider;
import com.mulesoft.connectivity.linkweave.api.loader.WeaveTypeSimplifier;
import com.mulesoft.connectivity.linkweave.api.model.MetadataKey;
import com.salesforce.dataconnectors.api.model.input.InputAttributes;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.mule.weave.v2.api.tooling.ts.ArrayMetadataValue;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.KeyValuePairType;
import org.mule.weave.v2.api.tooling.ts.LiteralMetadataValue;
import org.mule.weave.v2.api.tooling.ts.ObjectType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataCloudConnection {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataCloudConnection.class);
    private static final String SECRET_TOKEN_SEMANTIC_TERM = "secretToken";
    private final InputAttributes inputAttributes;
    private final DataCloudConnectionModel connectionModel;

    public DataCloudConnection(DataCloudConnectionModel connectionModel, InputAttributes inputAttributes) {
        this.connectionModel = connectionModel;
        this.inputAttributes = inputAttributes;
    }

    public String getName() {
        return this.inputAttributes.getConnectionId();
    }

    public Map<String, Object> getParameters() {
        Map<String, Object> params = DataCloudConnection.getParametersMap(this.inputAttributes);
        this.processAuthTokens().ifPresent(params::putAll);
        return params;
    }

    private Optional<String> getOAuthAccessTokenFieldName() {
        return Arrays.stream(((ObjectType)WeaveTypeSimplifier.simplifyWeaveType((DWType)this.connectionModel.getConnectionProviderModel().getInputType().getDataType())).getProperties()).filter(this::hasOauthTokenSemanticTerm).findFirst().map(KeyValuePairType::getKeyName);
    }

    private boolean hasOauthTokenSemanticTerm(KeyValuePairType field) {
        return field.getValue().getTypeMetadata(MetadataKey.SEMANTIC_TERMS.getKey()).map(f -> Arrays.stream(((ArrayMetadataValue)f.getValue()).getElements()).anyMatch(e -> ((LiteralMetadataValue)e).getValue().equalsIgnoreCase(SECRET_TOKEN_SEMANTIC_TERM))).orElse(false);
    }

    public static Map<String, Object> getParametersMap(InputAttributes inputAttributes) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.putAll(inputAttributes.getCredentialAttributes() != null ? inputAttributes.getCredentialAttributes() : Collections.emptyMap());
        result.putAll(inputAttributes.getConnectionAttributes() != null ? inputAttributes.getConnectionAttributes() : Collections.emptyMap());
        if (inputAttributes.getConnectionId() != null) {
            result.put("connectionId", inputAttributes.getConnectionId());
        }
        return result;
    }

    private Optional<Map<String, Object>> processAuthTokens() {
        Optional<String> maybeAccessTokenFieldName = this.getOAuthAccessTokenFieldName();
        return maybeAccessTokenFieldName.map(tokenField -> DataCloudConnection.processAuthTokens(this.inputAttributes, tokenField));
    }

    private static Map<String, Object> processAuthTokens(InputAttributes inputAttributes, String tokenField) {
        Map<String, Object> connectionAttributes = DataCloudConnection.getParametersMap(inputAttributes);
        HashMap<String, Object> credentials = new HashMap<String, Object>();
        AuthProvider authProvider = AuthProviderFactory.getAuthProvider(connectionAttributes);
        if (authProvider != null) {
            CachingService cache = ServiceProvider.getCachingService(ExecutionContext.getConnectorName());
            try {
                String token = cache.getCachedValue(authProvider.hashValue(), t -> DataCloudConnection.getAccessToken(authProvider));
                credentials.put(tokenField, token);
            }
            catch (Exception e) {
                log.error("Error getting access token: {}", (Object)e.getMessage());
                throw e;
            }
        }
        return credentials;
    }

    private static String getAccessToken(AuthProvider authProvider) {
        try {
            return authProvider.getToken().access_token();
        }
        catch (AuthException e) {
            throw new IllegalStateException("Authentication failed: " + e.getMessage(), e);
        }
    }

    public void invalidateAuthToken() {
        CachingService cache = ServiceProvider.getCachingService(ExecutionContext.getConnectorName());
        Map<String, Object> params = DataCloudConnection.getParametersMap(this.inputAttributes);
        AuthProvider authProvider = AuthProviderFactory.getAuthProvider(params);
        if (authProvider != null) {
            cache.invalidate(authProvider.hashValue());
        }
    }

    @Generated
    public DataCloudConnectionModel getConnectionModel() {
        return this.connectionModel;
    }
}

