/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.internal.operation;

import com.mulesoft.connectivity.datacloud.api.model.CustomHandler;
import com.mulesoft.connectivity.datacloud.api.model.DataCloudConnectorModel;
import com.mulesoft.connectivity.datacloud.api.model.DataCloudObjectModel;
import com.mulesoft.connectivity.datacloud.api.model.RateLimitConfigurationModel;
import com.mulesoft.connectivity.datacloud.internal.operation.EntityCollectionProvider;
import com.mulesoft.connectivity.datacloud.internal.ratelimiter.RateLimitingPolicy;
import com.mulesoft.connectivity.datacloud.internal.retry.RetryConfiguration;
import com.mulesoft.connectivity.linkweave.api.interpreter.ModelInterpreter;
import com.mulesoft.connectivity.linkweave.api.model.ExecutableComponentModel;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;

public class OperationsIndex {
    private final Map<String, EntityCollectionProvider> index = new HashMap<String, EntityCollectionProvider>();
    private final RetryConfiguration retryConfiguration;
    private final RateLimitingPolicy rateLimitingPolicy;

    public OperationsIndex(ModelInterpreter modelInterpreter, DataCloudConnectorModel connectorModel, Map<String, Object> extractAttributes, RetryConfiguration retryConfiguration, RateLimitingPolicy rateLimitingPolicy) {
        this.retryConfiguration = retryConfiguration;
        this.rateLimitingPolicy = rateLimitingPolicy;
        this.buildIndex(modelInterpreter, connectorModel, extractAttributes);
    }

    public EntityCollectionProvider getCollectionProvider(String objectName) {
        EntityCollectionProvider entityCollectionProvider = this.index.get(objectName);
        if (entityCollectionProvider == null) {
            throw new IllegalStateException("No object found with name " + objectName);
        }
        return entityCollectionProvider;
    }

    private void buildIndex(ModelInterpreter modelInterpreter, DataCloudConnectorModel connectorModel, Map<String, Object> params) {
        connectorModel.getObjects().forEach((key, value) -> this.index.put((String)key, new EntityCollectionProvider(connectorModel.getName(), modelInterpreter, value.getConnectionModel().getConnectionProviderModel(), this.generateSequence((DataCloudObjectModel)value, params), this.retryConfiguration, this.rateLimitingPolicy)));
        if (connectorModel.getExternalCallout() != null) {
            connectorModel.getExternalCallout().forEach((key, value) -> this.index.put((String)key, new EntityCollectionProvider(connectorModel.getName(), modelInterpreter, value.getConnectionModel().getConnectionProviderModel(), this.generateSequence((DataCloudObjectModel)value, params), this.retryConfiguration, this.rateLimitingPolicy)));
        }
    }

    private List<OperationWrapper> generateSequence(DataCloudObjectModel objectModel, Map<String, Object> params) {
        ArrayDeque<OperationWrapper> sequence = new ArrayDeque<OperationWrapper>();
        DataCloudObjectModel currentObjectModel = objectModel;
        ExecutableComponentModel currentOp = objectModel.getResolvedBy();
        Map rateLimiterConfigs = currentObjectModel.getResolvedByRateLimiterConfigs();
        Function currentBinding = null;
        sequence.addFirst(new OperationWrapper(currentObjectModel.getName(), currentOp, rateLimiterConfigs, currentBinding, currentObjectModel.getIsContainer(), currentObjectModel.getContainerBinding(), currentObjectModel.isDoProcessContainer(), currentObjectModel.getCustomHandler()));
        while (currentObjectModel.getDependsOn() != null) {
            currentBinding = currentObjectModel.getDependencyBinding();
            Function runDependencyFun = currentObjectModel.getDependencyConditional();
            currentOp = currentObjectModel.getDependsOn().getResolvedBy();
            rateLimiterConfigs = currentObjectModel.getResolvedByRateLimiterConfigs();
            currentObjectModel = currentObjectModel.getDependsOn();
            boolean shouldRunDependency = true;
            if (runDependencyFun != null) {
                shouldRunDependency = (Boolean)runDependencyFun.apply(List.of(params));
            }
            if (!shouldRunDependency) continue;
            sequence.addFirst(new OperationWrapper(currentObjectModel.getName(), currentOp, rateLimiterConfigs, currentBinding, currentObjectModel.getIsContainer(), currentObjectModel.getContainerBinding(), currentObjectModel.isDoProcessContainer(), currentObjectModel.getCustomHandler()));
        }
        return sequence.stream().toList();
    }

    public record OperationWrapper(String objectName, ExecutableComponentModel<?> operation, @Nullable Map<String, RateLimitConfigurationModel> rateLimitConfigurations, @Nullable Function<List<Object>, Object> dependencyBinding, @Nullable Function<List<Object>, Object> isContainer, @Nullable Function<List<Object>, Object> containerBinding, boolean doProcessContainer, @Nullable CustomHandler customHandler) {
    }
}

