/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.internal.operation;

import com.mulesoft.connectivity.datacloud.api.model.DataCloudConnectionModel;
import com.mulesoft.connectivity.datacloud.api.model.DataCloudConnectorModel;
import com.mulesoft.connectivity.datacloud.internal.ConnectivityMessage;
import com.mulesoft.connectivity.datacloud.internal.connection.DataCloudConnection;
import com.mulesoft.connectivity.datacloud.internal.operation.DataCloudParameters;
import com.mulesoft.connectivity.datacloud.internal.operation.DataIterator;
import com.mulesoft.connectivity.datacloud.internal.operation.OperationsIndex;
import com.mulesoft.connectivity.datacloud.internal.ratelimiter.RateLimitingPolicy;
import com.mulesoft.connectivity.datacloud.internal.retry.RetryConfiguration;
import com.mulesoft.connectivity.linkweave.api.interpreter.ModelInterpreter;
import com.salesforce.dataconnectors.api.dataproviders.CloseableIterator;
import com.salesforce.dataconnectors.api.dataproviders.GroupsDataProvider;
import com.salesforce.dataconnectors.api.exception.ConnectorException;
import com.salesforce.dataconnectors.api.model.connectors.federated.Group;
import com.salesforce.dataconnectors.api.model.data.BoundedArrayList;
import com.salesforce.dataconnectors.api.model.input.InputAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public class GroupIterator
extends DataIterator<ConnectivityMessage>
implements GroupsDataProvider {
    private @Nullable Object watermark;
    private static final int PAGE_SIZE = 100;
    private static final String FIELD_ID = "id";
    private static final String FIELD_EMAIL = "email";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_ATTRIBUTES = "attributes";

    public GroupIterator(ModelInterpreter modelInterpreter, DataCloudConnectorModel connectorModel, InputAttributes inputAttributes, String objectName, DataCloudConnectionModel connectionModel, RetryConfiguration retryConfiguration, RateLimitingPolicy rateLimitingPolicy) {
        super(modelInterpreter, connectorModel, objectName, inputAttributes, connectionModel, retryConfiguration, rateLimitingPolicy);
    }

    @Override
    void doExtract() {
        OperationsIndex operationsIndex = new OperationsIndex(this.modelInterpreter, this.connectorModel, this.inputAttributes.getExtractAttributes(), this.retryConfiguration, this.rateLimitingPolicy);
        operationsIndex.getCollectionProvider(this.objectName).execute(new DataCloudConnection(this.connectionModel, this.inputAttributes), new DataCloudParameters(this.inputAttributes), this::consumeMessage);
    }

    private void consumeMessage(ConnectivityMessage message) {
        if (message.getType().equals(this.objectName)) {
            this.consumeData(message);
        }
    }

    public CloseableIterator<BoundedArrayList<Group>> get() {
        return new CloseableIterator<BoundedArrayList<Group>>(){
            final List<Group> groups = new ArrayList<Group>();
            int count = 0;

            public boolean hasNext() throws ConnectorException {
                return GroupIterator.this.hasMoreData(300L);
            }

            public BoundedArrayList<Group> next() throws ConnectorException {
                this.groups.clear();
                this.count = 0;
                while (this.hasNext() && this.count < 100) {
                    ConnectivityMessage message = (ConnectivityMessage)GroupIterator.this.nextData();
                    Object record = message.getContent();
                    LinkedHashMap processedRecord = (LinkedHashMap)record;
                    Group group = Group.builder().id((String)processedRecord.get(GroupIterator.FIELD_ID)).email((String)processedRecord.get(GroupIterator.FIELD_EMAIL)).name((String)processedRecord.get(GroupIterator.FIELD_NAME)).attributes(new HashMap()).build();
                    this.groups.add(group);
                    ++this.count;
                    GroupIterator.this.watermark = message.getWatermark();
                }
                return new BoundedArrayList(this.groups);
            }

            public void close() {
                GroupIterator.this.cancel();
            }
        };
    }

    public Map<String, Object> getIncrementalExtractAttributes() {
        return Objects.isNull(this.watermark) ? Collections.emptyMap() : Map.of("greatestWatermark", this.watermark);
    }
}

