/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.internal.utils;

import com.mulesoft.connectivity.datacloud.internal.utils.HierarchicalPropertyResolver;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Base64;

public class HashingUtils {
    private static final String HASHING_SALT_PROPERTY = "com.mulesoft.connectivity.datacloud.hashing.salt";
    private static final String DEFAULT_HASHING_SALT = "mulesoft123connectivity456datacloud789connector";

    private HashingUtils() {
    }

    public static String secureStringHash(String value) {
        if (value.isEmpty()) {
            return value;
        }
        try {
            String encryptionKey = HashingUtils.getHashingSalt();
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(encryptionKey.getBytes(StandardCharsets.UTF_8));
            byte[] hashBytes = digest.digest(value.getBytes(StandardCharsets.UTF_8));
            String base64Hash = Base64.getEncoder().encodeToString(hashBytes);
            return "hash_" + base64Hash;
        }
        catch (Exception ex) {
            return "fallback_" + Integer.toHexString(value.hashCode());
        }
    }

    private static String getHashingSalt() {
        try {
            String configuredSalt = HierarchicalPropertyResolver.getDirectConfigValue(HASHING_SALT_PROPERTY);
            if (configuredSalt != null && !configuredSalt.trim().isEmpty()) {
                return configuredSalt;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return DEFAULT_HASHING_SALT;
    }
}

