/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.internal.retry.adjustment;

import com.mulesoft.connectivity.datacloud.internal.connection.DataCloudConnection;
import com.mulesoft.connectivity.datacloud.internal.operation.ExecutionParameters;
import com.mulesoft.connectivity.datacloud.internal.retry.adjustment.AdjustmentContext;
import com.mulesoft.connectivity.datacloud.internal.retry.adjustment.ParameterAdjuster;
import com.mulesoft.connectivity.datacloud.internal.utils.CustomHandlerMapper;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenRefreshAdjuster
implements ParameterAdjuster {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TokenRefreshAdjuster.class);

    @Override
    public ExecutionParameters adjust(ExecutionParameters parameters, AdjustmentContext context) {
        try {
            DataCloudConnection dataCloudConnection = context.getConnection();
            dataCloudConnection.invalidateAuthToken();
            Map<String, Object> connectionParams = dataCloudConnection.getParameters();
            Map params = (Map)parameters.getParameters();
            CustomHandlerMapper.getErrorHandlerFunction(parameters.getCustomHandler()).ifPresent(errorHandler -> errorHandler.accept(params));
            CustomHandlerMapper.getHandlerFunction(parameters.getCustomHandler()).ifPresent(handler -> handler.accept(connectionParams, params));
            return parameters.toBuilder().connectionInfo(connectionParams).build();
        }
        catch (Exception e) {
            log.error("Failed to refresh authentication token, using original parameters", (Throwable)e);
            return parameters;
        }
    }
}

