/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.internal.operation;

import com.mulesoft.connectivity.datacloud.api.model.CustomHandler;
import com.mulesoft.connectivity.datacloud.api.model.DataCloudConnectionProviderModel;
import com.mulesoft.connectivity.datacloud.api.model.RateLimitConfigurationModel;
import com.mulesoft.connectivity.datacloud.internal.connection.DataCloudConnection;
import com.mulesoft.connectivity.datacloud.internal.context.ExecutionContext;
import com.mulesoft.connectivity.datacloud.internal.operation.DataCloudParameters;
import com.mulesoft.connectivity.datacloud.internal.operation.DataProvider;
import com.mulesoft.connectivity.datacloud.internal.operation.ExecutionFunctionBuilder;
import com.mulesoft.connectivity.datacloud.internal.operation.ExecutionParameters;
import com.mulesoft.connectivity.datacloud.internal.operation.ExecutionUtils;
import com.mulesoft.connectivity.datacloud.internal.ratelimiter.RateLimitingConfiguration;
import com.mulesoft.connectivity.datacloud.internal.ratelimiter.RateLimitingPolicy;
import com.mulesoft.connectivity.datacloud.internal.retry.RetryConfiguration;
import com.mulesoft.connectivity.linkweave.api.interpreter.Content;
import com.mulesoft.connectivity.linkweave.api.interpreter.ModelInterpreter;
import com.mulesoft.connectivity.linkweave.api.model.ExecutableComponentModel;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationModel;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationResult;
import com.salesforce.dataconnectors.api.model.data.ObjectMetadata;
import com.salesforce.dataconnectors.api.model.data.ObjectStream;
import java.io.InputStream;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.mule.weave.v2.core.io.SeekableStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileContentProvider
implements DataProvider<ObjectStream> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileContentProvider.class);
    private final String connectorName;
    private final ModelInterpreter modelInterpreter;
    private final DataCloudConnectionProviderModel connectionProviderModel;
    private final @Nullable Map<String, RateLimitConfigurationModel> rateLimitConfigurationModels;
    private final OperationModel operationModel;
    private final @Nullable CustomHandler customHandler;
    private final RetryConfiguration retryConfiguration;
    private final RateLimitingPolicy rateLimitingPolicy;

    @Override
    public void execute(DataCloudConnection connection, DataCloudParameters parameters, Consumer<ObjectStream> recordConsumer) {
        ExecutionContext.setConnectorName(this.connectorName);
        ExecutionParameters executionParameters = ExecutionParameters.builder().connectionProviderModel(this.connectionProviderModel).executableModel((ExecutableComponentModel<?>)this.operationModel).connectionInfo(connection.getParameters()).parameters(parameters.getParameters()).customHandler(this.customHandler).build();
        log.info("Downloading content for {}", parameters.getParameters());
        Function executionFunction = ExecutionFunctionBuilder.builder(this.modelInterpreter).build(ExecutionFunctionBuilder.FunctionName.OPERATION);
        RateLimitingConfiguration rateLimitingConfiguration = RateLimitingConfiguration.builder().operationRateLimitConfigurations(this.rateLimitConfigurationModels).connectionRateLimitConfigurations(connection.getConnectionModel().getRateLimitConfigurationModels()).build();
        OperationResult result = ExecutionUtils.execute(this.connectorName, executionFunction, executionParameters, connection, this.retryConfiguration, rateLimitingConfiguration, this.rateLimitingPolicy);
        AutoCloseable response = (AutoCloseable)result.orElseThrow(error -> {
            Object patt4711$temp = error.getValue();
            if (patt4711$temp instanceof Map) {
                Map errorMap = (Map)patt4711$temp;
                log.error("Error while re-downloading file data for {} with status code {} and error {} ", new Object[]{parameters.getParameters(), errorMap.get("status"), errorMap.get("body")});
            } else {
                log.error("Unsuccessful execution Error: {}{}Cause: {}", new Object[]{error.getValue(), System.lineSeparator(), error.getDescription()});
            }
            return new RuntimeException("Error while downloading file data for " + String.valueOf(parameters.getParameters()) + " with error " + error.getKind());
        });
        try (AutoCloseable autoCloseable = response;){
            Map responseValue = (Map)((Content)response).get();
            Object body = responseValue.get("body");
            if (body == null) {
                body = SeekableStream.apply((byte[])new byte[0]);
            }
            if (!(body instanceof SeekableStream)) {
                log.error("Error while downloading file data for {}: Expected a SeekableStream but got '{}'", parameters.getParameters(), body);
                throw new IllegalStateException("Unable to read file content");
            }
            SeekableStream seekableStream = (SeekableStream)body;
            String fileName = UUID.randomUUID().toString();
            ObjectStream objectStream = new ObjectStream((InputStream)body, new ObjectMetadata(fileName, Long.valueOf(seekableStream.size()), Boolean.valueOf(false)));
            recordConsumer.accept(objectStream);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to process file content", e);
        }
    }

    @Generated
    public FileContentProvider(String connectorName, ModelInterpreter modelInterpreter, DataCloudConnectionProviderModel connectionProviderModel, @Nullable Map<String, RateLimitConfigurationModel> rateLimitConfigurationModels, OperationModel operationModel, @Nullable CustomHandler customHandler, RetryConfiguration retryConfiguration, RateLimitingPolicy rateLimitingPolicy) {
        this.connectorName = connectorName;
        this.modelInterpreter = modelInterpreter;
        this.connectionProviderModel = connectionProviderModel;
        this.rateLimitConfigurationModels = rateLimitConfigurationModels;
        this.operationModel = operationModel;
        this.customHandler = customHandler;
        this.retryConfiguration = retryConfiguration;
        this.rateLimitingPolicy = rateLimitingPolicy;
    }
}

