/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.api.connector;

import com.mulesoft.connectivity.datacloud.api.model.DataCloudConnectionModel;
import com.mulesoft.connectivity.datacloud.api.model.DataCloudConnectionProviderModel;
import com.mulesoft.connectivity.datacloud.api.model.DataCloudConnectorModel;
import com.mulesoft.connectivity.datacloud.api.model.DataCloudObjectModel;
import com.mulesoft.connectivity.datacloud.api.model.OperationType;
import com.mulesoft.connectivity.datacloud.internal.connection.DataCloudConnection;
import com.mulesoft.connectivity.datacloud.internal.context.ExecutionContext;
import com.mulesoft.connectivity.datacloud.internal.monitor.AbstractHealthMonitor;
import com.mulesoft.connectivity.datacloud.internal.monitor.CacheHealthMonitor;
import com.mulesoft.connectivity.datacloud.internal.monitor.ThreadPoolHealthMonitor;
import com.mulesoft.connectivity.datacloud.internal.operation.GroupIterator;
import com.mulesoft.connectivity.datacloud.internal.operation.ObjectStreamIterator;
import com.mulesoft.connectivity.datacloud.internal.operation.RecordIterator;
import com.mulesoft.connectivity.datacloud.internal.ratelimiter.RateLimitingPolicy;
import com.mulesoft.connectivity.datacloud.internal.retry.RetryConfiguration;
import com.mulesoft.connectivity.datacloud.internal.types.FieldTypeTransformer;
import com.mulesoft.connectivity.datacloud.internal.types.ObjectTypeTransformer;
import com.mulesoft.connectivity.datacloud.internal.utils.Utils;
import com.mulesoft.connectivity.linkweave.api.interpreter.ModelInterpreter;
import com.mulesoft.connectivity.linkweave.api.loader.WeaveTypeSimplifier;
import com.mulesoft.connectivity.linkweave.api.model.ExecutableComponentModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.BaseConnectionProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.ConnectionValidationResult;
import com.mulesoft.connectivity.linkweave.api.model.connection.TestConnectionModel;
import com.salesforce.dataconnectors.api.Connector;
import com.salesforce.dataconnectors.api.ContentConnector;
import com.salesforce.dataconnectors.api.FederatedConnector;
import com.salesforce.dataconnectors.api.dataproviders.DataProvider;
import com.salesforce.dataconnectors.api.dataproviders.GroupsDataProvider;
import com.salesforce.dataconnectors.api.exception.ConnectorException;
import com.salesforce.dataconnectors.api.exception.ExceptionCategory;
import com.salesforce.dataconnectors.api.model.connection.Attribute;
import com.salesforce.dataconnectors.api.model.connection.ConnectionDefinition;
import com.salesforce.dataconnectors.api.model.connection.OperationResult;
import com.salesforce.dataconnectors.api.model.execution.ExtractAttributes;
import com.salesforce.dataconnectors.api.model.input.FederatedInputAttributes;
import com.salesforce.dataconnectors.api.model.input.InputAttributes;
import com.salesforce.dataconnectors.api.model.metadata.Field;
import com.salesforce.dataconnectors.api.model.metadata.IncrementalAttributes;
import com.salesforce.dataconnectors.api.model.metadata.ObjectType;
import com.salesforce.dataconnectors.api.model.metadata.SourceObject;
import com.salesforce.dataconnectors.api.model.metadata.SourceObjectCollection;
import com.salesforce.dataconnectors.api.model.metadata.SourceObjectDescribe;
import com.salesforce.dataconnectors.api.service.ConnectorServicesProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.KeyValuePairType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataCloudConnector
implements Connector,
ContentConnector,
FederatedConnector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataCloudConnector.class);
    private static final String OBJECT_NAME = "objectName";
    private static final String OBJECT_TYPE = "objectType";
    private static final List<String> GROUPS_FIELD_LIST = List.of("email", "id", "name");
    private final DataCloudConnectorModel connectorModel;
    private final ModelInterpreter modelInterpreter;
    private final ConnectionDefinition connectionDefinition;
    private final AtomicReference<List<Attribute>> extractAttributes = new AtomicReference();
    private final AtomicReference<ThreadPoolHealthMonitor> threadPoolHealthMonitor = new AtomicReference();
    private final AtomicReference<CacheHealthMonitor> cacheHealthMonitor = new AtomicReference();
    private final RetryConfiguration retryConfiguration;

    public DataCloudConnector(DataCloudConnectorModel connectorModel, ConnectionDefinition connectionDefinition, ModelInterpreter modelInterpreter) {
        this.connectorModel = connectorModel;
        this.connectionDefinition = connectionDefinition;
        this.modelInterpreter = modelInterpreter;
        this.retryConfiguration = RetryConfiguration.createDefault(connectorModel.getName());
    }

    public String getName() {
        return this.connectorModel.getName();
    }

    public GroupsDataProvider fetchGroupsByUser(FederatedInputAttributes federatedInputAttributes) throws ConnectorException {
        DataCloudObjectModel externalCalloutObject = null;
        Map map = this.connectorModel.getExternalCallout();
        for (Map.Entry entry : map.entrySet()) {
            if (!((DataCloudObjectModel)entry.getValue()).getType().equals((Object)ObjectType.GROUP)) continue;
            externalCalloutObject = (DataCloudObjectModel)entry.getValue();
            break;
        }
        if (externalCalloutObject == null) {
            throw new ConnectorException("Unable to find external callout object");
        }
        return new GroupIterator(this.modelInterpreter, this.connectorModel, ((InputAttributes.InputAttributesBuilder)((InputAttributes.InputAttributesBuilder)InputAttributes.builder().connectionAttributes(federatedInputAttributes.getConnectionAttributes())).credentialAttributes(federatedInputAttributes.getCredentialAttributes())).extractAttributes(Map.of("userId", federatedInputAttributes.getUserId())).fieldList(GROUPS_FIELD_LIST).batchSize(Integer.valueOf(100)).build(), externalCalloutObject.getName(), externalCalloutObject.getConnectionModel(), this.retryConfiguration, RateLimitingPolicy.ENABLED);
    }

    public ConnectionDefinition getConnectionDefinition() {
        return this.connectionDefinition;
    }

    public ExtractAttributes getExtractAttributes() throws ConnectorException {
        return Utils.getExtractAttributes(this.connectorModel.getName());
    }

    public OperationResult testConnection(InputAttributes inputAttributes) throws ConnectorException {
        try {
            Utils.logInputAttributes("Test all connections", inputAttributes);
            ConnectionValidationResult connectionValidationResult = ConnectionValidationResult.failure(null, null);
            ExecutionContext.setConnectorName(this.connectorModel.getName());
            ExecutionContext.setOperationType(OperationType.TEST_CONNECTION);
            for (DataCloudConnectionModel connectionModel : this.connectorModel.getConnections()) {
                log.debug("Testing connection: {}", (Object)connectionModel.getName());
                DataCloudConnection connection = new DataCloudConnection(connectionModel, inputAttributes);
                Map<String, Object> connectionParams = connection.getParameters();
                DataCloudConnectionProviderModel connectionProviderModel = connectionModel.getConnectionProviderModel();
                if (connectionProviderModel.getTestConnection() == null) {
                    log.warn("No test connection defined for connection provider: {}", (Object)connectionProviderModel.getName());
                    continue;
                }
                TestConnectionModel testConnection = connectionProviderModel.getTestConnection();
                connectionValidationResult = this.modelInterpreter.testConnection(testConnection, (BaseConnectionProviderModel)connectionProviderModel, connectionParams);
                if (connectionValidationResult.isValid()) continue;
                return OperationResult.builder().success(Boolean.valueOf(false)).build();
            }
            if (!connectionValidationResult.isValid() && this.connectorModel.getTestConnection() != null) {
                DataCloudConnectionModel connectionModel = (DataCloudConnectionModel)this.connectorModel.getConnections().get(0);
                DataCloudConnection connection = new DataCloudConnection(connectionModel, inputAttributes);
                Map<String, Object> connectionParams = connection.getParameters();
                TestConnectionModel testConnection = this.connectorModel.getTestConnection();
                connectionValidationResult = this.modelInterpreter.testConnection(testConnection, (BaseConnectionProviderModel)connectionModel.getConnectionProviderModel(), connectionParams);
            }
            return OperationResult.builder().success(Boolean.valueOf(connectionValidationResult != null && connectionValidationResult.isValid())).build();
        }
        catch (Exception e) {
            throw new ConnectorException("Test Connection Failed", (Throwable)e, ExceptionCategory.USER);
        }
    }

    public SourceObjectCollection getObjects(InputAttributes inputAttributes) throws ConnectorException {
        Utils.logInputAttributes("Get Objects", inputAttributes);
        ExecutionContext.setOperationType(OperationType.GET_OBJECTS);
        Map sourceObjectsPerType = this.connectorModel.getObjects().values().stream().filter(o -> !o.isHidden()).collect(Collectors.toConcurrentMap(dataCloudObjectModel -> dataCloudObjectModel.getType().getValue(), object -> {
            ArrayList<SourceObject> objects = new ArrayList<SourceObject>();
            objects.add(ObjectTypeTransformer.transform(object));
            return objects;
        }, (existingList, newList) -> {
            existingList.addAll(newList);
            return existingList;
        }));
        List objectTypes = inputAttributes.getObjectTypes();
        if (objectTypes == null || objectTypes.isEmpty()) {
            log.warn("No objectType was specified, returning all source objects");
            return SourceObjectCollection.builder().sourceObjects((List)sourceObjectsPerType.values().stream().reduce(new ArrayList(), (sourceObjects, sourceObjects2) -> {
                sourceObjects.addAll(sourceObjects2);
                return sourceObjects;
            })).build();
        }
        ArrayList sourceObjects3 = new ArrayList();
        for (ObjectType objectType : objectTypes) {
            if (!sourceObjectsPerType.containsKey(objectType.getValue())) continue;
            sourceObjects3.addAll((Collection)sourceObjectsPerType.get(objectType.getValue()));
        }
        return SourceObjectCollection.builder().sourceObjects(sourceObjects3).build();
    }

    public OperationResult isObjectValid(String objectName, InputAttributes inputAttributes) throws ConnectorException {
        return OperationResult.builder().success(Boolean.valueOf(this.getObjects(inputAttributes).getSourceObjects().stream().anyMatch(x -> x.getName().equals(this.getActualObjectName(objectName, inputAttributes))))).build();
    }

    public SourceObjectDescribe getFields(String objectName, InputAttributes inputAttributes) throws ConnectorException {
        String actualObjectName = this.getActualObjectName(objectName, inputAttributes);
        log.debug("Describing {}", (Object)actualObjectName);
        Utils.logInputAttributes("Get Fields", inputAttributes);
        ExecutionContext.setOperationType(OperationType.GET_FIELDS);
        try {
            DataCloudObjectModel dataCloudObjectModel = this.connectorModel.getObjects().values().stream().filter(objectModel -> objectModel.getName().equals(actualObjectName)).findFirst().orElseThrow(() -> new ConnectorException(String.format("Unable to find object %s in connector", actualObjectName), ExceptionCategory.INTERNAL));
            DWType metadataType = dataCloudObjectModel.getMetadataType().getDataType();
            org.mule.weave.v2.api.tooling.ts.ObjectType objectMetadataType = (org.mule.weave.v2.api.tooling.ts.ObjectType)metadataType;
            KeyValuePairType[] metadataTypeProperties = objectMetadataType.getProperties();
            List fields = Arrays.stream(metadataTypeProperties).flatMap(objectFieldType -> FieldTypeTransformer.transform(objectFieldType, this.connectorModel.getConfig()).stream()).toList();
            Optional<ExecutableComponentModel> contentProviderOptional = Optional.ofNullable(((DataCloudObjectModel)this.connectorModel.getObjects().get(actualObjectName)).getContentProvider());
            if (contentProviderOptional.isPresent()) {
                List contentProviderInput = contentProviderOptional.map(provider -> Arrays.stream(((org.mule.weave.v2.api.tooling.ts.ObjectType)WeaveTypeSimplifier.simplifyWeaveType((DWType)provider.getInputType().getDataType())).getProperties()).flatMap(objectFieldType -> FieldTypeTransformer.transform(objectFieldType, this.connectorModel.getConfig()).stream()).map(Field::getName).map(fieldName -> fieldName.replaceAll("^\"|\"$", "")).toList()).orElse(Collections.emptyList());
                fields.forEach(field -> field.setRequiredForContentRetrieval(Boolean.valueOf(contentProviderInput.contains(field.getName()))));
            }
            log.debug("Fields for {}: {}", (Object)actualObjectName, fields);
            List primaryKeys = Arrays.stream(metadataTypeProperties).flatMap(objectFieldType -> FieldTypeTransformer.fetchPrimaryKeyFields(objectFieldType, this.connectorModel.getConfig()).stream()).toList();
            log.debug("Primary keys for {}: {}", (Object)actualObjectName, primaryKeys);
            List incrementalSyncKeys = Arrays.stream(metadataTypeProperties).flatMap(objectFieldType -> FieldTypeTransformer.fetchIncrementalFields(objectFieldType, this.connectorModel.getConfig()).stream()).toList();
            log.debug("Incremental keys for {}: {}", (Object)actualObjectName, incrementalSyncKeys);
            return SourceObjectDescribe.builder().objectName(actualObjectName).fields(fields).primaryKeys(primaryKeys).incrementalAttrs(IncrementalAttributes.builder().incrementalFields(incrementalSyncKeys).build()).build();
        }
        catch (Exception e) {
            throw new ConnectorException(String.format("Unable to retrieve fields of %s from connector %s", actualObjectName, this.connectorModel.getName()), (Throwable)e, ExceptionCategory.USER);
        }
    }

    public DataProvider<?> extractData(String objectName, InputAttributes inputAttributes) throws ConnectorException {
        this.checkMonitoringStatus();
        ExecutionContext.setOperationType(OperationType.EXTRACT_DATA);
        Utils.logInputAttributes("Extract Data", inputAttributes);
        DataCloudConnectionModel connectionModel = ((DataCloudObjectModel)this.connectorModel.getObjects().get(this.getActualObjectName(objectName, inputAttributes))).getConnectionModel();
        return new RecordIterator(this.modelInterpreter, this.connectorModel, inputAttributes, this.getActualObjectName(objectName, inputAttributes), connectionModel, this.retryConfiguration, RateLimitingPolicy.ENABLED);
    }

    public DataProvider<?> downloadContent(String objectName, InputAttributes inputAttributes) throws ConnectorException {
        this.checkMonitoringStatus();
        ExecutionContext.setOperationType(OperationType.EXTRACT_DATA);
        Utils.logInputAttributes("Download Data", inputAttributes);
        DataCloudConnectionModel connectionModel = ((DataCloudObjectModel)this.connectorModel.getObjects().get(this.getActualObjectName(objectName, inputAttributes))).getConnectionModel();
        return new ObjectStreamIterator(this.modelInterpreter, this.connectorModel, inputAttributes, this.getActualObjectName(objectName, inputAttributes), connectionModel, this.retryConfiguration, RateLimitingPolicy.ENABLED);
    }

    private String getActualObjectName(String objectName, InputAttributes inputAttributes) {
        Map advancedAttributes = inputAttributes.getExtractAttributes();
        if (advancedAttributes != null) {
            Object objectType = advancedAttributes.get(OBJECT_TYPE);
            log.debug("Got object type {} from advanced attributes", objectType);
            if (advancedAttributes.containsKey(OBJECT_NAME) && !this.isStructuredOrUnstructuredData(objectType)) {
                String actualObjectName = (String)advancedAttributes.get(OBJECT_NAME);
                log.debug("Got object name {} from advanced attributes", (Object)actualObjectName);
                return actualObjectName;
            }
        }
        log.debug("Got object name {} from parameters", (Object)objectName);
        return objectName;
    }

    private boolean isStructuredOrUnstructuredData(@Nullable Object objectType) {
        if (objectType == null) {
            return false;
        }
        return ObjectType.UNSTRUCTURED_DATA.getValue().equals(objectType) || ObjectType.STRUCTURED_DATA.getValue().equals(objectType);
    }

    private void checkMonitoringStatus() {
        AbstractHealthMonitor monitor;
        if (ConnectorServicesProvider.getGateService().isOpen("threadPoolMonitoringEnabled")) {
            monitor = this.threadPoolHealthMonitor.updateAndGet(current -> current != null ? current : new ThreadPoolHealthMonitor(this.connectorModel.getName()));
            if (!monitor.isMonitoring()) {
                monitor.startMonitoring();
            }
        } else {
            monitor = this.threadPoolHealthMonitor.get();
            if (monitor != null && monitor.isMonitoring()) {
                monitor.stopMonitoring();
            }
        }
        if (ConnectorServicesProvider.getGateService().isOpen("cacheMonitoringEnabled")) {
            monitor = this.cacheHealthMonitor.updateAndGet(current -> current != null ? current : new CacheHealthMonitor(this.connectorModel.getName()));
            if (!monitor.isMonitoring()) {
                monitor.startMonitoring();
            }
        } else {
            monitor = this.cacheHealthMonitor.get();
            if (monitor != null && monitor.isMonitoring()) {
                monitor.stopMonitoring();
            }
        }
    }
}

