/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.internal.utils;

import com.mulesoft.connectivity.datacloud.internal.utils.ObjectMappers;
import com.salesforce.dataconnectors.api.exception.ConnectorException;
import com.salesforce.dataconnectors.api.exception.ExceptionCategory;
import com.salesforce.dataconnectors.api.model.connection.ConnectionDefinition;
import com.salesforce.dataconnectors.api.model.execution.ExtractAttributes;
import com.salesforce.dataconnectors.api.model.input.InputAttributes;
import com.salesforce.dataconnectors.api.service.ConnectorServicesProvider;
import com.salesforce.dataconnectors.api.service.gates.GateService;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Utils.class);

    public static String logInputAttributes(String message, InputAttributes inputAttributes) {
        GateService gateService = ConnectorServicesProvider.getGateService();
        if (gateService != null && gateService.isOpen("enableUcParamLogs") && inputAttributes != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("InputAttributes {").append("\n  connectionId: ").append(inputAttributes.getConnectionId()).append("\n  connectorType: ").append(inputAttributes.getConnectorType()).append("\n  extractAttributes: ").append(Utils.mapToString(inputAttributes.getExtractAttributes())).append(" \n credentialAttributes: ").append(Utils.mapToString(inputAttributes.getCredentialAttributes())).append(" \n connectionAttributes: ").append(Utils.mapToString(inputAttributes.getConnectionAttributes())).append("\n  incrementalExtractAttributes: ").append(Utils.mapToString(inputAttributes.getIncrementalExtractAttributes())).append("\n  filterList: ").append(Utils.listToString(inputAttributes.getFilterList())).append("\n  fieldList: ").append(Utils.listToString(inputAttributes.getFieldList())).append("\n  dataLoadMode: ").append(inputAttributes.getDataLoadMode()).append("\n  objectTypes: ").append(Utils.listToString(inputAttributes.getObjectTypes())).append("\n  batchSize: ").append(inputAttributes.getBatchSize()).append("\n}");
            log.info("{} : {}", (Object)message, (Object)sb);
            return sb.toString();
        }
        return "";
    }

    private static String mapToString(Map<String, Object> map) {
        if (map == null) {
            return "null";
        }
        if (map.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder("{");
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            sb.append("\n    ").append(entry.getKey()).append(": ").append(entry.getValue());
        }
        sb.append("\n  }");
        return sb.toString();
    }

    private static String listToString(List<?> list) {
        if (list == null) {
            return "null";
        }
        if (list.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder("[");
        for (Object item : list) {
            sb.append("\n    ").append(item);
        }
        sb.append("\n  ]");
        return sb.toString();
    }

    public static ExtractAttributes getExtractAttributes(String connectorName) throws ConnectorException {
        ExtractAttributes extractAttributes;
        block8: {
            InputStream resource = Utils.getResourceStream(connectorName, "ExtractAttributes.json");
            try {
                extractAttributes = (ExtractAttributes)ObjectMappers.OBJECT_MAPPER.readValue(resource, ExtractAttributes.class);
                if (resource == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (resource != null) {
                        try {
                            resource.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ConnectorException("Error deserializing the ExtractAttributes file : " + e.getMessage(), (Throwable)e, ExceptionCategory.INTERNAL);
                }
            }
            resource.close();
        }
        return extractAttributes;
    }

    public static ConnectionDefinition getConnectionDefinition(String connectorName) throws ConnectorException {
        ConnectionDefinition connectionDefinition;
        block8: {
            InputStream resource = Utils.getResourceStream(connectorName, "ConnectionDefinition.json");
            try {
                connectionDefinition = (ConnectionDefinition)ObjectMappers.OBJECT_MAPPER.readValue(resource, ConnectionDefinition.class);
                if (resource == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (resource != null) {
                        try {
                            resource.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ConnectorException("Error deserializing the ConnectionDefinition file : " + e.getMessage(), (Throwable)e, ExceptionCategory.INTERNAL);
                }
            }
            resource.close();
        }
        return connectionDefinition;
    }

    private static InputStream getResourceStream(String connectorName, String resourceName) throws ConnectorException {
        String resourcePath = "com/mulesoft/connectivity/datacloud/connector/" + connectorName.toLowerCase(Locale.ROOT) + "/" + resourceName;
        InputStream stream = Utils.class.getClassLoader().getResourceAsStream(resourcePath);
        if (stream == null) {
            throw new ConnectorException(String.format("Resource %s not found: ", resourceName), ExceptionCategory.INTERNAL);
        }
        return stream;
    }

    private Utils() throws IllegalAccessException {
        throw new IllegalAccessException("Instantiation not allowed");
    }
}

