/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.internal.auth;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.connectivity.datacloud.internal.auth.AuthException;
import com.mulesoft.connectivity.datacloud.internal.utils.ObjectMappers;
import com.mulesoft.connectivity.datacloud.internal.utils.SharedHttpClients;
import java.io.IOException;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AuthProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthProvider.class);
    protected final ObjectMapper mapper = ObjectMappers.DEFAULT;
    protected final HttpClient httpClient;
    protected final Duration requestTimeout = Duration.ofSeconds(30L);
    protected static final String JWT_BEARER_GRANT = "urn:ietf:params:oauth:grant-type:jwt-bearer";
    protected static final String REFRESH_TOKEN_GRANT = "refresh_token";
    protected static final String CLIENT_CREDENTIALS_GRANT = "client_credentials";

    protected AuthProvider() {
        this.httpClient = SharedHttpClients.getDefault();
    }

    public TokenResponse getToken() throws AuthException {
        try {
            log.debug("Starting OAuth2 {} flow", (Object)this.getClass().getName());
            String requestBody = this.buildRequestBody();
            HttpRequest request = this.buildHttpRequest(requestBody);
            log.debug("Sending token request");
            HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            log.debug("Received response with status: {}", (Object)response.statusCode());
            return this.handleResponse(response);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new AuthException("Token request was interrupted", e);
        }
        catch (IllegalArgumentException e) {
            log.error("Invalid configuration or request parameters: {}", (Object)e.getMessage(), (Object)e);
            throw new AuthException("Invalid authentication configuration", e);
        }
        catch (Exception e) {
            log.error("Exception during token request: {}", (Object)e.getMessage(), (Object)e);
            throw new AuthException("Failed to obtain access token", e);
        }
    }

    abstract String buildRequestBody() throws IOException;

    abstract HttpRequest buildHttpRequest(String var1);

    private TokenResponse handleResponse(HttpResponse<String> response) throws AuthException {
        String responseBody = response.body();
        if (response.statusCode() == 200) {
            try {
                TokenResponse tr = (TokenResponse)this.mapper.readValue(responseBody, TokenResponse.class);
                log.info("Successfully obtained access token. Token type: {}, Expires in: {} seconds", (Object)tr.token_type(), (Object)tr.expires_in());
                if (tr.access_token() == null || tr.token_type() == null) {
                    throw new AuthException("Token response missing required fields");
                }
                return tr;
            }
            catch (Exception e) {
                log.error("Failed to parse successful token response: {}", (Object)e.getMessage(), (Object)e);
                throw new AuthException("Failed to parse token response", e);
            }
        }
        log.error("Token request failed with status {}", (Object)response.statusCode());
        try {
            JsonNode errorNode = this.mapper.readTree(responseBody);
            String error = errorNode.path("error").asText(null);
            String errorDescription = errorNode.path("error_description").asText(null);
            String errorUri = errorNode.path("error_uri").asText(null);
            throw new AuthException("OAuth2 Error - Code: " + error + ", Description: " + errorDescription + ", URI: " + errorUri);
        }
        catch (Exception e) {
            log.debug("Could not parse error response as JSON: {}", (Object)e.getMessage());
            throw new AuthException("Token request failed with status: " + response.statusCode() + " and error:" + responseBody);
        }
    }

    protected String urlEncode(String value) {
        return URLEncoder.encode(value, StandardCharsets.UTF_8);
    }

    public abstract String hashValue();

    @JsonIgnoreProperties(ignoreUnknown=true)
    public record TokenResponse(String access_token, @Nullable String token_type, Long expires_in, @Nullable Long ext_expires_in, @Nullable String refresh_token, @Nullable String scope) {
    }
}

