/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.internal.retry;

import com.mulesoft.connectivity.datacloud.internal.retry.AuthenticationRetryStrategy;
import com.mulesoft.connectivity.datacloud.internal.retry.ConnectionTimeoutRetryStrategy;
import com.mulesoft.connectivity.datacloud.internal.retry.RetryStrategy;
import com.mulesoft.connectivity.datacloud.internal.retry.ServerErrorRetryStrategy;
import com.mulesoft.connectivity.datacloud.internal.retry.ThrottlingRetryStrategy;
import com.mulesoft.connectivity.datacloud.internal.retry.jitter.RandomFactorStrategy;
import com.mulesoft.connectivity.datacloud.internal.utils.HierarchicalPropertyResolver;
import com.mulesoft.connectivity.linkweave.api.model.operation.OperationResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RetryConfiguration.class);
    private static final String RETRY_ENABLED_PROPERTY = "com.mulesoft.connectivity.datacloud.retry.enabled";
    private final List<RetryStrategy> strategies = new ArrayList<RetryStrategy>();
    private final String connectorName;

    public RetryConfiguration(String connectorName) {
        this.strategies.add(RetryConfiguration.createConfigurableAuthenticationRetryStrategy(connectorName));
        this.connectorName = connectorName;
    }

    public void addStrategy(RetryStrategy retryStrategy) {
        boolean strategyTypeExists = this.strategies.stream().anyMatch(existingStrategy -> existingStrategy.getClass().equals(retryStrategy.getClass()));
        if (strategyTypeExists) {
            log.debug("Strategy of type {} already exists, skipping addition", (Object)retryStrategy.getClass().getSimpleName());
            return;
        }
        this.strategies.add(retryStrategy);
    }

    public static RetryConfiguration createDefault(String connectorName) {
        RetryConfiguration retryConfiguration = new RetryConfiguration(connectorName);
        retryConfiguration.addStrategy(RetryConfiguration.createConfigurableThrottlingRetryStrategy(connectorName));
        retryConfiguration.addStrategy(RetryConfiguration.createConfigurableConnectionTimeoutRetryStrategy(connectorName));
        retryConfiguration.addStrategy(RetryConfiguration.createConfigurableServerErrorRetryStrategy(connectorName));
        return retryConfiguration;
    }

    private static AuthenticationRetryStrategy createConfigurableAuthenticationRetryStrategy(String connectorName) {
        int maxAttempts = RetryConfiguration.getIntProperty("com.mulesoft.connectivity.datacloud.retry.authentication.maxAttempts", 1, connectorName);
        long baseDelayMillis = RetryConfiguration.getLongProperty("com.mulesoft.connectivity.datacloud.retry.authentication.baseDelayMillis", 0L, connectorName);
        return new AuthenticationRetryStrategy(maxAttempts, baseDelayMillis);
    }

    private static ThrottlingRetryStrategy createConfigurableThrottlingRetryStrategy(String connectorName) {
        int maxAttempts = RetryConfiguration.getIntProperty("com.mulesoft.connectivity.datacloud.retry.throttling.maxAttempts", 5, connectorName);
        long baseDelayMillis = RetryConfiguration.getLongProperty("com.mulesoft.connectivity.datacloud.retry.throttling.baseDelayMillis", 1000L, connectorName);
        long maxDelayMillis = RetryConfiguration.getLongProperty("com.mulesoft.connectivity.datacloud.retry.throttling.maxDelayMillis", 30000L, connectorName);
        double jitterFactor = RetryConfiguration.getDoubleProperty("com.mulesoft.connectivity.datacloud.retry.throttling.jitterFactor", 0.25, connectorName);
        return new ThrottlingRetryStrategy(maxAttempts, baseDelayMillis, maxDelayMillis, new RandomFactorStrategy(jitterFactor));
    }

    private static ConnectionTimeoutRetryStrategy createConfigurableConnectionTimeoutRetryStrategy(String connectorName) {
        int maxAttempts = RetryConfiguration.getIntProperty("com.mulesoft.connectivity.datacloud.retry.connectionTimeout.maxAttempts", 3, connectorName);
        long baseDelayMillis = RetryConfiguration.getLongProperty("com.mulesoft.connectivity.datacloud.retry.connectionTimeout.baseDelayMillis", 1000L, connectorName);
        long maxDelayMillis = RetryConfiguration.getLongProperty("com.mulesoft.connectivity.datacloud.retry.connectionTimeout.maxDelayMillis", 10000L, connectorName);
        double jitterFactor = RetryConfiguration.getDoubleProperty("com.mulesoft.connectivity.datacloud.retry.connectionTimeout.jitterFactor", 0.1, connectorName);
        return new ConnectionTimeoutRetryStrategy(maxAttempts, baseDelayMillis, maxDelayMillis, new RandomFactorStrategy(jitterFactor));
    }

    private static ServerErrorRetryStrategy createConfigurableServerErrorRetryStrategy(String connectorName) {
        int maxAttempts = RetryConfiguration.getIntProperty("com.mulesoft.connectivity.datacloud.retry.serverError.maxAttempts", 3, connectorName);
        long baseDelayMillis = RetryConfiguration.getLongProperty("com.mulesoft.connectivity.datacloud.retry.serverError.baseDelayMillis", 500L, connectorName);
        long maxDelayMillis = RetryConfiguration.getLongProperty("com.mulesoft.connectivity.datacloud.retry.serverError.maxDelayMillis", 5000L, connectorName);
        double jitterFactor = RetryConfiguration.getDoubleProperty("com.mulesoft.connectivity.datacloud.retry.serverError.jitterFactor", 0.1, connectorName);
        return new ServerErrorRetryStrategy(maxAttempts, baseDelayMillis, maxDelayMillis, new RandomFactorStrategy(jitterFactor));
    }

    private static int getIntProperty(String propertyName, int defaultValue, String connectorName) {
        String value = HierarchicalPropertyResolver.getConfigValue(propertyName, connectorName);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                log.warn("Invalid value for property {}, using default: {}", (Object)propertyName, (Object)defaultValue);
            }
        }
        return defaultValue;
    }

    private static long getLongProperty(String propertyName, long defaultValue, String connectorName) {
        String value = HierarchicalPropertyResolver.getConfigValue(propertyName, connectorName);
        if (value != null) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                log.warn("Invalid value for property {}, using default: {}", (Object)propertyName, (Object)defaultValue);
            }
        }
        return defaultValue;
    }

    private static double getDoubleProperty(String propertyName, double defaultValue, String connectorName) {
        String value = HierarchicalPropertyResolver.getConfigValue(propertyName, connectorName);
        if (value != null) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                log.warn("Invalid value for property {}, using default: {}", (Object)propertyName, (Object)defaultValue);
            }
        }
        return defaultValue;
    }

    public Optional<RetryStrategy> findStrategyFor(OperationResult<?> result, Map<Class<? extends RetryStrategy>, Integer> strategyAttempts) {
        return this.strategies.stream().filter(strategy -> {
            Class<?> strategyClass = strategy.getClass();
            int nextAttempt = strategyAttempts.getOrDefault(strategyClass, 0) + 1;
            if (!strategy.shouldRetry(result, nextAttempt)) {
                log.debug("Strategy {} has reached max attempts or doesn't apply (attempt #{})", (Object)strategyClass.getSimpleName(), (Object)nextAttempt);
                return false;
            }
            return true;
        }).filter(strategy -> {
            if (!(strategy instanceof AuthenticationRetryStrategy)) {
                boolean retryEnabled;
                String retryEnabledStr = HierarchicalPropertyResolver.getConfigValue(RETRY_ENABLED_PROPERTY, this.connectorName);
                boolean bl = retryEnabled = retryEnabledStr == null || Boolean.parseBoolean(retryEnabledStr);
                if (!retryEnabled) {
                    log.info("Retry is disabled for connector {}, skipping {}", (Object)this.connectorName, strategy);
                    return false;
                }
            }
            return true;
        }).findFirst();
    }
}

