/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.internal;

import com.mulesoft.connectivity.datacloud.api.loader.DataCloudModelLoaderFactory;
import com.mulesoft.connectivity.datacloud.api.model.DataCloudConnectorModel;
import com.mulesoft.connectivity.datacloud.internal.PathBasedResourceResolver;
import com.mulesoft.connectivity.linkweave.api.interpreter.ModelInterpreter;
import com.mulesoft.connectivity.linkweave.api.interpreter.ModelInterpreterConfig;
import com.mulesoft.connectivity.linkweave.api.loader.LanguageModelLoader;
import com.mulesoft.connectivity.linkweave.api.loader.ModelLoader;
import java.io.File;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;
import org.mule.weave.v2.runtime.ModuleComponentsFactory;
import org.mule.weave.v2.runtime.SimpleModuleComponentFactory;
import org.mule.weave.v2.sdk.WeaveResourceResolver;

public class Runtime {
    private final ModelInterpreter modelInterpreter;
    private final LanguageModelLoader<DataCloudConnectorModel, DataCloudConnectorModel.Builder> modelLoader;

    private Runtime(DataWeaveScriptingEngine dataWeaveScriptingEngine) {
        this.modelInterpreter = new ModelInterpreter(dataWeaveScriptingEngine, new ModelInterpreterConfig.Builder().build());
        this.modelLoader = new LanguageModelLoader(dataWeaveScriptingEngine, (ModelLoader)new DataCloudModelLoaderFactory().create(), NameIdentifier.fromFQN((String)"com::mulesoft::connectivity::datacloud::Metadata::DataCloudConnectorElement"));
    }

    public DataCloudConnectorModel loadConnectorModel(String connectorSelector) {
        return (DataCloudConnectorModel)this.modelLoader.loadConnector(connectorSelector);
    }

    public ModelInterpreter getModelInterpreter() {
        return this.modelInterpreter;
    }

    public static class Builder {
        public Runtime build() {
            List<File> pathElements = this.getJarsFromClassPath();
            List<File> classLoaderFiles = this.getURLClassLoaderFiles();
            pathElements.addAll(classLoaderFiles);
            PathBasedResourceResolver resourceResolver = new PathBasedResourceResolver(pathElements);
            SimpleModuleComponentFactory moduleComponentFactory = SimpleModuleComponentFactory.apply((WeaveResourceResolver)resourceResolver);
            return new Runtime(DataWeaveScriptingEngine.apply((ModuleComponentsFactory)moduleComponentFactory));
        }

        private List<File> getURLClassLoaderFiles() {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (!(contextClassLoader instanceof URLClassLoader)) {
                return List.of();
            }
            URLClassLoader urlClassLoader = (URLClassLoader)contextClassLoader;
            return Arrays.stream(urlClassLoader.getURLs()).map(url -> new File(url.getFile())).toList();
        }

        private List<File> getJarsFromClassPath() {
            ArrayList<File> pathElements = new ArrayList<File>();
            String classPath = System.getProperty("java.class.path");
            StringTokenizer tok = new StringTokenizer(classPath, File.pathSeparator);
            while (tok.hasMoreTokens()) {
                String s = tok.nextToken();
                pathElements.add(new File(s));
            }
            return pathElements;
        }
    }
}

