/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.internal.service;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import com.mulesoft.connectivity.datacloud.internal.service.CachingService;
import com.mulesoft.connectivity.datacloud.internal.utils.HierarchicalPropertyResolver;
import java.util.concurrent.TimeUnit;
import java.util.function.UnaryOperator;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ConnectorCachingService
implements CachingService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConnectorCachingService.class);
    public static final String MAX_CACHE_SIZE_PROPERTY = "com.mulesoft.connectivity.datacloud.caching.maximumCacheSize";
    public static final String CACHE_EXPIRE_AFTER_MINUTES_PROPERTY = "com.mulesoft.connectivity.datacloud.caching.expireAfterMinutes";
    public static final long DEFAULT_MAX_CACHE_SIZE = 5000L;
    public static final long DEFAULT_CACHE_EXPIRE_AFTER_MINUTES = 30L;
    private final long maxCacheSize;
    private final long cacheExpireAfterMinutes;
    private final Cache<String, String> cache;
    private final String connectorName;

    ConnectorCachingService(String connectorName) {
        this.connectorName = connectorName;
        this.maxCacheSize = this.parseConfigValue(MAX_CACHE_SIZE_PROPERTY, 5000L);
        this.cacheExpireAfterMinutes = this.parseConfigValue(CACHE_EXPIRE_AFTER_MINUTES_PROPERTY, 30L);
        this.cache = this.buildCache();
    }

    private long parseConfigValue(String propertyName, long defaultValue) {
        try {
            long parsedValue;
            String value = HierarchicalPropertyResolver.getConfigValue(propertyName, this.connectorName);
            if (value != null && (parsedValue = Long.parseLong(value)) > 0L) {
                return parsedValue;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return defaultValue;
    }

    private Cache<String, String> buildCache() {
        log.info("Building cache with configuration: maxSize={}, expireAfterAccess={}min", (Object)this.maxCacheSize, (Object)this.cacheExpireAfterMinutes);
        return Caffeine.newBuilder().maximumSize(this.maxCacheSize).expireAfterAccess(this.cacheExpireAfterMinutes, TimeUnit.MINUTES).recordStats().build();
    }

    @Override
    public String getCachedValue(String key, UnaryOperator<String> computeFunction) {
        if (key.isEmpty()) {
            return key;
        }
        log.debug("Getting cached value for key: {}", (Object)key);
        return (String)this.cache.get((Object)key, computeFunction);
    }

    @Override
    public void clearCache() {
        this.cache.invalidateAll();
    }

    @Override
    public void invalidate(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return;
        }
        log.debug("Removing {} from cache", (Object)key);
        this.cache.invalidate((Object)key);
    }

    @Override
    public CacheStats getCacheStats() {
        return this.cache.stats();
    }

    @Override
    @Generated
    public long getMaxCacheSize() {
        return this.maxCacheSize;
    }
}

