/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.internal.utils;

import com.mulesoft.connectivity.datacloud.internal.utils.ObjectMappers;
import com.salesforce.dataconnectors.api.exception.ConnectorException;
import com.salesforce.dataconnectors.api.exception.ExceptionCategory;
import com.salesforce.dataconnectors.api.model.connection.ConnectionDefinition;
import com.salesforce.dataconnectors.api.model.execution.ExtractAttributes;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Utils.class);

    public static String mapToString(@Nullable Map<String, Object> map, boolean secured) {
        if (map == null) {
            return "null";
        }
        if (map.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder("{");
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            sb.append("\n    ").append(entry.getKey()).append(": ").append(secured ? "XXXX" : entry.getValue());
        }
        sb.append("\n  }");
        return sb.toString();
    }

    public static String listToString(@Nullable List<?> list) {
        if (list == null) {
            return "null";
        }
        if (list.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder("[");
        for (Object item : list) {
            sb.append("\n    ").append(item);
        }
        sb.append("\n  ]");
        return sb.toString();
    }

    public static ExtractAttributes getExtractAttributes(String connectorName) throws ConnectorException {
        ExtractAttributes extractAttributes;
        block8: {
            InputStream resource = Utils.getResourceStream(connectorName, "ExtractAttributes.json");
            try {
                extractAttributes = (ExtractAttributes)ObjectMappers.OBJECT_MAPPER.readValue(resource, ExtractAttributes.class);
                if (resource == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (resource != null) {
                        try {
                            resource.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ConnectorException("Error deserializing the ExtractAttributes file : " + e.getMessage(), (Throwable)e, ExceptionCategory.INTERNAL);
                }
            }
            resource.close();
        }
        return extractAttributes;
    }

    public static ConnectionDefinition getConnectionDefinition(String connectorName) throws ConnectorException {
        ConnectionDefinition connectionDefinition;
        block8: {
            InputStream resource = Utils.getResourceStream(connectorName, "ConnectionDefinition.json");
            try {
                connectionDefinition = (ConnectionDefinition)ObjectMappers.OBJECT_MAPPER.readValue(resource, ConnectionDefinition.class);
                if (resource == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (resource != null) {
                        try {
                            resource.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ConnectorException("Error deserializing the ConnectionDefinition file : " + e.getMessage(), (Throwable)e, ExceptionCategory.INTERNAL);
                }
            }
            resource.close();
        }
        return connectionDefinition;
    }

    private static InputStream getResourceStream(String connectorName, String resourceName) throws ConnectorException {
        String resourcePath = "com/mulesoft/connectivity/datacloud/connector/" + connectorName.toLowerCase(Locale.ROOT) + "/" + resourceName;
        InputStream stream = Utils.class.getClassLoader().getResourceAsStream(resourcePath);
        if (stream == null) {
            throw new ConnectorException(String.format("Resource %s not found: ", resourceName), ExceptionCategory.INTERNAL);
        }
        return stream;
    }

    private Utils() throws IllegalAccessException {
        throw new IllegalAccessException("Instantiation not allowed");
    }
}

