/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.internal.ratelimiter;

import com.mulesoft.connectivity.datacloud.api.model.RateLimitConfigurationModel;
import com.mulesoft.connectivity.datacloud.internal.operation.ExecutionParameters;
import com.mulesoft.connectivity.datacloud.internal.ratelimiter.RateLimiterUtils;
import com.mulesoft.connectivity.datacloud.internal.ratelimiter.RateLimitingConfiguration;
import com.mulesoft.connectivity.datacloud.internal.ratelimiter.RateLimitingPolicy;
import com.mulesoft.connectivity.datacloud.internal.service.ServiceProvider;
import com.mulesoft.connectivity.datacloud.internal.utils.HierarchicalPropertyResolver;
import com.salesforce.dataconnectors.api.context.ContextHelper;
import com.salesforce.dataconnectors.api.exception.ConnectorException;
import com.salesforce.dataconnectors.api.exception.ExceptionCategory;
import com.salesforce.dataconnectors.api.exception.InternalErrorCode;
import com.salesforce.dataconnectors.api.service.ConnectorServicesProvider;
import com.salesforce.dataconnectors.api.service.RateLimiter.RateLimiterService;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RateLimitingService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RateLimitingService.class);
    private static final String RATE_LIMITER_ENABLED_PROPERTY = "com.mulesoft.connectivity.datacloud.rateLimiter.enabled";

    private RateLimitingService() {
    }

    public static void execute(String connectorName, ExecutionParameters parameters, RateLimitingConfiguration configuration, RateLimitingPolicy policy) {
        boolean rateLimiterEnabled;
        if (policy == RateLimitingPolicy.DISABLED) {
            log.info("Rate limiting is disabled by policy, skipping");
            return;
        }
        String rateLimiterEnabledStr = HierarchicalPropertyResolver.getConfigValue(RATE_LIMITER_ENABLED_PROPERTY, connectorName);
        boolean bl = rateLimiterEnabled = rateLimiterEnabledStr == null || Boolean.parseBoolean(rateLimiterEnabledStr);
        if (!rateLimiterEnabled) {
            log.info("Rate limiting is disabled for connector {}, skipping", (Object)connectorName);
            return;
        }
        if (!configuration.hasEnabledConfigurations()) {
            log.info("No rate limit configurations found or all are disabled, skipping");
            return;
        }
        Map<String, Object> parametersMap = RateLimitingService.buildParametersMap(parameters);
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        for (RateLimitConfigurationModel rateLimitConfig : configuration.getAllConfigurations().values()) {
            if (!rateLimitConfig.isEnabled()) continue;
            Runnable runnable = ContextHelper.getContextAwareExecutorProvider().wrapRunnableTaskWithTraceContext(() -> RateLimitingService.acquireRateLimiterPermits(connectorName, rateLimitConfig, parametersMap));
            futures.add(CompletableFuture.runAsync(runnable, ServiceProvider.getThreadPoolService(connectorName).getExecutorService()));
        }
        if (!futures.isEmpty()) {
            log.debug("Waiting for {} rate limiter permits to be acquired", (Object)futures.size());
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
            log.debug("Successfully acquired all rate limiter permits");
        }
    }

    private static Map<String, Object> buildParametersMap(ExecutionParameters parameters) {
        LinkedHashMap<String, Object> parametersMap = new LinkedHashMap<String, Object>(parameters.getConnectionInfo());
        Object object = parameters.getParameters();
        if (object instanceof Map) {
            Map params = (Map)object;
            parametersMap.putAll(params);
        }
        parametersMap.put("operationName", parameters.getExecutableModel().getName());
        return parametersMap;
    }

    private static void acquireRateLimiterPermits(String connectorName, RateLimitConfigurationModel rateLimitConfig, Map<String, Object> parameters) {
        try {
            if (!rateLimitConfig.isEnabled()) {
                return;
            }
            RateLimiterService rateLimiterService = rateLimitConfig.isTenantScoped() ? ConnectorServicesProvider.getTenantScopedRateLimiterService() : ConnectorServicesProvider.getRateLimiterService();
            RateLimitingService.trySetAndAcquireLimiter(connectorName, rateLimitConfig, rateLimiterService, parameters);
        }
        catch (ConnectorException e) {
            log.warn("Rate limiter with id '{}' encountered an error. Continuing execution. Please review configuration values.", (Object)rateLimitConfig.getId(), (Object)e);
        }
    }

    private static void trySetAndAcquireLimiter(String connectorName, RateLimitConfigurationModel rateLimitConfig, RateLimiterService rateLimiterService, Map<String, Object> parameters) throws ConnectorException {
        String rateLimiterKey = RateLimiterUtils.buildRateLimiterKey(connectorName, rateLimitConfig, parameters);
        RateLimitConfigurationModel.RateModel rateModel = rateLimitConfig.getRate();
        log.debug("Setting rate for rate-limiter '{}': rate={}, interval={}, intervalUnit={}", new Object[]{rateLimiterKey, rateModel.value(), rateModel.interval(), rateModel.intervalUnit()});
        rateLimiterService.setOrUpdateRate(rateLimiterKey, rateModel.value(), rateModel.interval(), rateModel.intervalUnit());
        RateLimitConfigurationModel.RequestModel requestModel = rateLimitConfig.getRequest();
        log.debug("Trying to acquire {} permit(s) from rate-limiter '{}'. Timeout: {} {}", new Object[]{requestModel.permits(), rateLimiterKey, requestModel.timeoutValue(), requestModel.timeoutUnit()});
        boolean success = rateLimiterService.tryAcquire(rateLimiterKey, requestModel.permits(), requestModel.timeoutValue(), requestModel.timeoutUnit());
        if (!success) {
            throw new ConnectorException(String.format("Failed to acquire %s permit(s) from rate-limiter %s after %s %s", new Object[]{requestModel.permits(), rateLimiterKey, requestModel.timeoutValue(), requestModel.timeoutUnit()}), ExceptionCategory.RETRYABLE, InternalErrorCode.CONNECTOR_CUSTOM_ERROR);
        }
        log.debug("Successfully acquired {} permit(s) from rate-limiter '{}'", (Object)requestModel.permits(), (Object)rateLimiterKey);
    }
}

