/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.internal.auth;

import com.mulesoft.connectivity.datacloud.api.model.OperationType;
import com.mulesoft.connectivity.datacloud.internal.auth.AuthProvider;
import com.mulesoft.connectivity.datacloud.internal.auth.ClientCredentialsProvider;
import com.mulesoft.connectivity.datacloud.internal.auth.JwtBearerProvider;
import com.mulesoft.connectivity.datacloud.internal.auth.RefreshTokenProvider;
import com.mulesoft.connectivity.datacloud.internal.context.ExecutionContext;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthProviderFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthProviderFactory.class);
    private static final String AUTHORIZATION_CODE_PROVIDER = "AuthorizationCode";
    private static final String OPEN_ID_CONNECT_PROVIDER = "OPEN_ID_CONNECT";
    private static final String GOOGLE_DRIVE_PROVIDER = "GOOGLE";
    private static final String PROVIDER_TYPE_KEY = "providerType";
    private static final String REFRESH_TOKEN_KEY = "refreshToken";

    private AuthProviderFactory() {
    }

    public static @Nullable AuthProvider getAuthProvider(Map<String, Object> connectionAttributes) {
        String protocolType = Optional.ofNullable(connectionAttributes.get("protocolType")).map(Object::toString).map(String::toUpperCase).orElse("");
        OperationType operationType = ExecutionContext.getOperationType();
        log.debug("Creating AuthProvider - Protocol: {}, Operation: {}", (Object)protocolType, (Object)operationType);
        return switch (protocolType) {
            case "JWT_BEARER" -> JwtBearerProvider.builder().aud(connectionAttributes.getOrDefault("aud", "").toString()).iss(connectionAttributes.getOrDefault("iss", "").toString()).scope(connectionAttributes.getOrDefault("scope", "").toString()).privateKey(JwtBearerProvider.getPrivateKeyFromBase64(connectionAttributes.getOrDefault("jwtCertificate", "").toString())).tokenSubject(connectionAttributes.getOrDefault("token_subject", "").toString()).build();
            case "OAUTH_CC" -> ClientCredentialsProvider.builder().clientId(connectionAttributes.getOrDefault("clientId", "").toString()).scope(connectionAttributes.getOrDefault("scope", "").toString()).clientSecret(connectionAttributes.getOrDefault("clientSecret", "").toString()).tokenEndpoint(connectionAttributes.getOrDefault("tokenEndpoint", "").toString()).resource(connectionAttributes.getOrDefault("resource", "").toString()).resourcePrefix(connectionAttributes.getOrDefault("resourcePrefix", "").toString()).build();
            case "OAUTH" -> {
                String providerType = Optional.ofNullable(connectionAttributes.get(PROVIDER_TYPE_KEY)).map(Object::toString).orElse("");
                yield AuthProviderFactory.createOAuthRefreshTokenProvider(providerType, connectionAttributes);
            }
            default -> null;
        };
    }

    private static @Nullable RefreshTokenProvider createOAuthRefreshTokenProvider(String providerType, Map<String, Object> connectionAttributes) {
        OperationType operationType = ExecutionContext.getOperationType();
        log.debug("Processing OAUTH provider - ProviderType: {}, Operation: {}", (Object)providerType, (Object)operationType);
        if (!(AUTHORIZATION_CODE_PROVIDER.equalsIgnoreCase(providerType) || OPEN_ID_CONNECT_PROVIDER.equalsIgnoreCase(providerType) || GOOGLE_DRIVE_PROVIDER.equalsIgnoreCase(providerType))) {
            log.warn("Provider type '{}' not compatible with RefreshTokenProvider, returning null", (Object)providerType);
            return null;
        }
        if (operationType == OperationType.TEST_CONNECTION) {
            log.debug("Skipping RefreshTokenProvider creation for TEST_CONNECTION operation");
            return null;
        }
        String refreshToken = Optional.ofNullable(connectionAttributes.get(REFRESH_TOKEN_KEY)).map(Object::toString).filter(token -> !token.trim().isEmpty()).orElseThrow(() -> new IllegalArgumentException("Refresh token is required for " + providerType + " OAuth flow but was not provided or is empty"));
        log.debug("Creating RefreshTokenProvider for provider type: {}", (Object)providerType);
        return RefreshTokenProvider.builder().refreshToken(refreshToken).build();
    }
}

