/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.internal.config;

import com.mulesoft.connectivity.datacloud.internal.utils.HierarchicalPropertyResolver;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenManagerConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TokenManagerConfig.class);
    public static final String LOCK_TIMEOUT_SECONDS_PROPERTY = "com.mulesoft.connectivity.datacloud.token.lockTimeoutSeconds";
    public static final String MAX_RETRY_ATTEMPTS_PROPERTY = "com.mulesoft.connectivity.datacloud.token.maxRetryAttempts";
    public static final String RETRY_DELAY_MS_PROPERTY = "com.mulesoft.connectivity.datacloud.token.retryDelayMs";
    public static final long DEFAULT_LOCK_TIMEOUT_SECONDS = 30L;
    public static final int DEFAULT_MAX_RETRY_ATTEMPTS = 3;
    public static final long DEFAULT_RETRY_DELAY_MS = 1000L;
    private final String connectorName;

    public TokenManagerConfig(String connectorName) {
        this.connectorName = connectorName;
    }

    public long getLockTimeoutSeconds() {
        return this.parseConfigValue(LOCK_TIMEOUT_SECONDS_PROPERTY, 30L);
    }

    public int getMaxRetryAttempts() {
        return this.parseConfigValue(MAX_RETRY_ATTEMPTS_PROPERTY, 3);
    }

    public long getRetryDelayMs() {
        return this.parseConfigValue(RETRY_DELAY_MS_PROPERTY, 1000L);
    }

    public void logConfiguration() {
        log.info("Token manager configuration for connector '{}':", (Object)this.connectorName);
        log.info("  - Lock timeout: {} seconds", (Object)this.getLockTimeoutSeconds());
        log.info("  - Max retry attempts: {}", (Object)this.getMaxRetryAttempts());
        log.info("  - Retry delay: {} ms", (Object)this.getRetryDelayMs());
        log.info("  - Token refresh: Handled by cache expiry period");
    }

    private long parseConfigValue(String propertyName, long defaultValue) {
        try {
            long parsedValue;
            String value = HierarchicalPropertyResolver.getConfigValue(propertyName, this.connectorName);
            if (value != null && (parsedValue = Long.parseLong(value.trim())) > 0L) {
                return parsedValue;
            }
        }
        catch (NumberFormatException ignored) {
            log.warn("Invalid value for property {}: {}", (Object)propertyName, (Object)this.connectorName);
        }
        return defaultValue;
    }

    private int parseConfigValue(String propertyName, int defaultValue) {
        try {
            int parsedValue;
            String value = HierarchicalPropertyResolver.getConfigValue(propertyName, this.connectorName);
            if (value != null && (parsedValue = Integer.parseInt(value)) > 0) {
                return parsedValue;
            }
        }
        catch (NumberFormatException ignored) {
            log.warn("Invalid value for property {}: {}", (Object)propertyName, (Object)HierarchicalPropertyResolver.getConfigValue(propertyName, this.connectorName));
        }
        return defaultValue;
    }
}

