/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.internal.context;

import com.mulesoft.connectivity.datacloud.api.model.OperationType;
import com.mulesoft.connectivity.datacloud.internal.context.ExecutionContextSnapshot;
import com.mulesoft.connectivity.datacloud.internal.utils.FeatureGates;
import com.salesforce.dataconnectors.api.service.ConnectorServicesProvider;
import com.salesforce.dataconnectors.api.service.gates.GateService;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import org.jspecify.annotations.Nullable;

public class ExecutionContext {
    private static final ThreadLocal<Map<String, Object>> CONTEXT = ThreadLocal.withInitial(ConcurrentHashMap::new);
    private static final String GATE_PREFIX = "gate:";

    private ExecutionContext() {
    }

    public static void set(String key, Object value) {
        if (key == null || value == null) {
            throw new IllegalArgumentException("Key/Value cannot be null");
        }
        CONTEXT.get().put(key, value);
    }

    public static Object get(String key) {
        if (key == null) {
            return null;
        }
        return CONTEXT.get().get(key);
    }

    public static <T> @Nullable T get(String key, Class<T> type) {
        Object value = ExecutionContext.get(key);
        if (type.isInstance(value)) {
            return (T)value;
        }
        return null;
    }

    public static Object remove(String key) {
        if (key == null) {
            return null;
        }
        return CONTEXT.get().remove(key);
    }

    public static boolean contains(String key) {
        if (key == null) {
            return false;
        }
        return CONTEXT.get().containsKey(key);
    }

    public static Set<String> getKeys() {
        return CONTEXT.get().keySet();
    }

    public static int size() {
        return CONTEXT.get().size();
    }

    public static boolean isEmpty() {
        return CONTEXT.get().isEmpty();
    }

    public static void clear() {
        CONTEXT.get().clear();
    }

    public static void remove() {
        CONTEXT.remove();
    }

    public static void refreshGateValues(List<FeatureGates> featureGates) {
        GateService gateService = ConnectorServicesProvider.getGateService();
        featureGates.forEach(f -> ExecutionContext.setGateValue(f, gateService.isOpen(f.getGateName())));
    }

    public static void setGateValue(FeatureGates gate, boolean value) {
        ExecutionContext.set(GATE_PREFIX + gate.getGateName(), value);
    }

    public static boolean getGateValue(FeatureGates gate) {
        Boolean value = ExecutionContext.get(GATE_PREFIX + gate.getGateName(), Boolean.class);
        return value != null && value != false;
    }

    public static void setConnectorName(String connectorName) {
        if (connectorName == null) {
            throw new IllegalArgumentException("Connector name cannot be null");
        }
        ExecutionContext.set("connectorName", connectorName);
    }

    public static String getConnectorName() {
        return ExecutionContext.get("connectorName", String.class);
    }

    public static void setOperationType(OperationType operationType) {
        if (operationType == null) {
            throw new IllegalArgumentException("Operation type cannot be null");
        }
        ExecutionContext.set("operationType", (Object)operationType);
    }

    public static OperationType getOperationType() {
        return ExecutionContext.get("operationType", OperationType.class);
    }

    public static Map<String, Object> getAll() {
        return new ConcurrentHashMap<String, Object>(CONTEXT.get());
    }

    public static ExecutionContextSnapshot capture() {
        return new ExecutionContextSnapshot(new ConcurrentHashMap<String, Object>(CONTEXT.get()));
    }

    public static void restore(ExecutionContextSnapshot snapshot) {
        if (snapshot != null) {
            snapshot.restore();
        }
    }

    public static Runnable wrapWithContext(Runnable runnable) {
        ExecutionContextSnapshot snapshot = ExecutionContext.capture();
        return () -> {
            ExecutionContextSnapshot previousSnapshot = ExecutionContext.capture();
            try {
                ExecutionContext.restore(snapshot);
                runnable.run();
            }
            finally {
                ExecutionContext.restore(previousSnapshot);
            }
        };
    }

    public static <T> Callable<T> wrapWithContext(Callable<T> callable) {
        ExecutionContextSnapshot snapshot = ExecutionContext.capture();
        return () -> {
            ExecutionContextSnapshot previousSnapshot = ExecutionContext.capture();
            try {
                ExecutionContext.restore(snapshot);
                Object v = callable.call();
                return v;
            }
            finally {
                ExecutionContext.restore(previousSnapshot);
            }
        };
    }
}

