/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.datacloud.internal.operation;

import com.mulesoft.connectivity.datacloud.api.model.DataCloudConnectionModel;
import com.mulesoft.connectivity.datacloud.api.model.DataCloudConnectorModel;
import com.mulesoft.connectivity.datacloud.internal.context.ExecutionContext;
import com.mulesoft.connectivity.datacloud.internal.ratelimiter.RateLimitingPolicy;
import com.mulesoft.connectivity.datacloud.internal.retry.RetryConfiguration;
import com.mulesoft.connectivity.datacloud.internal.service.ServiceProvider;
import com.mulesoft.connectivity.linkweave.api.interpreter.ModelInterpreter;
import com.salesforce.dataconnectors.api.context.ContextHelper;
import com.salesforce.dataconnectors.api.exception.ConnectorException;
import com.salesforce.dataconnectors.api.exception.ExceptionCategory;
import com.salesforce.dataconnectors.api.model.input.InputAttributes;
import java.util.Deque;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

abstract class DataIterator<T> {
    final ModelInterpreter modelInterpreter;
    final DataCloudConnectorModel connectorModel;
    final String objectName;
    final InputAttributes inputAttributes;
    final DataCloudConnectionModel connectionModel;
    protected final RetryConfiguration retryConfiguration;
    protected final RateLimitingPolicy rateLimitingPolicy;
    private final Deque<T> elementsToBeConsumed = new ConcurrentLinkedDeque<T>();
    private final CompletableFuture<Void> extractorTask;

    DataIterator(ModelInterpreter modelInterpreter, DataCloudConnectorModel connectorModel, String objectName, InputAttributes inputAttributes, DataCloudConnectionModel connectionModel, RetryConfiguration retryConfiguration, RateLimitingPolicy rateLimitingPolicy) {
        this.modelInterpreter = modelInterpreter;
        this.connectorModel = connectorModel;
        this.objectName = objectName;
        this.inputAttributes = inputAttributes;
        this.connectionModel = connectionModel;
        this.retryConfiguration = retryConfiguration;
        this.rateLimitingPolicy = rateLimitingPolicy;
        Runnable runnableWithTrace = ContextHelper.getContextAwareExecutorProvider().wrapRunnableTaskWithTraceContext(this::doExtract);
        Runnable runnableWithContext = ExecutionContext.wrapWithContext(runnableWithTrace);
        this.extractorTask = CompletableFuture.runAsync(runnableWithContext, ServiceProvider.getThreadPoolService(connectorModel.getName()).getExecutorService());
    }

    abstract void doExtract();

    public void consumeData(T data) {
        this.elementsToBeConsumed.add(data);
    }

    T nextData() {
        return this.elementsToBeConsumed.pop();
    }

    void cancel() {
        this.extractorTask.cancel(true);
    }

    boolean hasMoreData(long timeOutInMillis) throws ConnectorException {
        do {
            if (!this.elementsToBeConsumed.isEmpty()) {
                return true;
            }
            try {
                this.extractorTask.get(timeOutInMillis, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ConnectorException((Throwable)e, ExceptionCategory.INTERNAL);
            }
            catch (ExecutionException e) {
                throw new ConnectorException((Throwable)e, ExceptionCategory.INTERNAL);
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
        } while (!this.extractorTask.isDone());
        return !this.elementsToBeConsumed.isEmpty();
    }
}

